/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;

public final class Action {
    public static final char PATH_SEPARATOR = '/';
    public static final char MULTI_MARKER = '*';
    public static final char FRAGMENT_START = '#';
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Type type;
    private final boolean isMulti;
    private final String[] path;
    private final String fragment;

    public Action(Type type, boolean isMulti, String[] path, String fragment) {
        if (type == null) {
            throw new IllegalArgumentException("Action type must not be null.");
        }
        this.type = type;
        this.isMulti = isMulti;
        if (path != null) {
            this.path = new String[path.length];
            int i = 0;
            while (i < path.length) {
                this.path[i] = path[i] != null ? path[i] : "";
                ++i;
            }
        } else {
            this.path = EMPTY_STRING_ARRAY;
        }
        this.fragment = fragment == null || fragment.trim().length() == 0 ? null : fragment.trim();
    }

    public Action(Type type, boolean isMulti, String[] path) {
        this(type, isMulti, path, null);
    }

    public Action(Type type, boolean isMulti) {
        this(type, isMulti, null, null);
    }

    public Action(Type type) {
        this(type, false, null, null);
    }

    public static Action parse(String value) throws ParseException {
        if (value == null) {
            throw new NullPointerException();
        }
        char[] chars = value.trim().toCharArray();
        if (chars.length == 0) {
            throw new ParseException("Empty string", 0);
        }
        int pos = 0;
        String type = "";
        while (pos < chars.length && Character.isLetter(chars[pos])) {
            type = String.valueOf(type) + chars[pos++];
        }
        while (pos < chars.length && Character.isWhitespace(chars[pos])) {
            ++pos;
        }
        boolean isMulti = false;
        if (pos < chars.length && chars[pos] == '*') {
            isMulti = true;
            ++pos;
        }
        while (pos < chars.length && Character.isWhitespace(chars[pos])) {
            ++pos;
        }
        String[] path = EMPTY_STRING_ARRAY;
        if (pos < chars.length && chars[pos] == '/') {
            ++pos;
            ArrayList<String> pathList = new ArrayList<String>();
            pathList.add("");
            while (pos < chars.length) {
                if (Character.isJavaIdentifierPart(chars[pos])) {
                    String newValue = String.valueOf((String)pathList.get(pathList.size() - 1)) + chars[pos];
                    pathList.set(pathList.size() - 1, newValue);
                } else {
                    if (chars[pos] != '/') break;
                    pathList.add("");
                }
                ++pos;
            }
            path = pathList.toArray(path);
        }
        String fragment = null;
        if (pos < chars.length && chars[pos] == '#') {
            fragment = "";
            ++pos;
            while (pos < chars.length && Character.isJavaIdentifierPart(chars[pos])) {
                fragment = String.valueOf(fragment) + chars[pos++];
            }
        }
        if (pos < chars.length) {
            throw new ParseException("Unexpected character at position " + pos, pos);
        }
        return new Action(Type.parse(type), isMulti, path, fragment);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isMulti() {
        return this.isMulti;
    }

    public String[] getPath() {
        return Arrays.copyOf(this.path, this.path.length);
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean hasSameType(Action action) {
        return this.type == action.type;
    }

    public boolean hasSameMultiFlag(Action action) {
        return this.isMulti == action.isMulti;
    }

    public boolean hasSamePath(Action action) {
        return Arrays.equals(this.path, action.path);
    }

    public boolean hasSameFragment(Action action) {
        if (this.fragment == null) {
            return action.fragment == null;
        }
        return this.fragment.equals(action.fragment);
    }

    public int hashCode() {
        int hash = this.type.hashCode();
        String[] stringArray = this.path;
        int n = this.path.length;
        int n2 = 0;
        while (n2 < n) {
            String elem = stringArray[n2];
            hash = hash + elem.hashCode() << 1;
            ++n2;
        }
        if (this.isMulti) {
            ++hash;
        }
        if (this.fragment != null) {
            hash += this.fragment.hashCode();
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Action) {
            Action action = (Action)object;
            return this.hasSameType(action) && this.hasSameMultiFlag(action) && this.hasSamePath(action) && this.hasSameFragment(action);
        }
        return false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.type.toString());
        if (this.isMulti) {
            result.append('*');
        }
        if (this.path.length > 0) {
            int i = 0;
            while (i < this.path.length) {
                result.append('/');
                result.append(this.path[i]);
                ++i;
            }
        }
        if (this.fragment != null) {
            result.append('#');
            result.append(this.fragment);
        }
        return result.toString();
    }

    public static enum Type {
        PRESERVE,
        CREATE,
        DELETE,
        FORBID,
        REQUIRE;

        public static final String ALT_REMOVE = "remove";
        public static final String ALT_NEW = "new";
        public static final String ALT_SET = "set";
        public static final String ALT_NONE = "none";

        public static Type parse(String value) throws ParseException {
            value = value.trim();
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                if (type.name().equalsIgnoreCase(value)) {
                    return type;
                }
                ++n2;
            }
            if (ALT_REMOVE.equalsIgnoreCase(value)) {
                return DELETE;
            }
            if (ALT_NEW.equalsIgnoreCase(value) || ALT_SET.equalsIgnoreCase(value)) {
                return CREATE;
            }
            if (ALT_NONE.equalsIgnoreCase(value)) {
                return PRESERVE;
            }
            throw new ParseException("Unknown action type: " + value, 0);
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

