/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.wrapper;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.henshin.model.Annotation;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.ModelElement;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class VariabilityTransactionHelper {
    private VariabilityTransactionHelper() {
    }

    static Annotation addAnnotation(ModelElement modelElement, String key, String value) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)modelElement);
        if (domain == null) {
            ResourceSetImpl resSet = new ResourceSetImpl();
            resSet.createResource(modelElement.eResource().getURI());
            domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)resSet);
        }
        Annotation anno = HenshinFactory.eINSTANCE.createAnnotation();
        anno.setKey(key);
        anno.setValue(value);
        try {
            modelElement.getAnnotations().add((Object)anno);
        }
        catch (IllegalStateException illegalStateException) {}
        return anno;
    }

    public static void setAnnotationValue(ModelElement modelElement, String key, String value) {
        Annotation anno = VariabilityTransactionHelper.getAnnotation(modelElement, key);
        if (anno != null && anno.getValue() != null && !anno.getValue().equals(value)) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)modelElement);
            if (domain == null) {
                ResourceSetImpl resSet = new ResourceSetImpl();
                resSet.createResource(modelElement.eResource().getURI());
                domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)resSet);
            }
            Command command = SetCommand.create((EditingDomain)domain, (Object)anno, (Object)HenshinPackage.Literals.ANNOTATION__VALUE, (Object)value);
            CommandStack stack = domain.getCommandStack();
            try {
                stack.execute(command);
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    private static Annotation getAnnotation(ModelElement modelElement, String key) {
        if (modelElement.getAnnotations() != null) {
            for (Annotation anno : modelElement.getAnnotations()) {
                if (!anno.getKey().equals(key)) continue;
                return anno;
            }
        }
        return null;
    }
}

