/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.wrapper;

import aima.core.logic.common.ParserException;
import aima.core.logic.propositional.parsing.ast.PropositionSymbol;
import aima.core.logic.propositional.parsing.ast.Sentence;
import aima.core.logic.propositional.visitors.SymbolCollector;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Annotation;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.AttributeCondition;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.ModelElement;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.impl.HenshinFactoryImpl;
import org.eclipse.emf.henshin.variability.matcher.FeatureExpression;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityTransactionHelper;

public class VariabilityRule
implements Rule {
    final Rule rule;
    final Annotation featureModel;
    final Annotation injectiveMatchingPresenceCondition;
    final Annotation features;
    String oldFeatureModel = "";
    String oldFeatures = "";
    List<String> missingFeatures = new ArrayList<String>();

    VariabilityRule() {
        this(HenshinFactoryImpl.eINSTANCE.createRule());
    }

    VariabilityRule(String name) {
        this(HenshinFactoryImpl.eINSTANCE.createRule(name));
    }

    VariabilityRule(Rule rule) {
        this.rule = rule;
        Annotation featModel = null;
        Annotation injMatPreCon = null;
        Annotation feats = null;
        EList annos = rule.getAnnotations();
        for (Annotation anno : annos) {
            String key = anno.getKey();
            if (key.equals("featureModel")) {
                featModel = anno;
            } else if (key.equals("injectiveMatchingPresenceCondition")) {
                injMatPreCon = anno;
            } else if (key.equals("features")) {
                feats = anno;
            }
            if (featModel != null && injMatPreCon != null && feats != null) break;
        }
        this.featureModel = featModel != null ? featModel : VariabilityTransactionHelper.addAnnotation((ModelElement)rule, "featureModel", "");
        this.injectiveMatchingPresenceCondition = injMatPreCon != null ? injMatPreCon : VariabilityTransactionHelper.addAnnotation((ModelElement)rule, "injectiveMatchingPresenceCondition", "");
        this.features = feats != null ? feats : VariabilityTransactionHelper.addAnnotation((ModelElement)rule, "features", "");
    }

    public String getFeatureModel() {
        return this.featureModel.getValue();
    }

    public void setFeatureModel(String featureModelString) {
        this.featureModel.setValue(featureModelString);
    }

    public String getInjectiveMatchingPresenceCondition() {
        return this.injectiveMatchingPresenceCondition.getValue();
    }

    public void setInjectiveMatchingPresenceCondition(String condition) {
        this.injectiveMatchingPresenceCondition.setValue(condition);
    }

    public List<String> getFeatures() {
        if (this.features.getValue() == null) {
            return null;
        }
        if (!this.features.getValue().isEmpty()) {
            List<String> featureList = Arrays.asList(this.features.getValue().split(","));
            ArrayList<String> result = new ArrayList<String>();
            for (String string : featureList) {
                result.add(string.trim());
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.unmodifiableList(new ArrayList());
    }

    public void setFeatures(String featureString) {
        this.features.setValue(featureString);
    }

    public void setFeatures(List<String> featureList) {
        for (String feature : featureList) {
            this.addFeature(feature);
        }
    }

    public void addFeature(String feature) {
        if (this.features.getValue() == null) {
            this.features.setValue("");
        }
        String featuresString = this.features.getValue();
        featuresString = String.valueOf(featuresString) + (featuresString.length() > 0 ? "," + this.features : this.features);
        this.features.setValue(featuresString);
    }

    public void removeFeature(String feature) {
        if (this.features.getValue() == null) {
            return;
        }
        ArrayList<String> featureList = new ArrayList<String>(Arrays.asList(this.features.getValue().split(",")));
        featureList.remove(feature);
        this.features.setValue(String.join((CharSequence)",", featureList));
    }

    public boolean hasMissingFeatures() {
        this.calculateMissingFeatureNames();
        return this.missingFeatures == null || !this.missingFeatures.isEmpty();
    }

    public String[] getMissingFeatures() {
        this.calculateMissingFeatureNames();
        return this.missingFeatures.toArray(new String[0]);
    }

    private void calculateMissingFeatureNames() {
        String currentModel = this.getFeatureModel();
        if (!currentModel.trim().equals(this.oldFeatureModel) || !this.oldFeatures.equals(this.features.getValue())) {
            try {
                Sentence sentence = FeatureExpression.getExpr(currentModel);
                this.missingFeatures.clear();
                Set symbols = SymbolCollector.getSymbolsFrom((Sentence[])new Sentence[]{sentence});
                List<String> definedFeatures = this.getFeatures();
                for (PropositionSymbol symbol : symbols) {
                    String symbolName = symbol.getSymbol();
                    if (definedFeatures.contains(symbolName)) continue;
                    this.missingFeatures.add(symbolName);
                }
            }
            catch (ParserException parserException) {}
            this.oldFeatureModel = currentModel.trim();
            this.oldFeatures = this.features.getValue();
        }
    }

    public boolean canCreateEdge(Node arg0, Node arg1, EReference arg2) {
        return this.rule.canCreateEdge(arg0, arg1, arg2);
    }

    public Edge createEdge(Node arg0, Node arg1, EReference arg2) {
        return this.rule.createEdge(arg0, arg1, arg2);
    }

    public Node createNode(EClass arg0) {
        return this.rule.createNode(arg0);
    }

    public EList<Adapter> eAdapters() {
        return this.rule.eAdapters();
    }

    public boolean eDeliver() {
        return this.rule.eDeliver();
    }

    public void eSetDeliver(boolean deliver) {
        this.rule.eSetDeliver(deliver);
    }

    public void eNotify(Notification notification) {
        this.rule.eNotify(notification);
    }

    public EClass eClass() {
        return this.rule.eClass();
    }

    public Resource eResource() {
        return this.rule.eResource();
    }

    public EObject eContainer() {
        return this.rule.eContainer();
    }

    public EStructuralFeature eContainingFeature() {
        return this.rule.eContainingFeature();
    }

    public EReference eContainmentFeature() {
        return this.rule.eContainmentFeature();
    }

    public EList<EObject> eContents() {
        return this.rule.eContents();
    }

    public TreeIterator<EObject> eAllContents() {
        return this.rule.eAllContents();
    }

    public boolean eIsProxy() {
        return this.rule.eIsProxy();
    }

    public EList<EObject> eCrossReferences() {
        return this.rule.eCrossReferences();
    }

    public Object eGet(EStructuralFeature feature) {
        return this.rule.eGet(feature);
    }

    public Object eGet(EStructuralFeature feature, boolean resolve) {
        return this.rule.eGet(feature, resolve);
    }

    public void eSet(EStructuralFeature feature, Object newValue) {
        this.rule.eSet(feature, newValue);
    }

    public boolean eIsSet(EStructuralFeature feature) {
        return this.rule.eIsSet(feature);
    }

    public void eUnset(EStructuralFeature feature) {
        this.rule.eUnset(feature);
    }

    public Object eInvoke(EOperation operation, EList<?> arguments) throws InvocationTargetException {
        return this.rule.eInvoke(operation, arguments);
    }

    public EList<Edge> getActionEdges(Action arg0) {
        return this.rule.getActionEdges(arg0);
    }

    public EList<Node> getActionNodes(Action arg0) {
        return this.rule.getActionNodes(arg0);
    }

    public EList<String> getAllJavaImports() {
        return this.rule.getAllJavaImports();
    }

    public MappingList getAllMappings() {
        return this.rule.getAllMappings();
    }

    public EList<Rule> getAllMultiRules() {
        return this.rule.getAllMultiRules();
    }

    public EList<Annotation> getAnnotations() {
        return this.rule.getAnnotations();
    }

    public EList<AttributeCondition> getAttributeConditions() {
        return this.rule.getAttributeConditions();
    }

    public String getDescription() {
        return this.rule.getDescription();
    }

    public EList<String> getJavaImports() {
        return this.rule.getJavaImports();
    }

    public Rule getKernelRule() {
        return this.rule.getKernelRule();
    }

    public Graph getLhs() {
        return this.rule.getLhs();
    }

    public MappingList getMappings() {
        return this.rule.getMappings();
    }

    public Module getModule() {
        return this.rule.getModule();
    }

    public MappingList getMultiMappings() {
        return this.rule.getMultiMappings();
    }

    public Rule getMultiRule(String arg0) {
        return this.rule.getMultiRule(arg0);
    }

    public EList<Rule> getMultiRulePath(Rule arg0) {
        return this.rule.getMultiRulePath(arg0);
    }

    public EList<Rule> getMultiRules() {
        return this.rule.getMultiRules();
    }

    public String getName() {
        return this.rule.getName();
    }

    public Parameter getParameter(String arg0) {
        return this.rule.getParameter(arg0);
    }

    public EList<ParameterMapping> getParameterMappings() {
        return this.rule.getParameterMappings();
    }

    public EList<Node> getParameterNodes() {
        return this.rule.getParameterNodes();
    }

    public EList<Parameter> getParameters() {
        return this.rule.getParameters();
    }

    public Graph getRhs() {
        return this.rule.getRhs();
    }

    public Rule getRootRule() {
        return this.rule.getRootRule();
    }

    public EList<Unit> getSubUnits(boolean arg0) {
        return this.rule.getSubUnits(arg0);
    }

    public boolean isActivated() {
        return this.rule.isActivated();
    }

    public boolean isCheckDangling() {
        return this.rule.isCheckDangling();
    }

    public boolean isInjectiveMatching() {
        return this.rule.isInjectiveMatching();
    }

    public boolean isMultiRule() {
        return this.rule.isMultiRule();
    }

    public boolean removeAttribute(Attribute arg0, boolean arg1) {
        return this.rule.removeAttribute(arg0, arg1);
    }

    public boolean removeEdge(Edge arg0, boolean arg1) {
        return this.rule.removeEdge(arg0, arg1);
    }

    public boolean removeNode(Node arg0, boolean arg1) {
        return this.rule.removeNode(arg0, arg1);
    }

    public void setActivated(boolean arg0) {
        this.rule.setActivated(arg0);
    }

    public void setCheckDangling(boolean arg0) {
        this.rule.setCheckDangling(arg0);
    }

    public void setDescription(String arg0) {
        this.rule.setDescription(arg0);
    }

    public void setInjectiveMatching(boolean arg0) {
        this.rule.setInjectiveMatching(arg0);
    }

    public void setLhs(Graph arg0) {
        this.rule.setLhs(arg0);
    }

    public void setName(String arg0) {
        this.rule.setName(arg0);
    }

    public void setRhs(Graph arg0) {
        this.rule.setRhs(arg0);
    }

    public int hashCode() {
        return this.rule.hashCode();
    }

    public boolean equals(Object obj) {
        return this.rule.equals(obj);
    }
}

