/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Annotation;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.ModelElement;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.impl.HenshinFactoryImpl;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityGraphElement;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityTransactionHelper;

public class VariabilityNode
implements Node,
VariabilityGraphElement {
    final Node node;
    final Annotation presenceCondition;

    static Annotation addVariabilityToNode(Node node) {
        EList annos = node.getAnnotations();
        Iterator it = annos.iterator();
        Annotation pc = null;
        while (it.hasNext()) {
            Annotation anno = (Annotation)it.next();
            if (!anno.getKey().equals("presenceCondition")) continue;
            pc = anno;
            break;
        }
        if (pc != null) {
            return pc;
        }
        return VariabilityTransactionHelper.addAnnotation((ModelElement)node, "presenceCondition", "");
    }

    VariabilityNode() {
        this(HenshinFactoryImpl.eINSTANCE.createNode());
    }

    VariabilityNode(Graph graph, EClass type, String name) {
        this(HenshinFactoryImpl.eINSTANCE.createNode(graph, type, name));
    }

    VariabilityNode(Node node) {
        this.node = node;
        this.presenceCondition = VariabilityNode.addVariabilityToNode(node);
    }

    @Override
    public GraphElement getGraphElement() {
        return this.node;
    }

    @Override
    public String getPresenceCondition() {
        return this.presenceCondition.getValue();
    }

    @Override
    public void setPresenceCondition(String condition) {
        this.presenceCondition.setValue(condition);
    }

    public EList<Adapter> eAdapters() {
        return this.node.eAdapters();
    }

    public boolean eDeliver() {
        return this.node.eDeliver();
    }

    public void eSetDeliver(boolean deliver) {
        this.node.eSetDeliver(deliver);
    }

    public void eNotify(Notification notification) {
        this.node.eNotify(notification);
    }

    public EClass eClass() {
        return this.node.eClass();
    }

    public Resource eResource() {
        return this.node.eResource();
    }

    public EObject eContainer() {
        return this.node.eContainer();
    }

    public EStructuralFeature eContainingFeature() {
        return this.node.eContainingFeature();
    }

    public EReference eContainmentFeature() {
        return this.node.eContainmentFeature();
    }

    public EList<EObject> eContents() {
        return this.node.eContents();
    }

    public TreeIterator<EObject> eAllContents() {
        return this.node.eAllContents();
    }

    public boolean eIsProxy() {
        return this.node.eIsProxy();
    }

    public EList<EObject> eCrossReferences() {
        return this.node.eCrossReferences();
    }

    public Object eGet(EStructuralFeature feature) {
        return this.node.eGet(feature);
    }

    public Object eGet(EStructuralFeature feature, boolean resolve) {
        return this.node.eGet(feature, resolve);
    }

    public void eSet(EStructuralFeature feature, Object newValue) {
        this.node.eSet(feature, newValue);
    }

    public boolean eIsSet(EStructuralFeature feature) {
        return this.node.eIsSet(feature);
    }

    public void eUnset(EStructuralFeature feature) {
        this.node.eUnset(feature);
    }

    public Object eInvoke(EOperation operation, EList<?> arguments) throws InvocationTargetException {
        return this.node.eInvoke(operation, arguments);
    }

    public Action getAction() {
        return this.node.getAction();
    }

    public EList<Attribute> getActionAttributes(Action arg0) {
        return this.node.getActionAttributes(arg0);
    }

    public Node getActionNode() {
        return this.node.getActionNode();
    }

    public EList<Edge> getAllEdges() {
        return this.node.getAllEdges();
    }

    public EList<Annotation> getAnnotations() {
        return this.node.getAnnotations();
    }

    public Attribute getAttribute(EAttribute arg0) {
        return this.node.getAttribute(arg0);
    }

    public EList<Attribute> getAttributes() {
        return this.node.getAttributes();
    }

    public String getDescription() {
        return this.node.getDescription();
    }

    public Graph getGraph() {
        return this.node.getGraph();
    }

    public EList<Edge> getIncoming() {
        return this.node.getIncoming();
    }

    public Edge getIncoming(EReference arg0, Node arg1) {
        return this.node.getIncoming(arg0, arg1);
    }

    public EList<Edge> getIncoming(EReference arg0) {
        return this.node.getIncoming(arg0);
    }

    public String getName() {
        return this.node.getName();
    }

    public EList<Edge> getOutgoing() {
        return this.node.getOutgoing();
    }

    public Edge getOutgoing(EReference arg0, Node arg1) {
        return this.node.getOutgoing(arg0, arg1);
    }

    public EList<Edge> getOutgoing(EReference arg0) {
        return this.node.getOutgoing(arg0);
    }

    public EClass getType() {
        return this.node.getType();
    }

    public void setAction(Action arg0) {
        this.node.setAction(arg0);
    }

    public void setDescription(String arg0) {
        this.node.setDescription(arg0);
    }

    public void setGraph(Graph arg0) {
        this.node.setGraph(arg0);
    }

    public void setName(String arg0) {
        this.node.setName(arg0);
    }

    public void setType(EClass arg0) {
        this.node.setType(arg0);
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public boolean equals(Object obj) {
        return this.node.equals(obj);
    }
}

