/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.matcher;

import aima.core.logic.propositional.parsing.ast.Sentence;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.matcher.VariabilityAwareEngine;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityFactory;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityGraphElement;

public class RulePreparator {
    public Rule rule;
    public boolean checkDangling;
    private boolean injectiveMatching;
    private boolean injectiveMatchingOriginal;
    private boolean baseRule;
    public HashSet<Node> removeNodes;
    public HashSet<Edge> removeEdges;
    public HashSet<Attribute> removeAttributes;
    public Map<Edge, Node> removeEdgeSources;
    public Map<Edge, Node> removeEdgeTargets;
    public Set<Mapping> removeMappings;
    public HashMap<EObject, EObject> removeElementContainers;
    public HashSet<Formula> removeFormulas;
    public HashMap<Mapping, EStructuralFeature> removeMappingContainingRef;
    public HashMap<Formula, EStructuralFeature> removeFormulaContainingRef;
    public HashMap<Formula, EObject> pulledUpFormulasToContainer;
    public HashMap<Formula, EStructuralFeature> pulledUpFormulasToContainingRef;
    public HashMap<Formula, EObject> pulledUpFormulasToOldContainer;
    public HashMap<Formula, EStructuralFeature> pulledUpFormulasToOldContainingRef;

    public RulePreparator(Rule rule) {
        this.rule = rule;
        this.checkDangling = rule.isCheckDangling();
    }

    public BitSet prepare(VariabilityAwareEngine.RuleInfo ruleInfo, Set<Sentence> rejected, boolean injectiveMatching, boolean baseRule) {
        this.baseRule = baseRule;
        this.injectiveMatching = injectiveMatching;
        this.injectiveMatchingOriginal = ruleInfo.rule.isInjectiveMatching();
        this.removeElementContainers = new HashMap();
        this.removeNodes = new HashSet();
        this.removeEdges = new HashSet();
        this.removeAttributes = new HashSet();
        this.removeEdgeSources = new HashMap<Edge, Node>();
        this.removeEdgeTargets = new HashMap<Edge, Node>();
        this.removeMappings = new HashSet<Mapping>();
        this.removeMappingContainingRef = new HashMap();
        this.removeFormulaContainingRef = new HashMap();
        this.removeFormulas = new HashSet();
        this.fillMaps(ruleInfo, rejected);
        BitSet bs = this.getRepresentation(this.rule, this.removeAttributes, this.removeNodes, this.removeEdges, this.removeFormulas, injectiveMatching);
        this.doPreparation();
        return bs;
    }

    private <T extends GraphElement> void addElementToRemoveList(boolean geIsVariabilityAware, GraphElement ge, Collection<T> list) {
        if (geIsVariabilityAware) {
            list.add(((VariabilityGraphElement)ge).getGraphElement());
        } else {
            list.add(ge);
        }
    }

    private void fillMaps(VariabilityAwareEngine.RuleInfo ruleInfo, Set<Sentence> rejected) {
        for (Sentence expr : rejected) {
            for (GraphElement ge : ruleInfo.getPc2Elem().get(expr)) {
                boolean geIsVariabilityAware = ge instanceof VariabilityGraphElement;
                if (ge instanceof Node) {
                    this.addElementToRemoveList(geIsVariabilityAware, ge, this.removeNodes);
                    Set<Mapping> mappings = ruleInfo.getNode2Mapping().get((Node)ge);
                    if (mappings != null) {
                        this.removeMappings.addAll(mappings);
                    }
                    ((Node)ge).getAllEdges().forEach(edge -> this.addElementToRemoveList(geIsVariabilityAware, (GraphElement)edge, this.removeEdges));
                    continue;
                }
                if (ge instanceof Edge) {
                    this.addElementToRemoveList(geIsVariabilityAware, ge, this.removeEdges);
                    continue;
                }
                if (!(ge instanceof Attribute)) continue;
                this.addElementToRemoveList(geIsVariabilityAware, ge, this.removeAttributes);
            }
        }
        if (this.baseRule && this.rule.getLhs().getFormula() != null) {
            this.removeFormulas.add(this.rule.getLhs().getFormula());
            this.removeElementContainers.put((EObject)this.rule.getLhs().getFormula(), (EObject)this.rule.getLhs());
            this.removeFormulaContainingRef.put(this.rule.getLhs().getFormula(), this.rule.getLhs().getFormula().eContainingFeature());
        } else {
            for (NestedCondition ac : this.rule.getLhs().getNestedConditions()) {
                Sentence acPC = ruleInfo.getExpressions().get(VariabilityFactory.createVariabilityNestedCondition(ac).getPresenceCondition());
                if (!rejected.contains(acPC)) continue;
                Formula removeFormula = null;
                if (ac.isNAC()) {
                    removeFormula = (Formula)ac.eContainer();
                } else if (ac.isPAC()) {
                    removeFormula = ac;
                }
                this.removeFormulas.add(removeFormula);
                this.removeElementContainers.put((EObject)removeFormula, removeFormula.eContainer());
                this.removeFormulaContainingRef.put(removeFormula, removeFormula.eContainingFeature());
            }
        }
    }

    public void doPreparation() {
        if (this.removeNodes == null) {
            throw new IllegalStateException("This method may only be invoked after reject() has been invoked.");
        }
        this.removeFormulas();
        for (Mapping m : this.removeMappings) {
            EStructuralFeature feature = m.eContainingFeature();
            this.removeMappingContainingRef.put(m, feature);
            this.removeElementContainers.put((EObject)m, m.eContainer());
            ((EList)m.eContainer().eGet(feature)).remove((Object)m);
        }
        for (Attribute a : this.removeAttributes) {
            this.removeElementContainers.put((EObject)a, (EObject)a.getNode());
            a.getNode().getAttributes().remove((Object)a);
        }
        for (Edge e : this.removeEdges) {
            this.removeElementContainers.put((EObject)e, (EObject)e.getGraph());
            this.removeEdgeSources.put(e, e.getSource());
            this.removeEdgeTargets.put(e, e.getTarget());
            e.getGraph().getEdges().remove((Object)e);
            e.getSource().getOutgoing().remove((Object)e);
            e.getTarget().getIncoming().remove((Object)e);
        }
        for (Node n : this.removeNodes) {
            this.removeElementContainers.put((EObject)n, (EObject)n.getGraph());
            n.getGraph().getNodes().remove((Object)n);
        }
        this.rule.setInjectiveMatching(this.injectiveMatching);
        this.rule.setCheckDangling(false);
    }

    private void removeFormulas() {
        for (Formula formula : this.removeFormulas) {
            this.removeElementContainers.get(formula).eUnset(this.removeFormulaContainingRef.get(formula));
            this.removeElementContainers.get(formula).eSet(this.removeFormulaContainingRef.get(formula), (Object)HenshinFactory.eINSTANCE.createTrue());
        }
    }

    public void undo() {
        this.rule.setCheckDangling(this.checkDangling);
        this.rule.setInjectiveMatching(this.injectiveMatchingOriginal);
        for (Node n : this.removeNodes) {
            ((Graph)this.removeElementContainers.get(n)).getNodes().add((Object)n);
        }
        for (Edge e : this.removeEdges) {
            ((Graph)this.removeElementContainers.get(e)).getEdges().add((Object)e);
            this.removeEdgeSources.get(e).getOutgoing().add((Object)e);
            this.removeEdgeTargets.get(e).getIncoming().add((Object)e);
        }
        for (Attribute a : this.removeAttributes) {
            ((Node)this.removeElementContainers.get(a)).getAttributes().add((Object)a);
        }
        for (Mapping m : this.removeMappings) {
            EStructuralFeature feature = this.removeMappingContainingRef.get(m);
            EList list = (EList)this.removeElementContainers.get(m).eGet(feature);
            list.add((Object)m);
        }
        this.restoreFormulas();
    }

    private void restoreFormulas() {
        for (Formula formula : this.removeFormulas) {
            this.removeElementContainers.get(formula).eSet(this.removeFormulaContainingRef.get(formula), (Object)formula);
        }
    }

    private void determineRemoveOrder(Set<Formula> formulas) {
        Formula outer = this.rule.getLhs().getFormula();
        if (outer instanceof Not || outer instanceof NestedCondition) {
            Formula formula = formulas.iterator().next();
            if (formula == outer) {
                this.removeElementContainers.put((EObject)formula, (EObject)this.rule.getLhs());
                this.removeFormulaContainingRef.put(formula, (EStructuralFeature)HenshinPackage.Literals.GRAPH__FORMULA);
            }
        } else if (outer instanceof And) {
            this.determineRemoverOrder((And)outer, formulas, (EObject)this.rule.getLhs(), HenshinPackage.Literals.GRAPH__FORMULA);
        } else {
            throw new IllegalArgumentException("TODO: Only AND-based nesting of applications conditions supported yet.");
        }
    }

    private void determineRemoverOrder(And and, Set<Formula> formulas, EObject container, EReference feature) {
        if (formulas.contains(and.getLeft()) && formulas.contains(and.getRight())) {
            this.removeFormulaContainingRef.put((Formula)and, (EStructuralFeature)feature);
            this.removeElementContainers.put((EObject)and, container);
        }
        if (!formulas.contains(and.getLeft()) && formulas.contains(and.getRight())) {
            this.designatePullupChild(and.getLeft(), and, HenshinPackage.Literals.BINARY_FORMULA__LEFT, container, feature);
        }
        if (formulas.contains(and.getLeft()) && !formulas.contains(and.getRight())) {
            this.designatePullupChild(and.getRight(), and, HenshinPackage.Literals.BINARY_FORMULA__RIGHT, container, feature);
        }
        if (!formulas.contains(and.getLeft()) && !formulas.contains(and.getRight())) {
            if (and.getLeft() instanceof And) {
                this.determineRemoverOrder((And)and.getLeft(), formulas, (EObject)and, HenshinPackage.Literals.BINARY_FORMULA__LEFT);
            }
            if (and.getRight() instanceof And) {
                this.determineRemoverOrder((And)and.getRight(), formulas, (EObject)and, HenshinPackage.Literals.BINARY_FORMULA__RIGHT);
            }
        }
    }

    private void designatePullupChild(Formula formula, And oldContainer, EReference oldFeature, EObject newContainer, EReference newFeature) {
        this.removeFormulaContainingRef.put((Formula)oldContainer, (EStructuralFeature)newFeature);
        this.removeElementContainers.put((EObject)oldContainer, newContainer);
        this.pulledUpFormulasToContainingRef.put(formula, (EStructuralFeature)newFeature);
        this.pulledUpFormulasToContainer.put(formula, newContainer);
        this.pulledUpFormulasToOldContainingRef.put(formula, (EStructuralFeature)oldFeature);
        this.pulledUpFormulasToOldContainer.put(formula, (EObject)oldContainer);
    }

    private BitSet getRepresentation(Rule rule, Set<Attribute> deleteAttributes, Set<Node> deleteNodes, Set<Edge> deleteEdges, Set<Formula> deleteFormula, boolean injectiveMatching) {
        BitSet result = new BitSet(rule.getLhs().getNodes().size() + rule.getLhs().getEdges().size() + rule.getLhs().getNestedConditions().size() + 1);
        result.set(0, injectiveMatching);
        int i = 1;
        for (NestedCondition nc : rule.getLhs().getNestedConditions()) {
            result.set(i, !deleteFormula.contains(nc));
            ++i;
        }
        for (Node n : rule.getLhs().getNodes()) {
            result.set(i, !deleteNodes.contains(n));
            ++i;
            for (Attribute a : n.getAttributes()) {
                result.set(i, !deleteAttributes.contains(a));
                ++i;
            }
        }
        for (Edge e : rule.getLhs().getEdges()) {
            result.set(i, !deleteEdges.contains(e));
            ++i;
        }
        for (Node n : rule.getRhs().getNodes()) {
            result.set(i, !deleteNodes.contains(n));
            ++i;
            for (Attribute a : n.getAttributes()) {
                result.set(i, !deleteAttributes.contains(a));
                ++i;
            }
        }
        for (Edge e : rule.getRhs().getEdges()) {
            result.set(i, !deleteEdges.contains(e));
            ++i;
        }
        return result;
    }

    public RulePreparator getSnapShot() {
        RulePreparator result = new RulePreparator(this.rule);
        result.removeNodes = new HashSet<Node>(this.removeNodes);
        result.removeEdges = new HashSet<Edge>(this.removeEdges);
        result.removeAttributes = new HashSet<Attribute>(this.removeAttributes);
        result.removeEdgeSources = new HashMap<Edge, Node>(this.removeEdgeSources);
        result.removeEdgeTargets = new HashMap<Edge, Node>(this.removeEdgeTargets);
        result.removeElementContainers = new HashMap<EObject, EObject>(this.removeElementContainers);
        result.removeFormulas = new HashSet<Formula>(this.removeFormulas);
        result.removeFormulaContainingRef = new HashMap<Formula, EStructuralFeature>(this.removeFormulaContainingRef);
        result.removeMappings = new HashSet<Mapping>(this.removeMappings);
        result.removeMappingContainingRef = new HashMap<Mapping, EStructuralFeature>(this.removeMappingContainingRef);
        return result;
    }
}

