/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.text.typesystem;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.text.henshin_text.AndExpression;
import org.eclipse.emf.henshin.text.henshin_text.BoolValue;
import org.eclipse.emf.henshin.text.henshin_text.BracketExpression;
import org.eclipse.emf.henshin.text.henshin_text.ComparisonExpression;
import org.eclipse.emf.henshin.text.henshin_text.EqualityExpression;
import org.eclipse.emf.henshin.text.henshin_text.Expression;
import org.eclipse.emf.henshin.text.henshin_text.IntegerValue;
import org.eclipse.emf.henshin.text.henshin_text.JavaAttributeValue;
import org.eclipse.emf.henshin.text.henshin_text.JavaClassValue;
import org.eclipse.emf.henshin.text.henshin_text.JavaImport;
import org.eclipse.emf.henshin.text.henshin_text.MinusExpression;
import org.eclipse.emf.henshin.text.henshin_text.MulOrDivExpression;
import org.eclipse.emf.henshin.text.henshin_text.MultiRule;
import org.eclipse.emf.henshin.text.henshin_text.NaturalValue;
import org.eclipse.emf.henshin.text.henshin_text.NotExpression;
import org.eclipse.emf.henshin.text.henshin_text.NumberValue;
import org.eclipse.emf.henshin.text.henshin_text.OrExpression;
import org.eclipse.emf.henshin.text.henshin_text.Parameter;
import org.eclipse.emf.henshin.text.henshin_text.ParameterType;
import org.eclipse.emf.henshin.text.henshin_text.ParameterValue;
import org.eclipse.emf.henshin.text.henshin_text.PlusExpression;
import org.eclipse.emf.henshin.text.henshin_text.Rule;
import org.eclipse.emf.henshin.text.henshin_text.RuleElement;
import org.eclipse.emf.henshin.text.henshin_text.StringValue;
import org.eclipse.emf.henshin.text.henshin_text.Type;
import org.eclipse.emf.henshin.text.typesystem.Henshin_textBoolType;
import org.eclipse.emf.henshin.text.typesystem.Henshin_textComplexType;
import org.eclipse.emf.henshin.text.typesystem.Henshin_textNumberType;
import org.eclipse.emf.henshin.text.typesystem.Henshin_textStringType;
import org.eclipse.emf.henshin.text.typesystem.Henshin_textType;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class Henshin_textTypeProvider {
    public static final Henshin_textStringType stringType = new Henshin_textStringType();
    public static final Henshin_textNumberType numberType = new Henshin_textNumberType();
    public static final Henshin_textBoolType boolType = new Henshin_textBoolType();
    public static final Henshin_textComplexType complexType = new Henshin_textComplexType();

    public Henshin_textType typeFor(Expression expression) {
        boolean _matched = false;
        if (expression instanceof StringValue) {
            _matched = true;
            return stringType;
        }
        if (!_matched && expression instanceof NumberValue) {
            _matched = true;
            return numberType;
        }
        if (!_matched && expression instanceof IntegerValue) {
            _matched = true;
            return numberType;
        }
        if (!_matched && expression instanceof NaturalValue) {
            _matched = true;
            return numberType;
        }
        if (!_matched && expression instanceof BoolValue) {
            _matched = true;
            return boolType;
        }
        if (!_matched && expression instanceof OrExpression) {
            _matched = true;
            return boolType;
        }
        if (!_matched && expression instanceof AndExpression) {
            _matched = true;
            return boolType;
        }
        if (!_matched && expression instanceof EqualityExpression) {
            _matched = true;
            return boolType;
        }
        if (!_matched && expression instanceof ComparisonExpression) {
            _matched = true;
            return boolType;
        }
        if (!_matched && expression instanceof PlusExpression) {
            _matched = true;
            return numberType;
        }
        if (!_matched && expression instanceof MinusExpression) {
            _matched = true;
            return numberType;
        }
        if (!_matched && expression instanceof MulOrDivExpression) {
            _matched = true;
            return numberType;
        }
        if (!_matched && expression instanceof BracketExpression) {
            _matched = true;
            Expression _expression = ((BracketExpression)expression).getExpression();
            return this.typeFor(_expression);
        }
        if (!_matched && expression instanceof NotExpression) {
            _matched = true;
            return boolType;
        }
        if (!_matched && expression instanceof ParameterValue) {
            _matched = true;
            Parameter _value = ((ParameterValue)expression).getValue();
            ParameterType _type = _value.getType();
            return this.typeFor(_type);
        }
        if (!_matched && expression instanceof JavaClassValue) {
            _matched = true;
            return this.typeFor((JavaClassValue)expression);
        }
        if (!_matched && expression instanceof JavaAttributeValue) {
            _matched = true;
            return this.typeFor((JavaAttributeValue)expression);
        }
        return null;
    }

    public Henshin_textType typeFor(JavaAttributeValue javaAttribute) {
        EObject container = javaAttribute.eContainer();
        while (!(container instanceof Rule) && !(container instanceof MultiRule)) {
            EObject _eContainer;
            container = _eContainer = container.eContainer();
        }
        Iterable iterableOfJavaImportImpl = null;
        if (container instanceof Rule) {
            Iterable _filter;
            EList<RuleElement> _ruleElements = ((Rule)container).getRuleElements();
            iterableOfJavaImportImpl = _filter = Iterables.filter(_ruleElements, JavaImport.class);
        } else {
            Iterable _filter_1;
            EList<RuleElement> _multiruleElements = ((MultiRule)container).getMultiruleElements();
            iterableOfJavaImportImpl = _filter_1 = Iterables.filter(_multiruleElements, JavaImport.class);
        }
        for (JavaImport imports : iterableOfJavaImportImpl) {
            try {
                Field[] _declaredFields;
                String _packagename = imports.getPackagename();
                String _plus = String.valueOf(_packagename) + ".";
                String _value = javaAttribute.getValue();
                String[] _split = _value.split("\\.");
                String _get = _split[0];
                String _plus_1 = String.valueOf(_plus) + _get;
                Class<?> calledClass = Class.forName(_plus_1);
                Field[] fieldArray = _declaredFields = calledClass.getDeclaredFields();
                int n = _declaredFields.length;
                int n2 = 0;
                while (n2 < n) {
                    String _value_1;
                    String[] _split_1;
                    String _get_1;
                    Field atrib = fieldArray[n2];
                    String _name = atrib.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)(_get_1 = (_split_1 = (_value_1 = javaAttribute.getValue()).split("\\."))[1]));
                    if (_equals) {
                        Class<?> _type = atrib.getType();
                        String _name_1 = _type.getName();
                        return this.typeForJavaType(_name_1);
                    }
                    ++n2;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception cfr_ignored_0 = (Exception)_t;
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return stringType;
    }

    public Henshin_textType typeFor(JavaClassValue javaCall) {
        EObject container = javaCall.eContainer();
        while (!(container instanceof Rule) && !(container instanceof MultiRule)) {
            EObject _eContainer;
            container = _eContainer = container.eContainer();
        }
        Iterable iterableOfJavaImportImpl = null;
        if (container instanceof Rule) {
            Iterable _filter;
            EList<RuleElement> _ruleElements = ((Rule)container).getRuleElements();
            iterableOfJavaImportImpl = _filter = Iterables.filter(_ruleElements, JavaImport.class);
        } else {
            Iterable _filter_1;
            EList<RuleElement> _multiruleElements = ((MultiRule)container).getMultiruleElements();
            iterableOfJavaImportImpl = _filter_1 = Iterables.filter(_multiruleElements, JavaImport.class);
        }
        for (JavaImport imports : iterableOfJavaImportImpl) {
            try {
                Method[] _methods;
                String _packagename = imports.getPackagename();
                String _plus = String.valueOf(_packagename) + ".";
                String _value = javaCall.getValue();
                String[] _split = _value.split("\\.");
                String _get = _split[0];
                String _plus_1 = String.valueOf(_plus) + _get;
                Class<?> calledClass = Class.forName(_plus_1);
                Method[] methodArray = _methods = calledClass.getMethods();
                int n = _methods.length;
                int n2 = 0;
                while (n2 < n) {
                    String _value_1;
                    String[] _split_1;
                    String _get_1;
                    Method methode = methodArray[n2];
                    String _name = methode.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)(_get_1 = (_split_1 = (_value_1 = javaCall.getValue()).split("\\."))[1]));
                    if (_equals) {
                        Class<?> _returnType = methode.getReturnType();
                        String _name_1 = _returnType.getName();
                        return this.typeForJavaType(_name_1);
                    }
                    ++n2;
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception cfr_ignored_0 = (Exception)_t;
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return stringType;
    }

    public Henshin_textType typeForJavaType(String className) {
        switch (className) {
            case "java.lang.Boolean": {
                return boolType;
            }
            case "boolean": {
                return boolType;
            }
            case "java.lang.Byte": {
                return numberType;
            }
            case "byte": {
                return numberType;
            }
            case "java.lang.Character": {
                return stringType;
            }
            case "char": {
                return stringType;
            }
            case "java.lang.Double": {
                return numberType;
            }
            case "double": {
                return numberType;
            }
            case "java.lang.Float": {
                return numberType;
            }
            case "float": {
                return numberType;
            }
            case "java.lang.Integer": {
                return numberType;
            }
            case "int": {
                return numberType;
            }
            case "java.lang.Long": {
                return numberType;
            }
            case "long": {
                return numberType;
            }
            case "java.lang.Short": {
                return numberType;
            }
            case "short": {
                return numberType;
            }
            case "java.lang.String": {
                return stringType;
            }
            case "string": {
                return stringType;
            }
        }
        return complexType;
    }

    public Henshin_textType typeFor(ParameterType parameterType) {
        EClass _type = parameterType.getType();
        boolean _equals = Objects.equal((Object)_type, null);
        if (_equals) {
            Type _enumType = parameterType.getEnumType();
            String _literal = _enumType.getLiteral();
            return this.typeFor(_literal);
        }
        return complexType;
    }

    public Henshin_textType typeFor(String eType) {
        switch (eType) {
            case "EBigDecimal": {
                return complexType;
            }
            case "EBigInteger": {
                return complexType;
            }
            case "EBoolean": {
                return boolType;
            }
            case "EBooleanObject": {
                return complexType;
            }
            case "EByte": {
                return numberType;
            }
            case "EByteArray": {
                return complexType;
            }
            case "EByteObject": {
                return complexType;
            }
            case "EChar": {
                return stringType;
            }
            case "ECharacterObject": {
                return complexType;
            }
            case "EDate": {
                return complexType;
            }
            case "EDiagnosticChain": {
                return complexType;
            }
            case "EDouble": {
                return numberType;
            }
            case "EDoubleObject": {
                return complexType;
            }
            case "EEList": {
                return complexType;
            }
            case "EEnumerator": {
                return complexType;
            }
            case "EFeatureMap": {
                return complexType;
            }
            case "EFeatureMapEntry": {
                return complexType;
            }
            case "EFloat": {
                return numberType;
            }
            case "EFloatObject": {
                return complexType;
            }
            case "EInt": {
                return numberType;
            }
            case "EIntegerObject": {
                return complexType;
            }
            case "ETreeIterator": {
                return complexType;
            }
            case "EInvocationTargetException": {
                return complexType;
            }
            case "EJavaClass": {
                return complexType;
            }
            case "EJavaObject": {
                return complexType;
            }
            case "ELong": {
                return numberType;
            }
            case "ELongObject": {
                return complexType;
            }
            case "EMap": {
                return complexType;
            }
            case "EResource": {
                return complexType;
            }
            case "EResourceSet": {
                return complexType;
            }
            case "EShort": {
                return numberType;
            }
            case "EShortObject": {
                return complexType;
            }
            case "EString": {
                return stringType;
            }
        }
        return null;
    }

    public boolean isInt(Henshin_textType type) {
        return Objects.equal((Object)type, (Object)numberType);
    }

    public boolean isString(Henshin_textType type) {
        return Objects.equal((Object)type, (Object)stringType);
    }

    public boolean isBoolean(Henshin_textType type) {
        return Objects.equal((Object)type, (Object)boolType);
    }

    public boolean isComplex(Henshin_textType type) {
        return Objects.equal((Object)type, (Object)complexType);
    }
}

