/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.resource;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.Transition;

public class StateSpaceSerializer {
    public static final int MARKER = 18515;
    private OutputStream out;

    public void write(StateSpace stateSpace, OutputStream out) throws IOException {
        this.out = out;
        URI baseURI = stateSpace.eResource().getURI();
        int i = 0;
        while (i < stateSpace.getStates().size()) {
            ((State)stateSpace.getStates().get(i)).setIndex(i);
            ++i;
        }
        EList<Rule> rules = stateSpace.getRules();
        this.writeShort(18515);
        this.writeShort(3);
        this.writeShort(rules.size());
        this.writeInt(stateSpace.getStates().size());
        this.writeInt(stateSpace.getTransitionCount());
        this.writeData(stateSpace.getData());
        for (Rule rule : stateSpace.getRules()) {
            URI uri = EcoreUtil.getURI((EObject)rule).deresolve(baseURI);
            this.writeString(uri.toString());
        }
        for (State state : stateSpace.getStates()) {
            this.writeString(state.isInitial() ? state.getModel().getResource().getURI().deresolve(baseURI).toString() : null);
            this.writeData(state.getData());
            this.writeShort(state.getOutgoing().size());
            for (Transition transition : state.getOutgoing()) {
                State target = transition.getTarget();
                if (target == null) {
                    throw new IOException("Dangling transition");
                }
                if (target.getStateSpace() != stateSpace) {
                    throw new IOException("Transition target not contained in state space");
                }
                this.writeShort(rules.indexOf(transition.getRule()));
                this.writeData(transition.getData());
                this.writeInt(target.getIndex());
            }
        }
        this.out = null;
    }

    private void writeString(String string) throws IOException {
        if (string == null) {
            this.writeShort(0);
        } else {
            int length = string.length();
            this.writeShort(length);
            int i = 0;
            while (i < length) {
                this.out.write(string.charAt(i));
                ++i;
            }
        }
    }

    private void writeData(int[] data) throws IOException {
        if (data == null) {
            this.writeShort(0);
        } else {
            this.writeShort(data.length);
            int i = 0;
            while (i < data.length) {
                this.writeInt(data[i]);
                ++i;
            }
        }
    }

    private void writeInt(int value) throws IOException {
        this.out.write(value >>> 24);
        this.out.write(value >>> 16);
        this.out.write(value >>> 8);
        this.out.write(value);
    }

    private void writeShort(int value) throws IOException {
        this.out.write(value >>> 8);
        this.out.write(value);
    }
}

