/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.equality;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.statespace.EqualityHelper;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.equality.ResourceNavigator;

public class GraphEqualityChecker
extends EcoreUtil.EqualityHelper {
    private static final long serialVersionUID = -2171147717750245758L;
    private final EqualityHelper equalityHelper;
    private List<EObject> roots1;
    private List<EObject> roots2;
    private EMap<EObject, Integer> hashCodes1;
    private EMap<EObject, Integer> hashCodes2;
    private EMap<EObject, Integer> keys1;
    private EMap<EObject, Integer> keys2;
    private ResourceNavigator navigator;

    public GraphEqualityChecker(EqualityHelper equalityHelper) {
        this.equalityHelper = equalityHelper;
    }

    public boolean equals(Model model1, Model model2) {
        if (model1.getResource().getContents().isEmpty()) {
            return model2.getResource().getContents().isEmpty();
        }
        this.roots1 = model1.getResource().getContents();
        this.roots2 = model2.getResource().getContents();
        this.hashCodes1 = model1.getObjectHashCodes();
        this.hashCodes2 = model2.getObjectHashCodes();
        this.keys1 = model1.getObjectKeysMap();
        this.keys2 = model2.getObjectKeysMap();
        this.navigator = new ResourceNavigator(model1.getResource(), true, false);
        boolean result = this.roots1.size() == this.roots2.size() && this.findMatch();
        this.roots1 = null;
        this.roots2 = null;
        this.hashCodes1 = null;
        this.hashCodes2 = null;
        this.keys1 = null;
        this.keys2 = null;
        this.navigator = null;
        return result;
    }

    protected boolean findMatch() {
        if (this.navigator.end) {
            return true;
        }
        if (this.navigator.start) {
            return false;
        }
        EObject target = this.navigator.getTarget();
        if (this.containsKey(target)) {
            this.navigator.skip();
            if (this.findMatch()) {
                return true;
            }
            this.navigator.backward();
            return false;
        }
        List<EObject> matchCandidates = this.navigator.last.source == null ? this.roots2 : (this.navigator.last.reference.isMany() ? (List<EObject>)((EObject)this.get(this.navigator.last.source)).eGet((EStructuralFeature)this.navigator.last.reference) : Collections.singletonList((EObject)((EObject)this.get(this.navigator.last.source)).eGet((EStructuralFeature)this.navigator.last.reference)));
        EObject match = matchCandidates.get(this.navigator.last.index);
        if (this.haveEqualProperties(target, match)) {
            this.put(target, match);
            this.navigator.forward();
            if (this.findMatch()) {
                return true;
            }
            this.navigator.backward();
            this.remove(target);
        }
        int i = 0;
        while (i < this.navigator.last.targets.size()) {
            if (i != this.navigator.last.index && this.haveEqualProperties(target, match = matchCandidates.get(i))) {
                this.put(target, match);
                this.navigator.forward();
                if (this.findMatch()) {
                    return true;
                }
                this.navigator.backward();
                this.remove(target);
            }
            ++i;
        }
        return false;
    }

    protected boolean haveEqualProperties(EObject o1, EObject o2) {
        if (!((Integer)this.hashCodes1.get((Object)o1)).equals(this.hashCodes2.get((Object)o2))) {
            return false;
        }
        EClass type = o1.eClass();
        if (type != o2.eClass()) {
            return false;
        }
        if (this.equalityHelper.getIdentityTypes().contains((Object)type) && !((Integer)this.keys1.get((Object)o1)).equals(this.keys2.get((Object)o2))) {
            return false;
        }
        for (EStructuralFeature feature : type.getEAllStructuralFeatures()) {
            if (!(feature instanceof EReference ? (feature.isMany() ? ((List)o1.eGet(feature)).size() != ((List)o2.eGet(feature)).size() : o1.eGet(feature) == null != (o2.eGet(feature) == null)) : !this.equalityHelper.getIgnoredAttributes().contains((Object)feature) && !this.haveEqualAttribute(o1, o2, (EAttribute)feature))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(EObject o1, EObject o2) {
        throw new UnsupportedOperationException("Use equals(Model,Model)");
    }

    public boolean equals(List<EObject> l1, List<EObject> l2) {
        throw new UnsupportedOperationException("Use equals(Model,Model)");
    }
}

