/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.henshin.statespace.StateSpaceExporter;
import org.eclipse.emf.henshin.statespace.StateSpacePlugin;
import org.eclipse.emf.henshin.statespace.Validator;

class StateSpacePluginInitializer {
    StateSpacePluginInitializer() {
    }

    public static void loadValidators() throws Throwable {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.emf.henshin.statespace.validators");
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("validator".equals(element.getName())) {
                String id = element.getAttribute("id");
                try {
                    Validator validator = (Validator)element.createExecutableExtension("class");
                    StateSpacePlugin.INSTANCE.getValidators().put(id, validator);
                }
                catch (Throwable t) {
                    StateSpacePlugin.INSTANCE.logError("Error loading state space or state validator with id " + id, t);
                }
            }
            ++n2;
        }
    }

    public static void loadExporters() throws Throwable {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.emf.henshin.statespace.exporters");
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("exporter".equals(element.getName())) {
                String id = element.getAttribute("id");
                try {
                    StateSpaceExporter exporter = (StateSpaceExporter)element.createExecutableExtension("class");
                    StateSpacePlugin.INSTANCE.getExporters().put(id, exporter);
                }
                catch (Throwable t) {
                    StateSpacePlugin.INSTANCE.logError("Error loading state space exporter with id " + id, t);
                }
            }
            ++n2;
        }
    }
}

