/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.ui.utils.EEFRuntimeUIMessages;
import org.eclipse.emf.eef.runtime.ui.utils.EditingUtils;
import org.eclipse.emf.eef.runtime.ui.widgets.ButtonsModeEnum;
import org.eclipse.emf.eef.runtime.ui.widgets.IPropertiesFilteredWidget;
import org.eclipse.emf.eef.runtime.ui.widgets.TabElementTreeSelectionDialog;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.EEFEditorSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AdvancedEObjectFlatComboViewer
implements IPropertiesFilteredWidget {
    protected final Image deleteImage = EEFRuntimePlugin.getImage("icons/16x16/Delete_16x16.gif");
    protected final Image addImage = EEFRuntimePlugin.getImage("icons/16x16/Add_16x16.gif");
    private static final String UNDEFINED_VALUE = "<UNDEFINED>";
    private String dialogTitle = "";
    protected Text valueText;
    protected Composite parent;
    protected EObject selection;
    protected Object input;
    protected Button browseButton;
    protected EObjectFlatComboViewerListener callback;
    protected Composite composite;
    protected AdapterFactory adapterFactory;
    protected AdapterFactoryLabelProvider labelProvider;
    protected List<ViewerFilter> filters;
    protected List<ViewerFilter> brFilters;
    protected FormToolkit widgetFactory;
    protected ButtonsModeEnum button_mode = ButtonsModeEnum.BROWSE;
    private Resource mainResource;
    private Button removeButton;
    private Text field;

    public AdvancedEObjectFlatComboViewer(String dialogTitle, Object input, ViewerFilter filter, AdapterFactory adapterFactory, EObjectFlatComboViewerListener callback) {
        this.dialogTitle = dialogTitle;
        this.input = input;
        this.callback = callback;
        this.labelProvider = new AdapterFactoryLabelProvider(adapterFactory);
        this.filters = new ArrayList<ViewerFilter>();
        this.brFilters = new ArrayList<ViewerFilter>();
        this.adapterFactory = adapterFactory;
    }

    public void createControls(Composite parent, FormToolkit widgetFactory) {
        this.widgetFactory = widgetFactory;
        this.createControls(parent);
    }

    public void createControls(Composite parent) {
        this.composite = this.createComposite(parent);
        this.parent = parent;
        if (parent instanceof ExpandableComposite) {
            ((ExpandableComposite)parent).setClient((Control)this.composite);
        }
        FormLayout layout = new FormLayout();
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.spacing = 7;
        this.composite.setLayout((Layout)layout);
        this.createButtons(this.composite);
        this.createLabels(this.composite);
    }

    private void createButtons(Composite parent) {
        this.removeButton = this.createButton(parent, "", 8);
        this.removeButton.setImage(this.deleteImage);
        FormData data = new FormData();
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment(0, -2);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setToolTipText(EEFRuntimeUIMessages.AdvancedEObjectFlatComboViewer_remove_tooltip);
        EditingUtils.setEEFtype((Control)this.removeButton, "eef::AdvancedEObjectFlatComboViewer::removebutton");
        this.browseButton = this.createButton(parent, "", 8);
        this.browseButton.setImage(this.addImage);
        data = new FormData();
        data.right = new FormAttachment((Control)this.removeButton, 2);
        data.top = new FormAttachment(0, -2);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.setToolTipText(EEFRuntimeUIMessages.AdvancedEObjectFlatComboViewer_set_tooltip);
        EditingUtils.setEEFtype((Control)this.browseButton, "eef::AdvancedEObjectFlatComboViewer::browsebutton");
        this.removeButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                AdvancedEObjectFlatComboViewer.this.handleSelection(null);
            }
        });
        this.browseButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                AdvancedEObjectFlatComboViewer.this.browseButtonPressed();
            }
        });
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public void setID(Object id) {
        EditingUtils.setID((Control)this.field, id);
        EditingUtils.setID((Control)this.removeButton, id);
        EditingUtils.setID((Control)this.browseButton, id);
    }

    public Object getID() {
        return EditingUtils.getID((Control)this.field);
    }

    private void createLabels(Composite parent) {
        String value = UNDEFINED_VALUE;
        if (this.selection != null) {
            value = this.labelProvider.getText((Object)this.selection);
        }
        this.valueText = this.createText(parent, value, 0);
        this.valueText.setEditable(false);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.browseButton, 0);
        data.top = new FormAttachment(0, 1);
        this.valueText.setLayoutData((Object)data);
        this.valueText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AdvancedEObjectFlatComboViewer.this.callback.navigateTo(AdvancedEObjectFlatComboViewer.this.selection);
            }
        });
    }

    private Composite createComposite(Composite parent) {
        Composite composite = this.widgetFactory == null ? new Composite(parent, 0) : this.widgetFactory.createComposite(parent);
        return composite;
    }

    private Button createButton(Composite parent, String text, int style) {
        Button button;
        if (this.widgetFactory == null) {
            button = new Button(parent, style);
            button.setText(text);
        } else {
            button = this.widgetFactory.createButton(parent, text, style);
        }
        return button;
    }

    private Text createText(Composite parent, String value, int style) {
        if (this.widgetFactory == null) {
            this.field = new Text(parent, 8);
            this.field.setText(value);
        } else {
            this.field = this.widgetFactory.createText(parent, value, style);
        }
        EditingUtils.setEEFtype((Control)this.field, "eef::AdvancedEObjectFlatComboViewer::field");
        return this.field;
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            if (!structuredSelection.isEmpty() && !"".equals(structuredSelection.getFirstElement())) {
                this.setSelection((EObject)structuredSelection.getFirstElement());
            } else {
                this.valueText.setText(UNDEFINED_VALUE);
            }
        }
    }

    public void setSelection(EObject selection) {
        this.selection = selection;
        String text = this.labelProvider.getText((Object)selection);
        if ("".equals(text)) {
            this.valueText.setText(UNDEFINED_VALUE);
        } else {
            this.valueText.setText(text);
        }
    }

    public EObject getSelection() {
        return this.selection;
    }

    protected void browseButtonPressed() {
        switch (this.button_mode) {
            case BROWSE: {
                TabElementTreeSelectionDialog dialog = new TabElementTreeSelectionDialog(this.input, this.filters, this.brFilters, this.dialogTitle, this.adapterFactory, this.getMainResource()){

                    public void process(IStructuredSelection selection) {
                        if (selection != null && !selection.isEmpty()) {
                            AdvancedEObjectFlatComboViewer.this.handleSelection((EObject)selection.getFirstElement());
                        }
                    }
                };
                if (this.selection != null) {
                    dialog.setSelection((IStructuredSelection)new StructuredSelection((Object)this.selection));
                }
                dialog.open();
                break;
            }
            case CREATE: {
                this.handleCreate();
                break;
            }
        }
    }

    public void handleSelection(EObject selectedElement) {
        this.setSelection(selectedElement);
        this.callback.handleSet(selectedElement);
    }

    public void handleCreate() {
        this.setSelection(this.callback.handleCreate());
    }

    public void setLayoutData(Object layoutData) {
        this.composite.setLayoutData(layoutData);
    }

    public void addFilter(ViewerFilter filter) {
        this.filters.add(filter);
    }

    public void addBusinessRuleFilter(ViewerFilter filter) {
        this.brFilters.add(filter);
    }

    public void removeBusinessRuleFilter(ViewerFilter filter) {
        this.brFilters.remove(filter);
    }

    public void removeFilter(ViewerFilter filter) {
        this.filters.remove(filter);
    }

    public void setButtonMode(ButtonsModeEnum button_mode) {
        this.button_mode = button_mode;
    }

    public Resource getMainResource() {
        if (this.mainResource == null && this.input instanceof EEFEditorSettings) {
            Resource mainResourceFromSettings = null;
            EEFEditorSettings settings = (EEFEditorSettings)this.input;
            if (settings.getSource() != null) {
                mainResourceFromSettings = settings.getSource().eResource();
                if (settings.getValue() instanceof EObject && ((EObject)settings.getValue()).eResource() != null) {
                    mainResourceFromSettings = ((EObject)settings.getValue()).eResource();
                }
            }
            if (mainResourceFromSettings != null) {
                return mainResourceFromSettings;
            }
        }
        return this.mainResource;
    }

    public void setMainResource(Resource mainResource) {
        this.mainResource = mainResource;
    }

    public void setEnabled(boolean enabled) {
        this.browseButton.setEnabled(enabled);
        this.valueText.setEnabled(enabled);
    }

    public void setToolTipText(String tooltip) {
        this.browseButton.setToolTipText(tooltip);
        this.valueText.setToolTipText(tooltip);
    }

    public static interface EObjectFlatComboViewerListener {
        public void handleSet(EObject var1);

        public void navigateTo(EObject var1);

        public EObject handleCreate();
    }
}

