/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.net4j;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.Factory;

public class ExecutorServiceFactory
extends Factory {
    public static final String PRODUCT_GROUP = "org.eclipse.net4j.executorServices";
    public static final String TYPE = "default";
    public static final String DEFAULT_THREAD_GROUP_NAME = "net4j";

    public ExecutorServiceFactory() {
        super(PRODUCT_GROUP, TYPE);
    }

    public ExecutorService create(String threadGroupName) {
        if (threadGroupName == null) {
            threadGroupName = DEFAULT_THREAD_GROUP_NAME;
        }
        final ThreadGroup threadGroup = new ThreadGroup(threadGroupName);
        return Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(threadGroup, r);
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public static ExecutorService get(IManagedContainer container) {
        return (ExecutorService)container.getElement(PRODUCT_GROUP, TYPE, null);
    }
}

