/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.factory;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.factory.FactoryDescriptor;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.IFactoryKey;
import org.eclipse.net4j.util.registry.HashMapRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginFactoryRegistry
extends HashMapRegistry<IFactoryKey, IFactory> {
    public static final String NAMESPACE = "org.eclipse.net4j.util";
    public static final String EXT_POINT = "factories";
    private IRegistryChangeListener extensionRegistryListener = new IRegistryChangeListener(){

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] deltas;
            IExtensionDelta[] iExtensionDeltaArray = deltas = event.getExtensionDeltas(PluginFactoryRegistry.NAMESPACE, PluginFactoryRegistry.EXT_POINT);
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                OM.LOG.warn("ExtensionDelta not handled: " + delta);
                ++n2;
            }
        }
    };

    @Override
    public IFactory get(Object key) {
        IFactory factory = (IFactory)super.get(key);
        if (factory instanceof FactoryDescriptor) {
            FactoryDescriptor descriptor = (FactoryDescriptor)factory;
            factory = descriptor.createFactory();
        }
        return factory;
    }

    public void registerFactory(FactoryDescriptor factory) {
        this.put(factory.getKey(), factory);
    }

    @Override
    protected void doActivate() throws Exception {
        IConfigurationElement[] elements;
        super.doActivate();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = extensionRegistry.getConfigurationElementsFor(NAMESPACE, EXT_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.registerFactory(new FactoryDescriptor(element));
            ++n2;
        }
        extensionRegistry.addRegistryChangeListener(this.extensionRegistryListener, NAMESPACE);
    }

    @Override
    protected void doDeactivate() throws Exception {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        extensionRegistry.removeRegistryChangeListener(this.extensionRegistryListener);
        this.clear();
        super.doDeactivate();
    }
}

