/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jms;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.internal.jms.ConnectionMetaDataImpl;
import org.eclipse.net4j.internal.jms.MessageImpl;
import org.eclipse.net4j.internal.jms.SessionImpl;
import org.eclipse.net4j.internal.jms.bundle.OM;
import org.eclipse.net4j.internal.jms.protocol.JMSClientProtocol;
import org.eclipse.net4j.internal.jms.protocol.JMSLogonRequest;
import org.eclipse.net4j.internal.jms.protocol.JMSOpenSessionRequest;
import org.eclipse.net4j.jms.JMSUtil;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.LifecycleEventConverter;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionImpl
extends Container<Session>
implements Connection {
    private String connectorType;
    private String connectorDescription;
    private String userName;
    private String password;
    private ExceptionListener exceptionListener;
    private String clientID;
    private ConnectionMetaData metaData = new ConnectionMetaDataImpl(this);
    private long sendTimeout = 2500L;
    private IManagedContainer transportContainer;
    private IChannel channel;
    private List<SessionImpl> sessions = new ArrayList<SessionImpl>(0);
    private transient IListener sessionListener = new LifecycleEventConverter<Session>((Notifier)this){

        protected IContainerEvent<Session> createContainerEvent(IContainer<Session> container, Session element, IContainerDelta.Kind kind) {
            if (kind == IContainerDelta.Kind.REMOVED) {
                ConnectionImpl.this.removeSession((SessionImpl)element);
            }
            return new SingleDeltaContainerEvent(container, (Object)element, kind);
        }
    };
    private transient IListener channelListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            ConnectionImpl.this.close();
        }
    };
    private boolean modified = false;
    private boolean stopped = true;

    public ConnectionImpl(IManagedContainer transportContainer, String connectorType, String connectorDescription, String userName, String password) throws JMSException {
        IManagedContainer iManagedContainer = this.transportContainer = transportContainer == null ? JMSUtil.getTransportContainer() : transportContainer;
        if (transportContainer == null) {
            throw new JMSException("No transport container available");
        }
        this.connectorType = connectorType;
        this.connectorDescription = connectorDescription;
        this.userName = userName;
        this.password = password;
        IConnector connector = Net4jUtil.getConnector((IManagedContainer)transportContainer, (String)connectorType, (String)connectorDescription);
        JMSClientProtocol protocol = new JMSClientProtocol();
        protocol.setInfraStructure((Object)this);
        this.channel = connector.openChannel((IProtocol)protocol);
        this.channel.addListener(this.channelListener);
        try {
            if (!((Boolean)new JMSLogonRequest(this.channel, userName, password).send()).booleanValue()) {
                throw new JMSException("Server rejected logon request");
            }
        }
        catch (JMSException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) {
        throw new UnsupportedOperationException();
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) {
        throw new UnsupportedOperationException();
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.ensureOpen();
        this.setModified();
        int sessionID = this.findFreeSessionID();
        SessionImpl session = new SessionImpl(this, sessionID, transacted, acknowledgeMode);
        this.addSession(session);
        try {
            if (!((Boolean)new JMSOpenSessionRequest(this.channel, sessionID).send()).booleanValue()) {
                throw new JMSException("Server rejected open session request");
            }
        }
        catch (JMSException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JMSException(ex.getMessage());
        }
        return session;
    }

    public IManagedContainer getTransportContainer() {
        return this.transportContainer;
    }

    public String getConnectorType() {
        return this.connectorType;
    }

    public String getConnectorDescription() {
        return this.connectorDescription;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public ConnectionMetaData getMetaData() {
        this.ensureOpen();
        this.setModified();
        return this.metaData;
    }

    public String getClientID() {
        this.ensureOpen();
        this.setModified();
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.ensureOpen();
        if (clientID != null) {
            throw new IllegalStateException("clientID != null");
        }
        if (this.modified) {
            throw new IllegalStateException("modified == true");
        }
        this.clientID = clientID;
    }

    public ExceptionListener getExceptionListener() {
        this.ensureOpen();
        this.setModified();
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.ensureOpen();
        this.setModified();
        this.exceptionListener = listener;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public synchronized void start() throws JMSException {
        this.ensureOpen();
        this.setModified();
        if (this.stopped) {
            SessionImpl[] sessionImplArray = this.getSessions();
            int n = sessionImplArray.length;
            int n2 = 0;
            while (n2 < n) {
                SessionImpl session = sessionImplArray[n2];
                try {
                    session.activate();
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                    throw new JMSException(ex.getMessage());
                }
                ++n2;
            }
            this.stopped = false;
        }
    }

    public synchronized void stop() {
        this.ensureOpen();
        this.setModified();
        if (!this.stopped) {
            SessionImpl[] sessionImplArray = this.getSessions();
            int n = sessionImplArray.length;
            int n2 = 0;
            while (n2 < n) {
                SessionImpl session = sessionImplArray[n2];
                session.deactivate();
                ++n2;
            }
            this.stopped = true;
        }
    }

    public synchronized void close() {
        if (this.channel != null) {
            this.stop();
            SessionImpl[] sessionImplArray = this.getSessions();
            int n = sessionImplArray.length;
            int n2 = 0;
            while (n2 < n) {
                SessionImpl session = sessionImplArray[n2];
                session.close();
                ++n2;
            }
            this.channel.removeListener(this.channelListener);
            this.channel.close();
            this.channel = null;
        }
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public void handleMessageFromSignal(int sessionID, long consumerID, MessageImpl message) {
        SessionImpl session = this.sessions.get(sessionID);
        session.handleServerMessage(consumerID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionImpl[] getSessions() {
        ArrayList<SessionImpl> result = new ArrayList<SessionImpl>(this.sessions.size());
        List<SessionImpl> list = this.sessions;
        synchronized (list) {
            for (SessionImpl session : this.sessions) {
                if (session == null) continue;
                result.add(session);
            }
        }
        return result.toArray(new SessionImpl[result.size()]);
    }

    public Session[] getElements() {
        return this.getSessions();
    }

    public boolean isEmpty() {
        return this.getSessions().length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findFreeSessionID() {
        List<SessionImpl> list = this.sessions;
        synchronized (list) {
            int size = this.sessions.size();
            int i = 0;
            while (i < size) {
                if (this.sessions.get(i) == null) {
                    return i;
                }
                ++i;
            }
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(SessionImpl session) {
        List<SessionImpl> list = this.sessions;
        synchronized (list) {
            int sessionID = session.getID();
            while (sessionID >= this.sessions.size()) {
                this.sessions.add(null);
            }
            this.sessions.set(sessionID, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeSession(SessionImpl session) {
        List<SessionImpl> list = this.sessions;
        synchronized (list) {
            block4: {
                int sessionID = session.getID();
                if (this.sessions.get(sessionID) != session) break block4;
                session.removeListener(this.sessionListener);
                this.sessions.set(sessionID, null);
                return true;
            }
            return false;
        }
    }

    private void setModified() {
        this.modified = true;
    }

    private void ensureOpen() throws IllegalStateException {
        if (this.channel == null) {
            throw new IllegalStateException("channel == null");
        }
    }
}

