/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.ui;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.buddies.IBuddyCollaboration;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.ICollaboration;
import org.eclipse.net4j.buddies.common.IMembership;
import org.eclipse.net4j.buddies.internal.ui.SharedIcons;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.LongRunningAction;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.ContainerView;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemProvider
extends ContainerItemProvider<IContainer<Object>> {
    public static final Color GRAY = UIUtil.getDisplay().getSystemColor(15);
    private Font bold;

    public AbstractItemProvider() {
    }

    public AbstractItemProvider(IElementFilter rootElementFilter) {
        super(rootElementFilter);
    }

    public void dispose() {
        UIUtil.dispose((Font)this.bold);
        super.dispose();
    }

    public Font getBold() {
        return this.bold;
    }

    protected ContainerItemProvider.Node createNode(ContainerItemProvider.Node parent, Object element) {
        if (element instanceof IMembership) {
            IMembership membership = (IMembership)element;
            return this.createMembershipNode(parent, membership);
        }
        return super.createNode(parent, element);
    }

    protected abstract ContainerItemProvider.Node createMembershipNode(ContainerItemProvider.Node var1, IMembership var2);

    public String getText(Object obj) {
        if (obj instanceof IBuddy) {
            IBuddy buddy = (IBuddy)obj;
            return buddy.getUserID();
        }
        if (obj instanceof ICollaboration) {
            ICollaboration collaboration = (ICollaboration)obj;
            return collaboration.getTitle();
        }
        if (obj instanceof IMembership) {
            IMembership membership = (IMembership)obj;
            return this.getText(membership);
        }
        return super.getText(obj);
    }

    protected abstract String getText(IMembership var1);

    public Image getImage(Object obj) {
        if (obj instanceof IBuddy) {
            IBuddy buddy = (IBuddy)obj;
            switch (buddy.getState()) {
                case AVAILABLE: {
                    return SharedIcons.getImage("obj16/buddy");
                }
                case LONESOME: {
                    return SharedIcons.getImage("obj16/buddy_lonesome");
                }
                case AWAY: {
                    return SharedIcons.getImage("obj16/buddy_away");
                }
                case DO_NOT_DISTURB: {
                    return SharedIcons.getImage("obj16/buddy_do_not_disturb");
                }
            }
        }
        if (obj instanceof ICollaboration) {
            return SharedIcons.getImage("obj16/collaboration");
        }
        if (obj instanceof IMembership) {
            IMembership membership = (IMembership)obj;
            return this.getImage(membership);
        }
        return super.getImage(obj);
    }

    protected abstract Image getImage(IMembership var1);

    public Color getForeground(Object obj) {
        if (obj instanceof IBuddy) {
            IBuddy buddy = (IBuddy)obj;
            switch (buddy.getState()) {
                case AWAY: 
                case DO_NOT_DISTURB: {
                    return GRAY;
                }
            }
        }
        return super.getForeground(obj);
    }

    public Font getFont(Object obj) {
        if (obj instanceof IBuddy) {
            IBuddy buddy = (IBuddy)obj;
            switch (buddy.getState()) {
                case LONESOME: {
                    return this.bold;
                }
            }
        }
        return super.getFont(obj);
    }

    protected void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
        manager.add((IContributionItem)new Separator());
        if (selection.size() == 1) {
            Object obj = selection.getFirstElement();
            if (obj instanceof IBuddy) {
                manager.add((IAction)new RemoveAction(obj));
            } else if (obj instanceof IBuddyCollaboration) {
                final IBuddyCollaboration collaboration = (IBuddyCollaboration)obj;
                manager.add((IAction)new SafeAction("Leave", "Leave this collaboration"){

                    protected void safeRun() throws Exception {
                        collaboration.leave();
                    }
                });
            }
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        UIUtil.dispose((Font)this.bold);
        super.inputChanged(viewer, oldInput, newInput);
        this.bold = UIUtil.getBoldFont((Control)this.getViewer().getControl());
    }

    public class RemoveAction
    extends LongRunningAction {
        private Object object;

        public RemoveAction(Object object) {
            super("Remove", "Remove", ContainerView.getDeleteImageDescriptor());
            this.object = object;
        }

        protected void doRun() throws Exception {
            LifecycleUtil.deactivateNoisy((Object)this.object);
        }
    }
}

