/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import java.util.Iterator;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class LoadResourceAction
extends Action {
    protected EditingDomain domain;

    public LoadResourceAction(EditingDomain domain) {
        this();
        this.domain = domain;
        this.update();
    }

    public LoadResourceAction() {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_LoadResource_menu_item"));
        this.setDescription(EMFEditUIPlugin.INSTANCE.getString("_UI_LoadResource_menu_item_description"));
    }

    public EditingDomain getEditingDomain() {
        return this.domain;
    }

    public void setEditingDomain(EditingDomain domain) {
        this.domain = domain;
    }

    public void run() {
        LoadResourceDialog loadResourceDialog = new LoadResourceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.domain);
        loadResourceDialog.open();
    }

    public void update() {
        this.setEnabled(this.domain != null);
    }

    public void setActiveEditor(IEditorPart editorPart) {
        this.setActiveWorkbenchPart((IWorkbenchPart)editorPart);
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        this.setEditingDomain(workbenchPart instanceof IEditingDomainProvider ? ((IEditingDomainProvider)workbenchPart).getEditingDomain() : null);
    }

    public static class LoadResourceDialog
    extends ResourceDialog {
        EditingDomain domain;

        public LoadResourceDialog(Shell parent) {
            this(parent, null);
        }

        public LoadResourceDialog(Shell parent, EditingDomain domain) {
            super(parent, EMFEditUIPlugin.INSTANCE.getString("_UI_LoadResourceDialog_title"), 4098);
            this.domain = domain;
        }

        protected boolean processResources() {
            if (this.domain != null) {
                Iterator i = this.getURIs().iterator();
                while (i.hasNext()) {
                    try {
                        this.domain.getResourceSet().getResource((URI)i.next(), true);
                    }
                    catch (RuntimeException exception) {
                        EMFEditUIPlugin.INSTANCE.log(exception);
                    }
                }
            }
            return true;
        }
    }
}

