/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.transaction.CDOSavepoint;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOXATransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.transaction.CDOSingleTransactionStrategyImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOXACommitContextImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOXASavepointImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.CDOTransactionStrategy;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOXATransaction;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.om.monitor.EclipseMonitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.transaction.TransactionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOXATransactionImpl
implements InternalCDOXATransaction {
    private List<InternalCDOTransaction> transactions = new ArrayList<InternalCDOTransaction>();
    private boolean allRequestEnabled = true;
    private ExecutorService executorService = Executors.newFixedThreadPool(10);
    private Map<InternalCDOTransaction, CDOXACommitContextImpl> activeContext = new HashMap<InternalCDOTransaction, CDOXACommitContextImpl>();
    private Map<InternalCDOTransaction, Set<CDOID>> requestedCDOID = new HashMap<InternalCDOTransaction, Set<CDOID>>();
    private CDOXASavepointImpl lastSavepoint;
    private CDOXASavepointImpl firstSavepoint = this.lastSavepoint = new CDOXASavepointImpl(this, null);
    private CDOTransactionStrategy transactionStrategy = new CDOXATransactionStrategyImpl();
    private CDOXAInternalAdapter internalAdapter = new CDOXAInternalAdapter();

    @Override
    public boolean isAllowRequestFromTransactionEnabled() {
        return this.allRequestEnabled;
    }

    @Override
    public void setAllowRequestFromTransactionEnabled(boolean allRequest) {
        this.allRequestEnabled = allRequest;
    }

    public void add(InternalCDOTransaction transaction) {
        transaction.setTransactionStrategy(this.transactionStrategy);
    }

    public void remove(InternalCDOTransaction transaction) {
        transaction.setTransactionStrategy(null);
    }

    @Override
    public synchronized void add(CDOViewSet viewSet) {
        CDOXATransaction transSet = CDOUtil.getXATransaction(viewSet);
        if (transSet != null) {
            throw new IllegalArgumentException(Messages.getString("CDOXATransactionImpl.0"));
        }
        viewSet.eAdapters().add((Object)this.internalAdapter);
        for (InternalCDOTransaction transaction : this.getTransactions(viewSet)) {
            this.add(transaction);
        }
    }

    @Override
    public synchronized void remove(CDOViewSet viewSet) {
        CDOXATransaction transSet = CDOUtil.getXATransaction(viewSet);
        if (transSet != this) {
            throw new IllegalArgumentException(Messages.getString("CDOXATransactionImpl.1"));
        }
        for (InternalCDOTransaction transaction : this.getTransactions(viewSet)) {
            this.remove(transaction);
        }
        viewSet.eAdapters().remove((Object)this.internalAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(InternalCDOTransaction view, CDOID object) {
        Map<InternalCDOTransaction, Set<CDOID>> map = this.requestedCDOID;
        synchronized (map) {
            Set<CDOID> ids = this.requestedCDOID.get(view);
            if (ids == null) {
                ids = new HashSet<CDOID>();
                this.requestedCDOID.put(view, ids);
            }
            ids.add(object);
        }
    }

    public CDOID[] get(InternalCDOTransaction transaction) {
        Set<CDOID> ids = this.requestedCDOID.get(transaction);
        return ids.toArray(new CDOID[ids.size()]);
    }

    @Override
    public CDOXACommitContextImpl getCommitContext(CDOTransaction transaction) {
        return this.activeContext.get(transaction);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void send(Collection<CDOXACommitContextImpl> xaContexts, IProgressMonitor progressMonitor) throws InterruptedException, ExecutionException {
        progressMonitor.beginTask("", xaContexts.size());
        try {
            futures = new ArrayList<Future<Object>>();
            for (CDOXACommitContextImpl xaContext : xaContexts) {
                xaContext.setProgressMonitor((IProgressMonitor)new EclipseMonitor.SynchonizedSubProgressMonitor(progressMonitor, 1));
                futures.add(this.executorService.submit(xaContext));
            }
            do {
                nbProcessDone = 0;
                for (Future future : futures) {
                    try {
                        future.get(1L, TimeUnit.MILLISECONDS);
                        ++nbProcessDone;
                    }
                    catch (TimeoutException v0) {}
                }
            } while (xaContexts.size() != nbProcessDone);
        }
        finally {
            progressMonitor.done();
            ** for (xaContext : xaContexts)
        }
lbl-1000:
        // 1 sources

        {
            xaContext.setProgressMonitor(null);
            continue;
        }
lbl26:
        // 1 sources

    }

    private void cleanUp() {
        this.activeContext.clear();
        this.requestedCDOID.clear();
    }

    private List<InternalCDOTransaction> getTransactions(CDOViewSet viewSet) {
        ArrayList<InternalCDOTransaction> transactions = new ArrayList<InternalCDOTransaction>();
        CDOView[] cDOViewArray = viewSet.getViews();
        int n = cDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOView view = cDOViewArray[n2];
            if (view instanceof InternalCDOTransaction) {
                transactions.add((InternalCDOTransaction)view);
            }
            ++n2;
        }
        return transactions;
    }

    @Override
    public void commit() throws TransactionException {
        this.commit((IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void commit(IProgressMonitor progressMonitor) throws TransactionException {
        block11: {
            CheckUtil.checkArg((Object)progressMonitor, (String)"progressMonitor");
            progressMonitor.beginTask(Messages.getString("CDOXATransactionImpl.4"), 3);
            phase = 0;
            for (InternalCDOTransaction transaction : this.transactions) {
                context = transaction.createCommitContext();
                xaContext = new CDOXACommitContextImpl(this, context);
                xaContext.setState(CDOXAPhase1State.INSTANCE);
                this.activeContext.put(transaction, xaContext);
            }
            try {
                block12: {
                    try {
                        while (phase < 3) {
                            this.send(this.activeContext.values(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            ++phase;
                        }
                        break block11;
                    }
                    catch (Exception ex) {
                        if (phase >= 2) break block12;
                        ** for (transaction : this.activeContext.values())
                    }
lbl-1000:
                    // 1 sources

                    {
                        transaction.setState(CDOXACancel.INSTANCE);
                        continue;
                    }
lbl23:
                    // 1 sources

                    try {
                        this.send(this.activeContext.values(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 2 - phase));
                    }
                    catch (InterruptedException v0) {
                    }
                    catch (ExecutionException v1) {}
                }
                throw new TransactionException((Throwable)ex);
            }
            finally {
                this.cleanUp();
                progressMonitor.done();
            }
        }
    }

    @Override
    public CDOXASavepointImpl getLastSavepoint() {
        return this.lastSavepoint;
    }

    @Override
    public void rollback() {
        this.rollback(this.firstSavepoint);
    }

    @Override
    public void rollback(CDOSavepoint savepoint) {
        if (savepoint == null) {
            throw new IllegalArgumentException(Messages.getString("CDOXATransactionImpl.5"));
        }
        if (savepoint.getUserTransaction() != this) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOXATransactionImpl.6"), savepoint));
        }
        if (!savepoint.isValid()) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("CDOXATransactionImpl.7")) + savepoint);
        }
        CDOXASavepointImpl savepointSet = (CDOXASavepointImpl)savepoint;
        List<CDOSavepoint> savepoints = savepointSet.getSavepoints();
        if (savepoints == null) {
            savepoints = this.getListSavepoints();
        }
        for (CDOSavepoint indexSavePoint : savepoints) {
            InternalCDOTransaction transaction = (InternalCDOTransaction)indexSavePoint.getUserTransaction();
            CDOSingleTransactionStrategyImpl.INSTANCE.rollback(transaction, indexSavePoint);
        }
        this.lastSavepoint = savepointSet;
        this.lastSavepoint.setNextSavepoint(null);
        this.lastSavepoint.setSavepoints(null);
    }

    @Override
    public CDOSavepoint setSavepoint() {
        List<CDOSavepoint> savepoints = this.getListSavepoints();
        for (CDOSavepoint savepoint : savepoints) {
            InternalCDOTransaction transaction = (InternalCDOTransaction)savepoint.getUserTransaction();
            CDOSingleTransactionStrategyImpl.INSTANCE.setSavepoint(transaction);
        }
        this.getLastSavepoint().setSavepoints(savepoints);
        this.lastSavepoint = new CDOXASavepointImpl(this, this.getLastSavepoint());
        return this.lastSavepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CDOSavepoint> getListSavepoints() {
        List<InternalCDOTransaction> list = this.transactions;
        synchronized (list) {
            ArrayList<CDOSavepoint> savepoints = new ArrayList<CDOSavepoint>();
            for (InternalCDOTransaction transaction : this.transactions) {
                savepoints.add(transaction.getLastSavepoint());
            }
            return savepoints;
        }
    }

    public static class CDOXACancel
    extends CDOXAState {
        public static final CDOXACancel INSTANCE = new CDOXACancel();

        protected void handle(CDOXACommitContextImpl xaContext, IProgressMonitor progressMonitor) throws Exception {
            CDOSessionProtocol sessionProtocol = xaContext.getTransaction().getSession().getSessionProtocol();
            EclipseMonitor monitor = new EclipseMonitor(progressMonitor);
            CDOSessionProtocol.CommitTransactionResult result = sessionProtocol.commitTransactionCancel(xaContext, (OMMonitor)monitor);
            this.check_result(result);
        }
    }

    public class CDOXAInternalAdapter
    implements Adapter {
        public CDOXATransactionImpl getCDOXA() {
            return CDOXATransactionImpl.this;
        }

        public Notifier getTarget() {
            return null;
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 3: {
                    if (!(notification.getNewValue() instanceof InternalCDOTransaction)) break;
                    CDOXATransactionImpl.this.add((InternalCDOTransaction)notification.getNewValue());
                    break;
                }
                case 4: {
                    if (!(notification.getOldValue() instanceof InternalCDOTransaction)) break;
                    CDOXATransactionImpl.this.remove((InternalCDOTransaction)notification.getNewValue());
                }
            }
        }

        public void setTarget(Notifier newTarget) {
        }
    }

    public static class CDOXAPhase1State
    extends CDOXAState {
        public static final CDOXAPhase1State INSTANCE = new CDOXAPhase1State();

        protected void handle(CDOXACommitContextImpl xaContext, IProgressMonitor progressMonitor) throws Exception {
            xaContext.preCommit();
            CDOSessionProtocol.CommitTransactionResult result = null;
            if (xaContext.getTransaction().isDirty()) {
                CDOSessionProtocol sessionProtocol = xaContext.getTransaction().getSession().getSessionProtocol();
                EclipseMonitor monitor = new EclipseMonitor(progressMonitor);
                result = sessionProtocol.commitTransactionPhase1(xaContext, (OMMonitor)monitor);
                this.check_result(result);
            }
            xaContext.setResult(result);
            xaContext.setState(CDOXAPhase2State.INSTANCE);
        }
    }

    public static class CDOXAPhase2State
    extends CDOXAState {
        public static final CDOXAPhase2State INSTANCE = new CDOXAPhase2State();

        protected void handle(CDOXACommitContextImpl xaContext, IProgressMonitor progressMonitor) throws Exception {
            if (xaContext.getTransaction().isDirty()) {
                CDOSessionProtocol sessionProtocol = xaContext.getTransaction().getSession().getSessionProtocol();
                EclipseMonitor monitor = new EclipseMonitor(progressMonitor);
                CDOSessionProtocol.CommitTransactionResult result = sessionProtocol.commitTransactionPhase2(xaContext, (OMMonitor)monitor);
                this.check_result(result);
            }
            xaContext.setState(CDOXAPhase3State.INSTANCE);
        }
    }

    public static class CDOXAPhase3State
    extends CDOXAState {
        public static final CDOXAPhase3State INSTANCE = new CDOXAPhase3State();

        protected void handle(CDOXACommitContextImpl xaContext, IProgressMonitor progressMonitor) throws Exception {
            if (xaContext.getTransaction().isDirty()) {
                CDOSessionProtocol sessionProtocol = xaContext.getTransaction().getSession().getSessionProtocol();
                EclipseMonitor monitor = new EclipseMonitor(progressMonitor);
                CDOSessionProtocol.CommitTransactionResult result = sessionProtocol.commitTransactionPhase3(xaContext, (OMMonitor)monitor);
                this.check_result(result);
            }
            xaContext.postCommit(xaContext.getResult());
            xaContext.setState(null);
        }
    }

    public static abstract class CDOXAState {
        public static final CDOXAState DONE = new CDOXAState(){

            protected void handle(CDOXACommitContextImpl xaContext, IProgressMonitor progressMonitor) throws Exception {
                progressMonitor.done();
            }
        };

        protected void check_result(CDOSessionProtocol.CommitTransactionResult result) {
            if (result != null && result.getRollbackMessage() != null) {
                throw new TransactionException(result.getRollbackMessage());
            }
        }

        protected abstract void handle(CDOXACommitContextImpl var1, IProgressMonitor var2) throws Exception;
    }

    private final class CDOXATransactionStrategyImpl
    implements CDOTransactionStrategy {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTarget(InternalCDOTransaction transaction) {
            List list = CDOXATransactionImpl.this.transactions;
            synchronized (list) {
                CDOXATransactionImpl.this.transactions.add(transaction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unsetTarget(InternalCDOTransaction transaction) {
            List list = CDOXATransactionImpl.this.transactions;
            synchronized (list) {
                CDOXATransactionImpl.this.transactions.remove(transaction);
            }
        }

        private void checkAccess() {
            if (!CDOXATransactionImpl.this.allRequestEnabled) {
                throw new IllegalStateException(Messages.getString("CDOXATransactionImpl.8"));
            }
        }

        public void commit(InternalCDOTransaction transactionCommit, IProgressMonitor progressMonitor) throws Exception {
            this.checkAccess();
            CDOXATransactionImpl.this.commit(progressMonitor);
        }

        public void rollback(InternalCDOTransaction transaction, CDOSavepoint savepoint) {
            this.checkAccess();
            CDOXATransactionImpl.this.rollback(savepoint);
        }

        public CDOSavepoint setSavepoint(InternalCDOTransaction transaction) {
            this.checkAccess();
            return CDOXATransactionImpl.this.setSavepoint();
        }
    }
}

