/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.cdo.common.id.CDOIDLibraryProvider;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerIndication;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class LoadLibrariesIndication
extends CDOServerIndication {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, LoadLibrariesIndication.class);
    private String[] libraryNames;

    protected short getSignalID() {
        return 2;
    }

    protected void indicating(ExtendedDataInputStream in) throws IOException {
        int size = in.readInt();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Reading {0} library names", new Object[]{size});
        }
        this.libraryNames = new String[size];
        int i = 0;
        while (i < size) {
            this.libraryNames[i] = in.readString();
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Read library name: {0}", new Object[]{this.libraryNames[i]});
            }
            ++i;
        }
    }

    protected void responding(ExtendedDataOutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        CDOIDLibraryProvider libraryProvider = this.getStore().getCDOIDLibraryProvider();
        String[] stringArray = this.libraryNames;
        int n = this.libraryNames.length;
        int n2 = 0;
        while (n2 < n) {
            String libraryName = stringArray[n2];
            int size = libraryProvider.getSize(libraryName);
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Writing library {0}: {1} bytes", new Object[]{libraryName, size});
            }
            out.writeInt(size);
            InputStream in = null;
            try {
                in = libraryProvider.getContents(libraryName);
                IOUtil.copy((InputStream)in, (OutputStream)out, (int)size, (byte[])buffer);
            }
            finally {
                IOUtil.close((Closeable)in);
            }
            ++n2;
        }
    }
}

