/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.bundle;

import java.io.File;
import org.eclipse.emf.cdo.internal.server.RepositoryConfigurator;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.net4j.Net4jConfigurator;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.OSGiApplication;

public class CDOServerApplication
extends OSGiApplication {
    public static final String ID = "org.eclipse.emf.cdo.server.app";
    private IRepository[] repositories;
    private IAcceptor[] acceptors;

    public CDOServerApplication() {
        super(ID);
    }

    protected void doStart() throws Exception {
        super.doStart();
        OM.LOG.info("CDO Server starting");
        File configFile = OMPlatform.INSTANCE.getConfigFile("cdo-server.xml");
        if (configFile != null && configFile.exists()) {
            RepositoryConfigurator repositoryConfigurator = new RepositoryConfigurator((IManagedContainer)IPluginContainer.INSTANCE);
            this.repositories = repositoryConfigurator.configure(configFile);
            if (this.repositories == null || this.repositories.length == 0) {
                OM.LOG.warn("No repositories configured");
            }
            Net4jConfigurator net4jConfigurator = new Net4jConfigurator((IManagedContainer)IPluginContainer.INSTANCE);
            this.acceptors = net4jConfigurator.configure(configFile);
            if (this.acceptors == null || this.acceptors.length == 0) {
                OM.LOG.warn("No acceptors configured");
            }
        } else {
            OM.LOG.warn("CDO server configuration not found: " + configFile.getAbsolutePath());
        }
        OM.LOG.info("CDO Server started");
    }

    protected void doStop() throws Exception {
        int n;
        int n2;
        Object[] objectArray;
        OM.LOG.info("CDO Server stopping");
        if (this.acceptors != null) {
            objectArray = this.acceptors;
            n2 = this.acceptors.length;
            n = 0;
            while (n < n2) {
                IAcceptor acceptor = objectArray[n];
                LifecycleUtil.deactivate((Object)acceptor);
                ++n;
            }
        }
        if (this.repositories != null) {
            objectArray = this.repositories;
            n2 = this.repositories.length;
            n = 0;
            while (n < n2) {
                IAcceptor repository = objectArray[n];
                LifecycleUtil.deactivate((Object)repository);
                ++n;
            }
        }
        OM.LOG.info("CDO Server stopped");
        super.doStop();
    }
}

