/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.emf.internal.cdo.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.protocol.CDOClientRequest;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.util.collection.MoveableList;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadChunkRequest
extends CDOClientRequest<CDOID> {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, LoadChunkRequest.class);
    private InternalCDORevision revision;
    private CDOFeature feature;
    private int accessIndex;
    private int fromIndex;
    private int toIndex;

    public LoadChunkRequest(IChannel channel, InternalCDORevision revision, CDOFeature feature, int accessIndex, int fromIndex, int toIndex) {
        super(channel);
        this.revision = revision;
        this.feature = feature;
        this.accessIndex = accessIndex;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    protected short getSignalID() {
        return 10;
    }

    protected void requesting(ExtendedDataOutputStream out) throws IOException {
        CDOID id = this.revision.getID();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing revision ID: {0}", new Object[]{id});
        }
        CDOIDUtil.write((ExtendedDataOutput)out, (CDOID)id);
        int version = this.revision.getVersion();
        if (this.revision.isTransactional()) {
            --version;
        }
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing revision version: {0}", new Object[]{version});
        }
        out.writeInt(version);
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing feature: {0}", new Object[]{this.feature});
        }
        CDOClassRef classRef = this.feature.getContainingClass().createClassRef();
        CDOModelUtil.writeClassRef((ExtendedDataOutput)out, (CDOClassRef)classRef);
        out.writeInt(this.feature.getFeatureIndex());
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing fromIndex: {0}", new Object[]{this.fromIndex});
        }
        out.writeInt(this.fromIndex);
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing toIndex: {0}", new Object[]{this.toIndex});
        }
        out.writeInt(this.toIndex);
    }

    protected CDOID confirming(ExtendedDataInputStream in) throws IOException {
        CDOSessionImpl session = this.getSession();
        CDOID accessID = null;
        MoveableList list = this.revision.getList(this.feature);
        int i = this.fromIndex;
        while (i <= this.toIndex) {
            CDOID id = CDOIDUtil.read((ExtendedDataInput)in, (CDOIDObjectFactory)session);
            list.set(i, (Object)id);
            if (i == this.accessIndex) {
                accessID = id;
            }
            ++i;
        }
        return accessID;
    }
}

