/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStoreEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.teneo.PackageRegistryProvider;
import org.eclipse.emf.teneo.TeneoException;
import org.eclipse.emf.teneo.ecore.EModelResolver;
import org.eclipse.emf.teneo.type.PersistentStoreAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreUtil {
    private static Log log = LogFactory.getLog(StoreUtil.class);
    public static final char EXTENSION_SEPARATOR = '.';
    private static final char PACKAGE_SEPARATOR = '.';
    public static final char PATH_SEPARATOR = '/';
    public static final String ANNOTATION_SOURCE = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";

    public static boolean isQName(EAttribute eAttribute) {
        EDataType eDataType = eAttribute.getEAttributeType();
        return eDataType == XMLTypePackage.eINSTANCE.getQName();
    }

    public static List<EPackage> readEPackages(String[] ecoreFiles) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new EcoreResourceFactoryImpl());
        ArrayList<EPackage> epackages = new ArrayList<EPackage>();
        String[] stringArray = ecoreFiles;
        int n = ecoreFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            log.debug((Object)("Reading ecore file: " + element));
            Resource res = resourceSet.getResource(URI.createFileURI((String)element), true);
            TreeIterator it = res.getAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                if (!(obj instanceof EPackage)) continue;
                EPackage epack = (EPackage)obj;
                EPackage currentEPackage = PackageRegistryProvider.getInstance().getPackageRegistry().getEPackage(epack.getNsURI());
                if (currentEPackage != null) {
                    if (epackages.contains(currentEPackage)) continue;
                    epackages.add(currentEPackage);
                    continue;
                }
                PackageRegistryProvider.getInstance().getPackageRegistry().put((Object)epack.getNsURI(), (Object)epack);
                epackages.add(epack);
            }
            ++n2;
        }
        return epackages;
    }

    public static boolean isMap(EStructuralFeature eStructuralFeature) {
        if (eStructuralFeature instanceof EAttribute) {
            return false;
        }
        EReference eref = (EReference)eStructuralFeature;
        return StoreUtil.isMapEntry(eref.getEReferenceType());
    }

    public static boolean isMapEntry(EClass eclass) {
        return eclass != null && eclass.getInstanceClass() != null && Map.Entry.class.isAssignableFrom(eclass.getInstanceClass()) && eclass.getEStructuralFeatures().size() == 2 && eclass.getEStructuralFeature("key") != null && eclass.getEStructuralFeature("value") != null;
    }

    public static boolean isEStoreList(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof EStoreEObjectImpl.EStoreEList) {
            return true;
        }
        return o instanceof EStoreEObjectImpl.BasicEStoreEList;
    }

    public static String getEntityName(EStructuralFeature feature) {
        assert (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature));
        return String.valueOf(feature.getEContainingClass().getName()) + "_" + feature.getName();
    }

    public static String toString(EStructuralFeature efeature) {
        if (efeature == null) {
            return "NULL";
        }
        return String.valueOf(efeature.getEContainingClass().getName()) + "/" + efeature.getName();
    }

    public static void dispatchEListLoadNotification(final EObject notifier, EList<? extends EObject> elist, final EStructuralFeature feature) {
        notifier.eNotify((Notification)new NotificationImpl(1011, null, elist){

            public Object getNotifier() {
                return notifier;
            }

            public Object getFeature() {
                return feature;
            }

            public int getFeatureID(Class<?> expectedClass) {
                return feature.getFeatureID();
            }
        });
    }

    public static String structuralFeatureToString(EStructuralFeature structuralFeature) {
        String nsuri = structuralFeature.getEContainingClass().getEPackage().getNsURI();
        String eclassName = structuralFeature.getEContainingClass().getName();
        String featureName = structuralFeature.getName();
        return String.valueOf(nsuri) + '/' + eclassName + '/' + featureName;
    }

    public static boolean isWildCard(EStructuralFeature feature) {
        EAnnotation eAnnotation = feature.getEAnnotation(ANNOTATION_SOURCE);
        if (eAnnotation == null) {
            return false;
        }
        String kind = (String)eAnnotation.getDetails().get((Object)"kind");
        String wildcards = (String)eAnnotation.getDetails().get((Object)"wildcards");
        return kind != null && kind.compareTo("elementWildcard") == 0 && wildcards != null;
    }

    public static boolean isMixed(EStructuralFeature feature) {
        EAnnotation eAnnotation = feature.getEAnnotation(ANNOTATION_SOURCE);
        if (eAnnotation == null) {
            return false;
        }
        String kind = (String)eAnnotation.getDetails().get((Object)"kind");
        String name = (String)eAnnotation.getDetails().get((Object)"name");
        return kind != null && kind.compareTo("elementWildcard") == 0 && name != null && name.compareTo(":mixed") == 0;
    }

    public static EStructuralFeature stringToStructureFeature(String strid) {
        int lastIndex = strid.lastIndexOf(47);
        int beforeLastIndex = strid.lastIndexOf(47, lastIndex - 1);
        if (lastIndex == -1 || beforeLastIndex == -1) {
            throw new TeneoException("The database id stored for a structuralfeature used in a featuremap entry is invalid, dbid: " + strid);
        }
        String nsuri = strid.substring(0, beforeLastIndex);
        String eclassName = strid.substring(beforeLastIndex + 1, lastIndex);
        String featureName = strid.substring(lastIndex + 1);
        EPackage epack = PackageRegistryProvider.getInstance().getPackageRegistry().getEPackage(nsuri);
        if (epack == null) {
            throw new TeneoException("The dbid " + strid + " and nsuri: " + nsuri + " does not resolve to an epackage");
        }
        EClass eclass = (EClass)epack.getEClassifier(eclassName);
        if (eclass == null) {
            throw new TeneoException("The dbid " + strid + " and eclassname: " + eclassName + " does not resolve to an eclass");
        }
        EStructuralFeature structFeature = eclass.getEStructuralFeature(featureName);
        if (structFeature == null) {
            throw new TeneoException("The dbid " + strid + " and featurename: " + featureName + " does not resolve to a structural feature");
        }
        return structFeature;
    }

    public static String edatatypeToString(EDataType edatatype) {
        String nsuri = edatatype.getEPackage().getNsURI();
        String name = edatatype.getName();
        return String.valueOf(nsuri) + '/' + name;
    }

    public static EDataType stringToEDataType(String strid) {
        int lastIndex = strid.lastIndexOf(47);
        if (lastIndex == -1) {
            throw new TeneoException("The database id stored for a datatype is invalid, dbid: " + strid);
        }
        String nsuri = strid.substring(0, lastIndex);
        String name = strid.substring(lastIndex + 1);
        EPackage epack = PackageRegistryProvider.getInstance().getPackageRegistry().getEPackage(nsuri);
        if (epack == null) {
            throw new TeneoException("The dbid " + strid + " and nsuri: " + nsuri + " does not resolve to an epackage");
        }
        EDataType edatatype = (EDataType)epack.getEClassifier(name);
        if (edatatype == null) {
            throw new TeneoException("The dbid " + strid + " and eclassname: " + name + " does not resolve to an EDataType");
        }
        return edatatype;
    }

    public static EStructuralFeature getEStructuralFeature(EObject emfObj, String fieldName) {
        return StoreUtil.getEStructuralFeature(emfObj.eClass(), fieldName);
    }

    public static Object[] getObjectContent(EObject eo) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (EStructuralFeature estruct : eo.eClass().getEAllStructuralFeatures()) {
            Object val = eo.eGet(estruct);
            if (val == null) continue;
            result.add(val);
        }
        return result.toArray(new Object[result.size()]);
    }

    public static EStructuralFeature getEStructuralFeature(EClass eclass, String fieldName) {
        EStructuralFeature reserve = null;
        for (EStructuralFeature estruct : eclass.getEAllStructuralFeatures()) {
            String name = estruct.getName();
            if (name.compareTo(fieldName) == 0) {
                return estruct;
            }
            if (name.compareToIgnoreCase(fieldName) == 0) {
                reserve = estruct;
                continue;
            }
            if ((String.valueOf(name) + "_").compareToIgnoreCase(fieldName) != 0) continue;
            reserve = estruct;
        }
        if (reserve != null) {
            return reserve;
        }
        return null;
    }

    public static EReference[] getManyGroupEReferences(EObject emfObj) {
        ArrayList<EReference> manyRefs = new ArrayList<EReference>();
        for (EStructuralFeature estruct : emfObj.eClass().getEAllStructuralFeatures()) {
            if (!(estruct instanceof EReference) || !((EReference)estruct).isMany() && !StoreUtil.isGroupFeature(estruct) && !StoreUtil.isWildCard(estruct)) continue;
            manyRefs.add((EReference)estruct);
        }
        return manyRefs.toArray(new EReference[manyRefs.size()]);
    }

    public static boolean isGroupFeature(EStructuralFeature estruct) {
        EAnnotation annotation = estruct.getEAnnotation(ANNOTATION_SOURCE);
        if (annotation == null) {
            return false;
        }
        EMap map = annotation.getDetails();
        for (String key : map.keySet()) {
            String value = (String)map.get((Object)key);
            if ("kind".compareTo(key) != 0 || "group".compareTo(value) != 0) continue;
            return true;
        }
        return false;
    }

    public static String getGroupName(EStructuralFeature estruct) {
        EAnnotation annotation = estruct.getEAnnotation(ANNOTATION_SOURCE);
        if (annotation == null) {
            return null;
        }
        boolean isGroup = false;
        String name = null;
        EMap map = annotation.getDetails();
        for (String key : map.keySet()) {
            String value = (String)map.get((Object)key);
            if ("kind".compareTo(key) == 0 && "group".compareTo(value) == 0) {
                isGroup = true;
            }
            if ("name".compareTo(key) != 0) continue;
            name = value;
        }
        if (isGroup) {
            assert (name != null);
            return name;
        }
        return null;
    }

    public static boolean isElementOfGroup(EStructuralFeature estruct, EStructuralFeature groupFeature) {
        EStructuralFeature ef = ExtendedMetaData.INSTANCE.getGroup(estruct);
        return ef == groupFeature;
    }

    public static boolean isElementOfAGroup(EStructuralFeature estruct) {
        EStructuralFeature ef = ExtendedMetaData.INSTANCE.getGroup(estruct);
        return ef != null;
    }

    public static List<EStructuralFeature> getFeaturesOfGroup(EAttribute eattr) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        for (EStructuralFeature efeature : eattr.getEContainingClass().getEStructuralFeatures()) {
            if (!StoreUtil.isElementOfGroup(efeature, (EStructuralFeature)eattr)) continue;
            result.add(efeature);
        }
        return result;
    }

    public static EPackage[] getEPackages(String nsuris) {
        String[] epacknsuris = nsuris.split(",");
        EPackage[] epacks = new EPackage[epacknsuris.length];
        int i = 0;
        while (i < epacknsuris.length) {
            EPackage epack = PackageRegistryProvider.getInstance().getPackageRegistry().getEPackage(epacknsuris[i]);
            if (epack == null) {
                throw new TeneoException("EPackage with nsuri: " + epacknsuris[i] + " can not be found,");
            }
            epacks[i] = epack;
            ++i;
        }
        return epacks;
    }

    public static void setField(Field field, Object obj, Object value) {
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new TeneoException("IllegalAccessException " + obj.getClass().getName() + " field; " + field.getName());
        }
    }

    public static String[] getFileList(String fileName, String additionalLocation) {
        String[] packagelist;
        ArrayList<String> result = new ArrayList<String>();
        log.debug((Object)">>>> Building or descriptor file List");
        if (additionalLocation != null) {
            result.add(additionalLocation);
        }
        String[] stringArray = packagelist = StoreUtil.buildPackagelist();
        int n = packagelist.length;
        int n2 = 0;
        while (n2 < n) {
            String packagePath = stringArray[n2];
            String filePath = String.valueOf(packagePath) + fileName;
            log.debug((Object)("Try path: " + filePath));
            URL url = StoreUtil.class.getResource(filePath);
            if (url != null) {
                log.debug((Object)"!!Found!!");
                result.add(filePath);
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    private static String[] buildPackagelist() {
        ArrayList<String> newPackagePathList = new ArrayList<String>();
        newPackagePathList.add(File.pathSeparator);
        for (Class<?> clazz : EModelResolver.instance().getAllClassesAndInterfaces()) {
            String className = clazz.getName();
            int classNameIndex = className.lastIndexOf(46);
            String trunkClassName = className.substring(0, classNameIndex);
            String startPath = String.valueOf('/') + trunkClassName.replace('.', '/');
            StoreUtil.buildPackagePathFromClassName(startPath, newPackagePathList);
        }
        return newPackagePathList.toArray(new String[newPackagePathList.size()]);
    }

    private static void buildPackagePathFromClassName(String path, ArrayList<String> newPackagePathList) {
        if (newPackagePathList.contains(String.valueOf(path) + '/')) {
            return;
        }
        newPackagePathList.add(String.valueOf(path) + '/');
        int sepIndex = path.lastIndexOf(47);
        if (sepIndex == -1) {
            return;
        }
        StoreUtil.buildPackagePathFromClassName(path.substring(0, sepIndex), newPackagePathList);
    }

    public static void copyFile(File src, File dst) {
        try {
            int len;
            log.debug((Object)("Copy file from " + src.getAbsolutePath() + " to " + dst.getAbsolutePath()));
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            throw new TeneoException("Exception while copying from/to " + src.getAbsolutePath() + "/" + dst.getAbsolutePath(), e);
        }
    }

    public static PersistentStoreAdapter getPersistentStoreAdapter(EObject eObject) {
        PersistentStoreAdapter adapter2;
        for (PersistentStoreAdapter adapter2 : eObject.eAdapters()) {
            if (!PersistentStoreAdapter.class.isAssignableFrom(adapter2.getClass())) continue;
            return adapter2;
        }
        adapter2 = new PersistentStoreAdapter();
        eObject.eAdapters().add((Object)adapter2);
        return adapter2;
    }
}

