/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.resourceattachment.stereotype;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.ide.ui.tests.framework.RuntimeTestRunner;
import org.eclipse.emf.compare.ide.ui.tests.framework.annotations.Compare;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=RuntimeTestRunner.class)
public class RemoveStereotypeApplicationPseudoConflictTest {
    private static Predicate<? super Conflict> hasConflict(final ConflictKind ... kinds) {
        return new Predicate<Conflict>(){

            public boolean apply(Conflict input) {
                return input != null && Arrays.asList(kinds).contains(input.getKind());
            }
        };
    }

    @Compare(left="data/left.uml", right="data/right.uml", ancestor="data/origin.uml")
    public void testPseudoConflictForStereotypeRemoval(Comparison comparison) throws IOException {
        EList conflicts = comparison.getConflicts();
        Optional realConflict = Iterables.tryFind((Iterable)conflicts, RemoveStereotypeApplicationPseudoConflictTest.hasConflict(ConflictKind.REAL));
        Assert.assertEquals((long)2L, (long)conflicts.size());
        Assert.assertFalse((boolean)realConflict.isPresent());
    }
}

