/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.contentmergeviewer.notloadedfragment;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.StorageTypedElement;
import org.eclipse.emf.compare.ide.ui.internal.logical.StreamAccessorStorage;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ThreadedModelResolver;
import org.eclipse.emf.compare.ide.ui.internal.util.PlatformElementUtil;
import org.eclipse.emf.compare.ide.ui.logical.IModelMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.provider.spec.CompareItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class NotLoadedFragmentItemTest {
    private static final String ELLIPSIS = "[ ... ]";
    private static AdapterFactoryItemDelegator itemDelegator;
    private static String SEP;
    private EventBus eventBus;

    static {
        SEP = File.separator;
    }

    @Before
    public void setup() {
        ArrayList factories = Lists.newArrayList();
        factories.add(new CompareItemProviderAdapterFactorySpec());
        this.eventBus = new EventBus();
        factories.add(new TreeItemProviderAdapterFactorySpec(new StructureMergeViewerFilter(this.eventBus)));
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory((Collection)factories);
        itemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
    }

    private Comparison initComparison(String projectName) throws IOException, CoreException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.emf.compare.ide.ui.tests");
        URL entry = bundle.getEntry("src" + SEP + "org" + SEP + "eclipse" + SEP + "emf" + SEP + "compare" + SEP + "ide" + SEP + "ui" + SEP + "tests" + SEP + "structuremergeviewer" + SEP + "notloadedfragment" + SEP + "data" + SEP + projectName + SEP + ".project");
        URL fileURL = FileLocator.toFileURL((URL)entry);
        IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(fileURL.getPath()));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
        if (!project.exists()) {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        IFile leftFile = project.getFile((IPath)new Path("left" + SEP + "R1.ecore"));
        IFile rightFile = project.getFile((IPath)new Path("right" + SEP + "R1.ecore"));
        StorageTypedElement left = new StorageTypedElement((IStorage)leftFile, leftFile.getFullPath().toOSString());
        StorageTypedElement right = new StorageTypedElement((IStorage)rightFile, rightFile.getFullPath().toOSString());
        IFile leftStorage = PlatformElementUtil.findFile((ITypedElement)left);
        if (leftStorage == null) {
            leftStorage = StreamAccessorStorage.fromTypedElement((ITypedElement)left);
        }
        IModelResolver resolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor((IStorage)leftStorage);
        Assert.assertTrue((boolean)(resolver instanceof ThreadedModelResolver));
        ComparisonScopeBuilder scopeBuilder = new ComparisonScopeBuilder(resolver, (IModelMinimizer)EMFCompareIDEUIPlugin.getDefault().getModelMinimizerRegistry().getCompoundMinimizer(), null);
        IComparisonScope scope = scopeBuilder.build((ITypedElement)left, (ITypedElement)right, null, (IProgressMonitor)new NullProgressMonitor());
        Comparison comparison = EMFCompare.builder().build().compare(scope);
        return comparison;
    }

    @Test
    public void testCase0() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case0");
        EList differences = comparison.getDifferences();
        Predicate predicate_E = EMFComparePredicates.addedToReference((String)"B", (String)"eSubpackages", (String)"B.E");
        Diff diff_E = (Diff)Iterators.find(differences.iterator(), (Predicate)predicate_E);
        EObject value_E = (EObject)MergeViewerUtil.getDiffValue((Diff)diff_E);
        Match match_E = comparison.getMatch(value_E);
        MergeViewerItem.Container item_E = new MergeViewerItem.Container(comparison, diff_E, match_E, IMergeViewer.MergeViewerSide.LEFT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"E", (Object)itemDelegator.getText(item_E.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_B = item_E.getParent();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_Ellipsis = item_B.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        Assert.assertNull((Object)item_Ellipsis.getParent());
        IMergeViewerItem[] item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_Ellipsis_Children.length);
        item_B = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_E = new MergeViewerItem.Container(comparison, diff_E, match_E, IMergeViewer.MergeViewerSide.RIGHT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"", (Object)itemDelegator.getText(item_E.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_B = item_E.getParent();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = item_B.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        Assert.assertNull((Object)item_Ellipsis.getParent());
        item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_Ellipsis_Children.length);
        item_B = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
    }

    @Test
    public void testCase1() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case1");
        EList differences = comparison.getDifferences();
        Predicate predicate_F = EMFComparePredicates.addedToReference((String)"D", (String)"eSubpackages", (String)"D.F");
        Diff diff_F = (Diff)Iterators.find(differences.iterator(), (Predicate)predicate_F);
        EObject value_F = (EObject)MergeViewerUtil.getDiffValue((Diff)diff_F);
        Match match_F = comparison.getMatch(value_F);
        MergeViewerItem.Container item_F = new MergeViewerItem.Container(comparison, diff_F, match_F, IMergeViewer.MergeViewerSide.LEFT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"F", (Object)itemDelegator.getText(item_F.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_D = item_F.getParent();
        Assert.assertEquals((Object)"D", (Object)itemDelegator.getText(item_D.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_Ellipsis = item_D.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_A = item_Ellipsis.getParent();
        Assert.assertEquals((Object)"A", (Object)itemDelegator.getText(item_A.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        Assert.assertNull((Object)item_A.getParent());
        IMergeViewerItem[] item_A_Children = item_A.getChildren(null, null);
        Assert.assertEquals((long)2L, (long)item_A_Children.length);
        IMergeViewerItem.Container item_C = (IMergeViewerItem.Container)item_A_Children[0];
        Assert.assertEquals((Object)"", (Object)itemDelegator.getText(item_C.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_A_Children[1];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem[] item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_Ellipsis_Children.length);
        item_D = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)"D", (Object)itemDelegator.getText(item_D.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_F = new MergeViewerItem.Container(comparison, diff_F, match_F, IMergeViewer.MergeViewerSide.RIGHT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"", (Object)itemDelegator.getText(item_F.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_D = item_F.getParent();
        Assert.assertEquals((Object)"D", (Object)itemDelegator.getText(item_D.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = item_D.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_A = item_Ellipsis.getParent();
        Assert.assertEquals((Object)"A", (Object)itemDelegator.getText(item_A.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        Assert.assertNull((Object)item_A.getParent());
        item_A_Children = item_A.getChildren(null, null);
        Assert.assertEquals((long)2L, (long)item_A_Children.length);
        item_C = (IMergeViewerItem.Container)item_A_Children[0];
        Assert.assertEquals((Object)"C", (Object)itemDelegator.getText(item_C.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_A_Children[1];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_Ellipsis_Children.length);
        item_D = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)"D", (Object)itemDelegator.getText(item_D.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
    }

    @Test
    public void testCase2() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case2");
        EList differences = comparison.getDifferences();
        Predicate predicate_E = EMFComparePredicates.addedToReference((String)"B.D", (String)"eSubpackages", (String)"B.D.E");
        Diff diff_E = (Diff)Iterators.find(differences.iterator(), (Predicate)predicate_E);
        EObject value_E = (EObject)MergeViewerUtil.getDiffValue((Diff)diff_E);
        Match match_E = comparison.getMatch(value_E);
        MergeViewerItem.Container item_E = new MergeViewerItem.Container(comparison, diff_E, match_E, IMergeViewer.MergeViewerSide.LEFT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"E", (Object)itemDelegator.getText(item_E.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_D = item_E.getParent();
        Assert.assertEquals((Object)"D", (Object)itemDelegator.getText(item_D.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_B = item_D.getParent();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_Ellipsis = item_B.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        Assert.assertNull((Object)item_Ellipsis.getParent());
        IMergeViewerItem[] item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_Ellipsis_Children.length);
        item_B = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_E = new MergeViewerItem.Container(comparison, diff_E, match_E, IMergeViewer.MergeViewerSide.RIGHT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"", (Object)itemDelegator.getText(item_E.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_D = item_E.getParent();
        Assert.assertEquals((Object)"D", (Object)itemDelegator.getText(item_D.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_B = item_D.getParent();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = item_B.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        Assert.assertNull((Object)item_Ellipsis.getParent());
        item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_Ellipsis_Children.length);
        item_B = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
    }

    @Test
    public void testCase3() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case3");
        EList differences = comparison.getDifferences();
        Predicate predicate_F = EMFComparePredicates.addedToReference((String)"E", (String)"eSubpackages", (String)"E.F");
        Diff diff_F = (Diff)Iterators.find(differences.iterator(), (Predicate)predicate_F);
        EObject value_F = (EObject)MergeViewerUtil.getDiffValue((Diff)diff_F);
        Match match_F = comparison.getMatch(value_F);
        MergeViewerItem.Container item_F = new MergeViewerItem.Container(comparison, diff_F, match_F, IMergeViewer.MergeViewerSide.LEFT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"F", (Object)itemDelegator.getText(item_F.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_E = item_F.getParent();
        Assert.assertEquals((Object)"E", (Object)itemDelegator.getText(item_E.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_Ellipsis = item_E.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_B = item_Ellipsis.getParent();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis = item_B.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        Assert.assertNull((Object)item_Ellipsis.getParent());
        IMergeViewerItem[] item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_Ellipsis_Children.length);
        item_B = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem[] item_B_Children = item_B.getChildren(null, null);
        Assert.assertEquals((long)2L, (long)item_B_Children.length);
        IMergeViewerItem.Container item_C = (IMergeViewerItem.Container)item_B_Children[0];
        Assert.assertEquals((Object)"", (Object)itemDelegator.getText(item_C.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_B_Children[1];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_Ellipsis_Children.length);
        item_E = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)"E", (Object)itemDelegator.getText(item_E.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_F = new MergeViewerItem.Container(comparison, diff_F, match_F, IMergeViewer.MergeViewerSide.RIGHT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"", (Object)itemDelegator.getText(item_F.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_E = item_F.getParent();
        Assert.assertEquals((Object)"E", (Object)itemDelegator.getText(item_E.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = item_E.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_B = item_Ellipsis.getParent();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = item_B.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        Assert.assertNull((Object)item_Ellipsis.getParent());
        item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_Ellipsis_Children.length);
        item_B = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_B_Children = item_B.getChildren(null, null);
        Assert.assertEquals((long)2L, (long)item_B_Children.length);
        item_C = (IMergeViewerItem.Container)item_B_Children[0];
        Assert.assertEquals((Object)"C", (Object)itemDelegator.getText(item_C.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_B_Children[1];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_Ellipsis_Children.length);
        item_E = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)"E", (Object)itemDelegator.getText(item_E.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
    }

    @Test
    public void testCase4() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case4");
        EList differences = comparison.getDifferences();
        Predicate predicate_D = EMFComparePredicates.removedFromReference((String)"B", (String)"eSubpackages", (String)"B.D");
        Diff diff_D = (Diff)Iterators.find(differences.iterator(), (Predicate)predicate_D);
        EObject value_D = (EObject)MergeViewerUtil.getDiffValue((Diff)diff_D);
        Match match_D = comparison.getMatch(value_D);
        MergeViewerItem.Container item_D = new MergeViewerItem.Container(comparison, diff_D, match_D, IMergeViewer.MergeViewerSide.LEFT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"", (Object)itemDelegator.getText(item_D.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_B = item_D.getParent();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_Ellipsis = item_B.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis = item_Ellipsis.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        Assert.assertNull((Object)item_Ellipsis.getParent());
        IMergeViewerItem[] item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)2L, (long)item_Ellipsis_Children.length);
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem[] item_R2_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R2_Children.length);
        item_B = (IMergeViewerItem.Container)item_R2_Children[0];
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[1];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem[] item_R3_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R3_Children.length);
        IMergeViewerItem.Container item_C = (IMergeViewerItem.Container)item_R3_Children[0];
        Assert.assertEquals((Object)"C", (Object)itemDelegator.getText(item_C.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_D = new MergeViewerItem.Container(comparison, diff_D, match_D, IMergeViewer.MergeViewerSide.RIGHT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"D", (Object)itemDelegator.getText(item_D.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_B = item_D.getParent();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = item_B.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = item_Ellipsis.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        Assert.assertNull((Object)item_Ellipsis.getParent());
        item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)2L, (long)item_Ellipsis_Children.length);
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_R2_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R2_Children.length);
        item_B = (IMergeViewerItem.Container)item_R2_Children[0];
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[1];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_R3_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R3_Children.length);
        item_C = (IMergeViewerItem.Container)item_R3_Children[0];
        Assert.assertEquals((Object)"C", (Object)itemDelegator.getText(item_C.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
    }

    @Test
    public void testCase5() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case5");
        EList differences = comparison.getDifferences();
        Predicate predicate_H = EMFComparePredicates.removedFromReference((String)"F", (String)"eSubpackages", (String)"F.H");
        Diff diff_H = (Diff)Iterators.find(differences.iterator(), (Predicate)predicate_H);
        EObject value_H = (EObject)MergeViewerUtil.getDiffValue((Diff)diff_H);
        Match match_H = comparison.getMatch(value_H);
        MergeViewerItem.Container item_H = new MergeViewerItem.Container(comparison, diff_H, match_H, IMergeViewer.MergeViewerSide.LEFT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"", (Object)itemDelegator.getText(item_H.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_F = item_H.getParent();
        Assert.assertEquals((Object)"F", (Object)itemDelegator.getText(item_F.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_Ellipsis = item_F.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis = item_Ellipsis.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        Assert.assertNull((Object)item_Ellipsis.getParent());
        IMergeViewerItem[] item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)2L, (long)item_Ellipsis_Children.length);
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem[] item_R6_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R6_Children.length);
        item_F = (IMergeViewerItem.Container)item_R6_Children[0];
        Assert.assertEquals((Object)"F", (Object)itemDelegator.getText(item_F.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[1];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem[] item_R7_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R7_Children.length);
        IMergeViewerItem.Container item_G = (IMergeViewerItem.Container)item_R7_Children[0];
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText(item_G.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_H = new MergeViewerItem.Container(comparison, diff_H, match_H, IMergeViewer.MergeViewerSide.RIGHT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"H", (Object)itemDelegator.getText(item_H.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_F = item_H.getParent();
        Assert.assertEquals((Object)"F", (Object)itemDelegator.getText(item_F.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = item_F.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = item_Ellipsis.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        Assert.assertNull((Object)item_Ellipsis.getParent());
        item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)2L, (long)item_Ellipsis_Children.length);
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_R6_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R6_Children.length);
        item_F = (IMergeViewerItem.Container)item_R6_Children[0];
        Assert.assertEquals((Object)"F", (Object)itemDelegator.getText(item_F.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[1];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_R7_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R7_Children.length);
        item_G = (IMergeViewerItem.Container)item_R7_Children[0];
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText(item_G.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
    }

    @Test
    public void testCase6() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case6");
        EList differences = comparison.getDifferences();
        Predicate predicate_I = EMFComparePredicates.removedFromReference((String)"G", (String)"eSubpackages", (String)"G.I");
        Diff diff_I = (Diff)Iterators.find(differences.iterator(), (Predicate)predicate_I);
        EObject value_I = (EObject)MergeViewerUtil.getDiffValue((Diff)diff_I);
        Match match_I = comparison.getMatch(value_I);
        MergeViewerItem.Container item_I = new MergeViewerItem.Container(comparison, diff_I, match_I, IMergeViewer.MergeViewerSide.LEFT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"", (Object)itemDelegator.getText(item_I.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_G = item_I.getParent();
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText(item_G.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_Ellipsis = item_G.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_B = item_Ellipsis.getParent();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis = item_B.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis = item_Ellipsis.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        Assert.assertNull((Object)item_Ellipsis.getParent());
        IMergeViewerItem[] item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)2L, (long)item_Ellipsis_Children.length);
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem[] item_R2_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R2_Children.length);
        item_B = (IMergeViewerItem.Container)item_R2_Children[0];
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem[] item_B_Children = item_B.getChildren(null, null);
        Assert.assertEquals((long)3L, (long)item_B_Children.length);
        IMergeViewerItem.Container item_E = (IMergeViewerItem.Container)item_B_Children[0];
        Assert.assertEquals((Object)"E", (Object)itemDelegator.getText(item_E.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_B_Children[1];
        Assert.assertEquals((Object)"[ ... ] (R5.ecore)", (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem[] item_R5_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R5_Children.length);
        item_G = (IMergeViewerItem.Container)item_R5_Children[0];
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText(item_G.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_B_Children[2];
        Assert.assertEquals((Object)"[ ... ] (R6.ecore)", (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem[] item_R6_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R6_Children.length);
        IMergeViewerItem.Container item_H = (IMergeViewerItem.Container)item_R6_Children[0];
        Assert.assertEquals((Object)"H", (Object)itemDelegator.getText(item_H.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[1];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem[] item_R3_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R3_Children.length);
        IMergeViewerItem.Container item_C = (IMergeViewerItem.Container)item_R3_Children[0];
        Assert.assertEquals((Object)"C", (Object)itemDelegator.getText(item_C.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_I = new MergeViewerItem.Container(comparison, diff_I, match_I, IMergeViewer.MergeViewerSide.RIGHT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"I", (Object)itemDelegator.getText(item_I.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_G = item_I.getParent();
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText(item_G.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = item_G.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_B = item_Ellipsis.getParent();
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = item_B.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = item_Ellipsis.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        Assert.assertNull((Object)item_Ellipsis.getParent());
        item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)2L, (long)item_Ellipsis_Children.length);
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_R2_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R2_Children.length);
        item_B = (IMergeViewerItem.Container)item_R2_Children[0];
        Assert.assertEquals((Object)"B", (Object)itemDelegator.getText(item_B.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_B_Children = item_B.getChildren(null, null);
        Assert.assertEquals((long)3L, (long)item_B_Children.length);
        item_E = (IMergeViewerItem.Container)item_B_Children[0];
        Assert.assertEquals((Object)"", (Object)itemDelegator.getText(item_E.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_B_Children[1];
        Assert.assertEquals((Object)"[ ... ] (R5.ecore)", (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_R5_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R5_Children.length);
        item_G = (IMergeViewerItem.Container)item_R5_Children[0];
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText(item_G.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_B_Children[2];
        Assert.assertEquals((Object)"[ ... ] (R6.ecore)", (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_R6_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R6_Children.length);
        item_H = (IMergeViewerItem.Container)item_R6_Children[0];
        Assert.assertEquals((Object)"H", (Object)itemDelegator.getText(item_H.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[1];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_R3_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R3_Children.length);
        item_C = (IMergeViewerItem.Container)item_R3_Children[0];
        Assert.assertEquals((Object)"C", (Object)itemDelegator.getText(item_C.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
    }

    @Test
    public void testCase7() throws IOException, CoreException {
        Comparison comparison = this.initComparison("case7");
        EList differences = comparison.getDifferences();
        Predicate predicate_I = EMFComparePredicates.removedFromReference((String)"G", (String)"eSubpackages", (String)"G.I");
        Diff diff_I = (Diff)Iterators.find(differences.iterator(), (Predicate)predicate_I);
        EObject value_I = (EObject)MergeViewerUtil.getDiffValue((Diff)diff_I);
        Match match_I = comparison.getMatch(value_I);
        MergeViewerItem.Container item_I = new MergeViewerItem.Container(comparison, diff_I, match_I, IMergeViewer.MergeViewerSide.LEFT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"", (Object)itemDelegator.getText(item_I.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_G = item_I.getParent();
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText(item_G.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem.Container item_Ellipsis = item_G.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis = item_Ellipsis.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        Assert.assertNull((Object)item_Ellipsis.getParent());
        IMergeViewerItem[] item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)3L, (long)item_Ellipsis_Children.length);
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem[] item_R3_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R3_Children.length);
        IMergeViewerItem.Container item_C = (IMergeViewerItem.Container)item_R3_Children[0];
        Assert.assertEquals((Object)"C", (Object)itemDelegator.getText(item_C.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[1];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem[] item_R5_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R5_Children.length);
        item_G = (IMergeViewerItem.Container)item_R5_Children[0];
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText(item_G.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[2];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        IMergeViewerItem[] item_R6_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R6_Children.length);
        IMergeViewerItem.Container item_H = (IMergeViewerItem.Container)item_R6_Children[0];
        Assert.assertEquals((Object)"H", (Object)itemDelegator.getText(item_H.getSideValue(IMergeViewer.MergeViewerSide.LEFT)));
        item_I = new MergeViewerItem.Container(comparison, diff_I, match_I, IMergeViewer.MergeViewerSide.LEFT, itemDelegator.getAdapterFactory());
        Assert.assertEquals((Object)"I", (Object)itemDelegator.getText(item_I.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_G = item_I.getParent();
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText(item_G.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = item_G.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = item_Ellipsis.getParent();
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        Assert.assertNull((Object)item_Ellipsis.getParent());
        item_Ellipsis_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)3L, (long)item_Ellipsis_Children.length);
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[0];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_R3_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R3_Children.length);
        item_C = (IMergeViewerItem.Container)item_R3_Children[0];
        Assert.assertEquals((Object)"C", (Object)itemDelegator.getText(item_C.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[1];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_R5_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R5_Children.length);
        item_G = (IMergeViewerItem.Container)item_R5_Children[0];
        Assert.assertEquals((Object)"G", (Object)itemDelegator.getText(item_G.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_Ellipsis = (IMergeViewerItem.Container)item_Ellipsis_Children[2];
        Assert.assertEquals((Object)ELLIPSIS, (Object)itemDelegator.getText(item_Ellipsis.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
        item_R6_Children = item_Ellipsis.getChildren(null, null);
        Assert.assertEquals((long)1L, (long)item_R6_Children.length);
        item_H = (IMergeViewerItem.Container)item_R6_Children[0];
        Assert.assertEquals((Object)"H", (Object)itemDelegator.getText(item_H.getSideValue(IMergeViewer.MergeViewerSide.RIGHT)));
    }
}

