/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.models;

import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class SampleResourceMapping
extends ResourceMapping {
    private final IFile file;
    private final String providerId;

    public SampleResourceMapping(IFile file, String providerId) {
        this.file = file;
        this.providerId = providerId;
    }

    public Object getModelObject() {
        return this.file;
    }

    public String getModelProviderId() {
        return this.providerId;
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        LinkedHashSet<IFile> sampleSiblings = new LinkedHashSet<IFile>();
        IResource[] iResourceArray = this.file.getParent().members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IFile && "sample".equals(res.getFileExtension())) {
                sampleSiblings.add((IFile)res);
            }
            ++n2;
        }
        IResource[] resourceArray = sampleSiblings.toArray(new IResource[sampleSiblings.size()]);
        return new ResourceTraversal[]{new ResourceTraversal(resourceArray, 1, 0)};
    }

    public IProject[] getProjects() {
        return new IProject[]{this.file.getProject()};
    }
}

