/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.unit;

import java.util.ArrayList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.tests.unit.AbstractCompareTest;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.junit.Assert;
import org.junit.Test;

public class AttributeChangeTest
extends AbstractCompareTest {
    @Test
    public void testRequires() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_Requires();
        AttributeChange attributeChange = CompareFactory.eINSTANCE.createAttributeChange();
        attributeChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Diff requiresValue = CompareFactory.eINSTANCE.createDiff();
        ArrayList<Diff> listRequires = new ArrayList<Diff>(1);
        listRequires.add(requiresValue);
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)attributeChange.getRequires().isEmpty());
        attributeChange.getRequires().add((Object)requiresValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)attributeChange.getRequires().contains((Object)requiresValue));
        Assert.assertSame((Object)attributeChange.getRequires(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getRequires(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)requiresValue.getRequiredBy().contains((Object)attributeChange));
        attributeChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)attributeChange.getRequires().isEmpty());
        Assert.assertSame((Object)attributeChange.getRequires(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getRequires(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)requiresValue.getRequiredBy().contains((Object)attributeChange));
        attributeChange.eSet((EStructuralFeature)feature, listRequires);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)attributeChange.getRequires().contains((Object)requiresValue));
        Assert.assertSame((Object)attributeChange.getRequires(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getRequires(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)requiresValue.getRequiredBy().contains((Object)attributeChange));
    }

    @Test
    public void testRequiredBy() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_RequiredBy();
        AttributeChange attributeChange = CompareFactory.eINSTANCE.createAttributeChange();
        attributeChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Diff requiredByValue = CompareFactory.eINSTANCE.createDiff();
        ArrayList<Diff> listRequiredBy = new ArrayList<Diff>(1);
        listRequiredBy.add(requiredByValue);
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)attributeChange.getRequiredBy().isEmpty());
        attributeChange.getRequiredBy().add((Object)requiredByValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)attributeChange.getRequiredBy().contains((Object)requiredByValue));
        Assert.assertSame((Object)attributeChange.getRequiredBy(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getRequiredBy(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)requiredByValue.getRequires().contains((Object)attributeChange));
        attributeChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)attributeChange.getRequiredBy().isEmpty());
        Assert.assertSame((Object)attributeChange.getRequiredBy(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getRequiredBy(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)requiredByValue.getRequires().contains((Object)attributeChange));
        attributeChange.eSet((EStructuralFeature)feature, listRequiredBy);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)attributeChange.getRequiredBy().contains((Object)requiredByValue));
        Assert.assertSame((Object)attributeChange.getRequiredBy(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getRequiredBy(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)requiredByValue.getRequires().contains((Object)attributeChange));
    }

    @Test
    public void testRefines() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_Refines();
        AttributeChange attributeChange = CompareFactory.eINSTANCE.createAttributeChange();
        attributeChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Diff refinesValue = CompareFactory.eINSTANCE.createDiff();
        ArrayList<Diff> listRefines = new ArrayList<Diff>(1);
        listRefines.add(refinesValue);
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)attributeChange.getRefines().isEmpty());
        attributeChange.getRefines().add((Object)refinesValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)attributeChange.getRefines().contains((Object)refinesValue));
        Assert.assertSame((Object)attributeChange.getRefines(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getRefines(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)refinesValue.getRefinedBy().contains((Object)attributeChange));
        attributeChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)attributeChange.getRefines().isEmpty());
        Assert.assertSame((Object)attributeChange.getRefines(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getRefines(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)refinesValue.getRefinedBy().contains((Object)attributeChange));
        attributeChange.eSet((EStructuralFeature)feature, listRefines);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)attributeChange.getRefines().contains((Object)refinesValue));
        Assert.assertSame((Object)attributeChange.getRefines(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getRefines(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)refinesValue.getRefinedBy().contains((Object)attributeChange));
    }

    @Test
    public void testRefinedBy() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_RefinedBy();
        AttributeChange attributeChange = CompareFactory.eINSTANCE.createAttributeChange();
        attributeChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Diff refinedByValue = CompareFactory.eINSTANCE.createDiff();
        ArrayList<Diff> listRefinedBy = new ArrayList<Diff>(1);
        listRefinedBy.add(refinedByValue);
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)attributeChange.getRefinedBy().isEmpty());
        attributeChange.getRefinedBy().add((Object)refinedByValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)attributeChange.getRefinedBy().contains((Object)refinedByValue));
        Assert.assertSame((Object)attributeChange.getRefinedBy(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getRefinedBy(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)refinedByValue.getRefines().contains((Object)attributeChange));
        attributeChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)attributeChange.getRefinedBy().isEmpty());
        Assert.assertSame((Object)attributeChange.getRefinedBy(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getRefinedBy(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)refinedByValue.getRefines().contains((Object)attributeChange));
        attributeChange.eSet((EStructuralFeature)feature, listRefinedBy);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)attributeChange.getRefinedBy().contains((Object)refinedByValue));
        Assert.assertSame((Object)attributeChange.getRefinedBy(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getRefinedBy(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)refinedByValue.getRefines().contains((Object)attributeChange));
    }

    @Test
    public void testMatch() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_Match();
        AttributeChange attributeChange = CompareFactory.eINSTANCE.createAttributeChange();
        attributeChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Match matchValue = CompareFactory.eINSTANCE.createMatch();
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertNull((Object)attributeChange.getMatch());
        attributeChange.setMatch(matchValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)matchValue, (Object)attributeChange.getMatch());
        Assert.assertSame((Object)attributeChange.getMatch(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getMatch(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)matchValue.getDifferences().contains((Object)attributeChange));
        attributeChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)attributeChange.getMatch());
        Assert.assertSame((Object)attributeChange.getMatch(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getMatch(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)matchValue.getDifferences().contains((Object)attributeChange));
        attributeChange.setMatch(matchValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)matchValue, (Object)attributeChange.getMatch());
        Assert.assertSame((Object)attributeChange.getMatch(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getMatch(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)matchValue.getDifferences().contains((Object)attributeChange));
        attributeChange.eSet((EStructuralFeature)feature, (Object)matchValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)matchValue, (Object)attributeChange.getMatch());
        Assert.assertSame((Object)attributeChange.getMatch(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getMatch(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)matchValue.getDifferences().contains((Object)attributeChange));
        attributeChange.setMatch(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)attributeChange.getMatch());
        Assert.assertSame((Object)feature.getDefaultValue(), (Object)attributeChange.getMatch());
        Assert.assertSame((Object)attributeChange.getMatch(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getMatch(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)matchValue.getDifferences().contains((Object)attributeChange));
    }

    @Test
    public void testEquivalence() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_Equivalence();
        AttributeChange attributeChange = CompareFactory.eINSTANCE.createAttributeChange();
        attributeChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Equivalence equivalenceValue = CompareFactory.eINSTANCE.createEquivalence();
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertNull((Object)attributeChange.getEquivalence());
        attributeChange.setEquivalence(equivalenceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)equivalenceValue, (Object)attributeChange.getEquivalence());
        Assert.assertSame((Object)attributeChange.getEquivalence(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getEquivalence(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)equivalenceValue.getDifferences().contains((Object)attributeChange));
        attributeChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)attributeChange.getEquivalence());
        Assert.assertSame((Object)attributeChange.getEquivalence(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getEquivalence(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)equivalenceValue.getDifferences().contains((Object)attributeChange));
        attributeChange.setEquivalence(equivalenceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)equivalenceValue, (Object)attributeChange.getEquivalence());
        Assert.assertSame((Object)attributeChange.getEquivalence(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getEquivalence(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)equivalenceValue.getDifferences().contains((Object)attributeChange));
        attributeChange.eSet((EStructuralFeature)feature, (Object)equivalenceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)equivalenceValue, (Object)attributeChange.getEquivalence());
        Assert.assertSame((Object)attributeChange.getEquivalence(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getEquivalence(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)equivalenceValue.getDifferences().contains((Object)attributeChange));
        attributeChange.setEquivalence(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)attributeChange.getEquivalence());
        Assert.assertSame((Object)feature.getDefaultValue(), (Object)attributeChange.getEquivalence());
        Assert.assertSame((Object)attributeChange.getEquivalence(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getEquivalence(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)equivalenceValue.getDifferences().contains((Object)attributeChange));
    }

    @Test
    public void testConflict() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_Conflict();
        AttributeChange attributeChange = CompareFactory.eINSTANCE.createAttributeChange();
        attributeChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Conflict conflictValue = CompareFactory.eINSTANCE.createConflict();
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertNull((Object)attributeChange.getConflict());
        attributeChange.setConflict(conflictValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)conflictValue, (Object)attributeChange.getConflict());
        Assert.assertSame((Object)attributeChange.getConflict(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getConflict(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)conflictValue.getDifferences().contains((Object)attributeChange));
        attributeChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)attributeChange.getConflict());
        Assert.assertSame((Object)attributeChange.getConflict(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getConflict(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)conflictValue.getDifferences().contains((Object)attributeChange));
        attributeChange.setConflict(conflictValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)conflictValue, (Object)attributeChange.getConflict());
        Assert.assertSame((Object)attributeChange.getConflict(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getConflict(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)conflictValue.getDifferences().contains((Object)attributeChange));
        attributeChange.eSet((EStructuralFeature)feature, (Object)conflictValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)conflictValue, (Object)attributeChange.getConflict());
        Assert.assertSame((Object)attributeChange.getConflict(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getConflict(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)conflictValue.getDifferences().contains((Object)attributeChange));
        attributeChange.setConflict(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)attributeChange.getConflict());
        Assert.assertSame((Object)feature.getDefaultValue(), (Object)attributeChange.getConflict());
        Assert.assertSame((Object)attributeChange.getConflict(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getConflict(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)conflictValue.getDifferences().contains((Object)attributeChange));
    }

    @Test
    public void testAttribute() {
        EReference feature = ComparePackage.eINSTANCE.getAttributeChange_Attribute();
        AttributeChange attributeChange = CompareFactory.eINSTANCE.createAttributeChange();
        attributeChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        EAttribute attributeValue = EcoreFactory.eINSTANCE.createEAttribute();
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertNull((Object)attributeChange.getAttribute());
        attributeChange.setAttribute(attributeValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)attributeValue, (Object)attributeChange.getAttribute());
        Assert.assertSame((Object)attributeChange.getAttribute(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getAttribute(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)attributeChange.getAttribute());
        Assert.assertSame((Object)attributeChange.getAttribute(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getAttribute(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.setAttribute(attributeValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)attributeValue, (Object)attributeChange.getAttribute());
        Assert.assertSame((Object)attributeChange.getAttribute(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getAttribute(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.eSet((EStructuralFeature)feature, (Object)attributeValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)attributeValue, (Object)attributeChange.getAttribute());
        Assert.assertSame((Object)attributeChange.getAttribute(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getAttribute(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.setAttribute(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)attributeChange.getAttribute());
        Assert.assertSame((Object)feature.getDefaultValue(), (Object)attributeChange.getAttribute());
        Assert.assertSame((Object)attributeChange.getAttribute(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)attributeChange.getAttribute(), (Object)attributeChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testKind() {
        EAttribute feature = ComparePackage.eINSTANCE.getDiff_Kind();
        AttributeChange attributeChange = CompareFactory.eINSTANCE.createAttributeChange();
        attributeChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        DifferenceKind kindValue = (DifferenceKind)feature.getDefaultValue();
        for (DifferenceKind aDifferenceKind : DifferenceKind.VALUES) {
            if (kindValue.getValue() == aDifferenceKind.getValue()) continue;
            kindValue = aDifferenceKind;
            break;
        }
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)attributeChange.getKind());
        attributeChange.setKind(kindValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)kindValue, (Object)attributeChange.getKind());
        Assert.assertEquals((Object)attributeChange.getKind(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)attributeChange.getKind());
        Assert.assertEquals((Object)attributeChange.getKind(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.eSet((EStructuralFeature)feature, (Object)kindValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)kindValue, (Object)attributeChange.getKind());
        Assert.assertEquals((Object)attributeChange.getKind(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.setKind(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)attributeChange.getKind());
        Assert.assertEquals((Object)attributeChange.getKind(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testSource() {
        EAttribute feature = ComparePackage.eINSTANCE.getDiff_Source();
        AttributeChange attributeChange = CompareFactory.eINSTANCE.createAttributeChange();
        attributeChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        DifferenceSource sourceValue = (DifferenceSource)feature.getDefaultValue();
        for (DifferenceSource aDifferenceSource : DifferenceSource.VALUES) {
            if (sourceValue.getValue() == aDifferenceSource.getValue()) continue;
            sourceValue = aDifferenceSource;
            break;
        }
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)attributeChange.getSource());
        attributeChange.setSource(sourceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)sourceValue, (Object)attributeChange.getSource());
        Assert.assertEquals((Object)attributeChange.getSource(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)attributeChange.getSource());
        Assert.assertEquals((Object)attributeChange.getSource(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.eSet((EStructuralFeature)feature, (Object)sourceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)sourceValue, (Object)attributeChange.getSource());
        Assert.assertEquals((Object)attributeChange.getSource(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.setSource(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)attributeChange.getSource());
        Assert.assertEquals((Object)attributeChange.getSource(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testState() {
        EAttribute feature = ComparePackage.eINSTANCE.getDiff_State();
        AttributeChange attributeChange = CompareFactory.eINSTANCE.createAttributeChange();
        attributeChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        DifferenceState stateValue = (DifferenceState)feature.getDefaultValue();
        for (DifferenceState aDifferenceState : DifferenceState.VALUES) {
            if (stateValue.getValue() == aDifferenceState.getValue()) continue;
            stateValue = aDifferenceState;
            break;
        }
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)attributeChange.getState());
        attributeChange.setState(stateValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)stateValue, (Object)attributeChange.getState());
        Assert.assertEquals((Object)attributeChange.getState(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)attributeChange.getState());
        Assert.assertEquals((Object)attributeChange.getState(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.eSet((EStructuralFeature)feature, (Object)stateValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)stateValue, (Object)attributeChange.getState());
        Assert.assertEquals((Object)attributeChange.getState(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.setState(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)attributeChange.getState());
        Assert.assertEquals((Object)attributeChange.getState(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testValue() {
        EAttribute feature = ComparePackage.eINSTANCE.getAttributeChange_Value();
        AttributeChange attributeChange = CompareFactory.eINSTANCE.createAttributeChange();
        attributeChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Object valueValue = this.getValueDistinctFromDefault((EStructuralFeature)feature);
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)attributeChange.getValue());
        attributeChange.setValue(valueValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)valueValue, (Object)attributeChange.getValue());
        Assert.assertEquals((Object)attributeChange.getValue(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)attributeChange.getValue());
        Assert.assertEquals((Object)attributeChange.getValue(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.eSet((EStructuralFeature)feature, valueValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)valueValue, (Object)attributeChange.getValue());
        Assert.assertEquals((Object)attributeChange.getValue(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
        attributeChange.setValue(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)attributeChange.getValue());
        Assert.assertEquals((Object)attributeChange.getValue(), (Object)attributeChange.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)attributeChange.eIsSet((EStructuralFeature)feature));
    }
}

