/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.adapterfactory.context.AbstractContextTester;
import org.eclipse.emf.compare.adapterfactory.context.IContextTester;
import org.eclipse.emf.compare.internal.adapterfactory.RankedAdapterFactoryDescriptor;
import org.eclipse.emf.compare.internal.adapterfactory.RankedAdapterFactoryDescriptorRegistryImpl;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.spec.CompareItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.provider.spec.ComparisonItemProviderSpec;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.junit.Assert;
import org.junit.Test;

public class RankedAdapterFactoryRegistryTest {
    private Multimap<Collection<?>, RankedAdapterFactoryDescriptor> registry;
    private RankedAdapterFactoryDescriptor.Registry rankedRegistry;

    private void setUpAdapterFactoryRegistry(Comparison comparison) {
        this.registry = ArrayListMultimap.create();
        LinkedHashMap context = Maps.newLinkedHashMap();
        context.put("comparison", comparison);
        this.rankedRegistry = new RankedAdapterFactoryDescriptorRegistryImpl(ComposedAdapterFactory.Descriptor.Registry.INSTANCE, this.registry, (Map)context);
    }

    private Comparison createNullComparison() {
        return null;
    }

    private Comparison createComparison() {
        Comparison comparison = CompareFactory.eINSTANCE.createComparison();
        comparison.setThreeWay(true);
        return comparison;
    }

    private IContextTester createMatchingContextTester() {
        return new AbstractContextTester(){

            public boolean apply(Map<Object, Object> context) {
                Comparison comparison = this.getComparison(context);
                return comparison != null && comparison.isThreeWay();
            }
        };
    }

    private IContextTester createNonMatchingContextTester() {
        return new AbstractContextTester(){

            public boolean apply(Map<Object, Object> context) {
                Comparison comparison = this.getComparison(context);
                return comparison == null || !comparison.isThreeWay();
            }
        };
    }

    @Test
    public void testNoContextTesterRankConsidered() {
        Comparison comparison = CompareFactory.eINSTANCE.createComparison();
        this.setUpAdapterFactoryRegistry(this.createNullComparison());
        ArrayList<String> key = new ArrayList<String>();
        key.add("http://www.eclipse.org/emf/compare");
        key.add("org.eclipse.emf.compare.provider.IItemStyledLabelProvider");
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank20-NoContextTester", 20, null));
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank50-NoContextTester", 50, null));
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank70-NoContextTester", 70, null));
        ComposedAdapterFactory fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)this.rankedRegistry);
        Adapter adapter = fAdapterFactory.adapt((Notifier)comparison, IItemStyledLabelProvider.class);
        IStyledString.IComposedStyledString styledText = ((IItemStyledLabelProvider)adapter).getStyledText((Object)comparison);
        Assert.assertEquals((Object)"Rank70-NoContextTester", (Object)styledText.getString());
    }

    @Test
    public void testNoContextContextTesterIgnored() {
        Comparison comparison = CompareFactory.eINSTANCE.createComparison();
        this.setUpAdapterFactoryRegistry(this.createNullComparison());
        ArrayList<String> key = new ArrayList<String>();
        key.add("http://www.eclipse.org/emf/compare");
        key.add("org.eclipse.emf.compare.provider.IItemStyledLabelProvider");
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank20-NoContextTester", 20, null));
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank50-MatchingContextTester", 50, this.createMatchingContextTester()));
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank70-NonMatchingContextTester", 70, this.createNonMatchingContextTester()));
        ComposedAdapterFactory fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)this.rankedRegistry);
        Adapter adapter = fAdapterFactory.adapt((Notifier)comparison, IItemStyledLabelProvider.class);
        IStyledString.IComposedStyledString styledText = ((IItemStyledLabelProvider)adapter).getStyledText((Object)comparison);
        Assert.assertEquals((Object)"Rank20-NoContextTester", (Object)styledText.getString());
    }

    @Test
    public void testNonMatchingContextTesterSkipped() {
        Comparison comparison = this.createComparison();
        this.setUpAdapterFactoryRegistry(comparison);
        ArrayList<String> key = new ArrayList<String>();
        key.add("http://www.eclipse.org/emf/compare");
        key.add("org.eclipse.emf.compare.provider.IItemStyledLabelProvider");
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank20-NoContextTester", 20, null));
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank50-NoContextTester", 50, null));
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank70-NonMatchingContextTester", 70, this.createNonMatchingContextTester()));
        ComposedAdapterFactory fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)this.rankedRegistry);
        Adapter adapter = fAdapterFactory.adapt((Notifier)comparison, IItemStyledLabelProvider.class);
        IStyledString.IComposedStyledString styledText = ((IItemStyledLabelProvider)adapter).getStyledText((Object)comparison);
        Assert.assertEquals((Object)"Rank50-NoContextTester", (Object)styledText.getString());
    }

    @Test
    public void testMatchingContextTesterConsidered() {
        Comparison comparison = this.createComparison();
        this.setUpAdapterFactoryRegistry(comparison);
        ArrayList<String> key = new ArrayList<String>();
        key.add("http://www.eclipse.org/emf/compare");
        key.add("org.eclipse.emf.compare.provider.IItemStyledLabelProvider");
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank20-NoContextTester", 20, null));
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank50-NoContextTester", 50, null));
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank70-MatchingContextTester", 70, this.createMatchingContextTester()));
        ComposedAdapterFactory fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)this.rankedRegistry);
        Adapter adapter = fAdapterFactory.adapt((Notifier)comparison, IItemStyledLabelProvider.class);
        IStyledString.IComposedStyledString styledText = ((IItemStyledLabelProvider)adapter).getStyledText((Object)comparison);
        Assert.assertEquals((Object)"Rank70-MatchingContextTester", (Object)styledText.getString());
    }

    @Test
    public void testContextTesterRanksConsidered() {
        Comparison comparison = this.createComparison();
        this.setUpAdapterFactoryRegistry(comparison);
        ArrayList<String> key = new ArrayList<String>();
        key.add("http://www.eclipse.org/emf/compare");
        key.add("org.eclipse.emf.compare.provider.IItemStyledLabelProvider");
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank20-NoContextTester", 20, null));
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank50-MatchingContextTester", 50, this.createMatchingContextTester()));
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank70-MatchingContextTester", 70, this.createMatchingContextTester()));
        ComposedAdapterFactory fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)this.rankedRegistry);
        Adapter adapter = fAdapterFactory.adapt((Notifier)comparison, IItemStyledLabelProvider.class);
        IStyledString.IComposedStyledString styledText = ((IItemStyledLabelProvider)adapter).getStyledText((Object)comparison);
        Assert.assertEquals((Object)"Rank70-MatchingContextTester", (Object)styledText.getString());
    }

    @Test
    public void testHigherRankBeatsContextTester() {
        Comparison comparison = this.createComparison();
        this.setUpAdapterFactoryRegistry(comparison);
        ArrayList<String> key = new ArrayList<String>();
        key.add("http://www.eclipse.org/emf/compare");
        key.add("org.eclipse.emf.compare.provider.IItemStyledLabelProvider");
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank20-NoContextTester", 20, null));
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank50-MatchingContextTester", 50, this.createMatchingContextTester()));
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank70-NoContextTester", 70, null));
        ComposedAdapterFactory fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)this.rankedRegistry);
        Adapter adapter = fAdapterFactory.adapt((Notifier)comparison, IItemStyledLabelProvider.class);
        IStyledString.IComposedStyledString styledText = ((IItemStyledLabelProvider)adapter).getStyledText((Object)comparison);
        Assert.assertEquals((Object)"Rank70-NoContextTester", (Object)styledText.getString());
    }

    @Test
    public void testEqualRankContextTesterPreferred() {
        Comparison comparison = this.createComparison();
        this.setUpAdapterFactoryRegistry(comparison);
        ArrayList<String> key = new ArrayList<String>();
        key.add("http://www.eclipse.org/emf/compare");
        key.add("org.eclipse.emf.compare.provider.IItemStyledLabelProvider");
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank20-NoContextTester", 20, null));
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank70-NoContextTester", 70, null));
        this.registry.put(key, (Object)new TestAdapterFactoryDescriptor("Rank70-MatchingContextTester", 70, this.createMatchingContextTester()));
        ComposedAdapterFactory fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)this.rankedRegistry);
        Adapter adapter = fAdapterFactory.adapt((Notifier)comparison, IItemStyledLabelProvider.class);
        IStyledString.IComposedStyledString styledText = ((IItemStyledLabelProvider)adapter).getStyledText((Object)comparison);
        Assert.assertEquals((Object)"Rank70-MatchingContextTester", (Object)styledText.getString());
    }

    public class TestAdapterFactoryDescriptor
    implements RankedAdapterFactoryDescriptor {
        AdapterFactory adapterFactory;
        int ranking;
        IContextTester contextTester;

        public TestAdapterFactoryDescriptor(String text, int ranking, IContextTester contextTester) {
            this.adapterFactory = new TestCompareItemProviderAdapterFactorySpec(text);
            this.ranking = ranking;
            this.contextTester = contextTester;
        }

        public AdapterFactory createAdapterFactory() {
            return this.adapterFactory;
        }

        public int getRanking() {
            return this.ranking;
        }

        public IContextTester getContextTester() {
            return this.contextTester;
        }

        public String getId() {
            return this.adapterFactory.getClass().getName();
        }

        public String getLabel() {
            return "";
        }

        public String getDescription() {
            return null;
        }

        public boolean isOptional() {
            return false;
        }
    }

    public class TestCompareItemProviderAdapterFactorySpec
    extends CompareItemProviderAdapterFactorySpec {
        private String text;

        public TestCompareItemProviderAdapterFactorySpec(String text) {
            this.text = text;
        }

        public Adapter createComparisonAdapter() {
            return new TestComparisonItemProviderSpec((AdapterFactory)this, this.text);
        }
    }

    public class TestComparisonItemProviderSpec
    extends ComparisonItemProviderSpec {
        private String text;

        public TestComparisonItemProviderSpec(AdapterFactory adapterFactory, String text) {
            super(adapterFactory);
            this.text = text;
        }

        public IStyledString.IComposedStyledString getStyledText(Object object) {
            return new ComposedStyledString(this.text);
        }
    }
}

