/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.impl;

import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.EqualityHelperExtensionProvider;
import org.eclipse.emf.compare.match.eobject.EqualityHelperExtensionProviderDescriptorRegistryImpl;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.WeightProvider;
import org.eclipse.emf.compare.match.eobject.WeightProviderDescriptorRegistryImpl;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.UseIdentifiers;

public class MatchEngineFactoryImpl
implements IMatchEngine.Factory {
    protected IMatchEngine matchEngine;
    private int ranking;
    private WeightProvider.Descriptor.Registry weightProviderRegistry;
    private EqualityHelperExtensionProvider.Descriptor.Registry equalityHelperExtensionProviderRegistry;

    public MatchEngineFactoryImpl() {
        this(UseIdentifiers.WHEN_AVAILABLE, WeightProviderDescriptorRegistryImpl.createStandaloneInstance(), EqualityHelperExtensionProviderDescriptorRegistryImpl.createStandaloneInstance());
    }

    public MatchEngineFactoryImpl(UseIdentifiers useIDs) {
        this(useIDs, WeightProviderDescriptorRegistryImpl.createStandaloneInstance(), EqualityHelperExtensionProviderDescriptorRegistryImpl.createStandaloneInstance());
    }

    public MatchEngineFactoryImpl(UseIdentifiers useIDs, WeightProvider.Descriptor.Registry weightProviderRegistry) {
        this(useIDs, weightProviderRegistry, EqualityHelperExtensionProviderDescriptorRegistryImpl.createStandaloneInstance());
    }

    public MatchEngineFactoryImpl(UseIdentifiers useIDs, WeightProvider.Descriptor.Registry weightProviderRegistry, EqualityHelperExtensionProvider.Descriptor.Registry equalityHelperExtensionProviderRegistry) {
        DefaultComparisonFactory comparisonFactory = new DefaultComparisonFactory(new DefaultEqualityHelperFactory());
        this.weightProviderRegistry = weightProviderRegistry;
        this.equalityHelperExtensionProviderRegistry = equalityHelperExtensionProviderRegistry;
        IEObjectMatcher matcher = DefaultMatchEngine.createDefaultEObjectMatcher(useIDs, weightProviderRegistry, equalityHelperExtensionProviderRegistry);
        this.matchEngine = new DefaultMatchEngine(matcher, comparisonFactory);
    }

    public MatchEngineFactoryImpl(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
        this.matchEngine = new DefaultMatchEngine(matcher, comparisonFactory);
    }

    @Override
    public IMatchEngine getMatchEngine() {
        return this.matchEngine;
    }

    @Override
    public int getRanking() {
        return this.ranking;
    }

    @Override
    public void setRanking(int r) {
        this.ranking = r;
    }

    @Override
    public boolean isMatchEngineFactoryFor(IComparisonScope scope) {
        return true;
    }

    void setWeightProviderRegistry(WeightProvider.Descriptor.Registry registry) {
        this.weightProviderRegistry = registry;
    }

    public void setEqualityHelperExtensionProviderRegistry(EqualityHelperExtensionProvider.Descriptor.Registry equalityHelperExtensionProviderRegistry) {
        this.equalityHelperExtensionProviderRegistry = equalityHelperExtensionProviderRegistry;
    }
}

