/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.mergeresolution;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ide.ui.internal.mergeresolution.MergeResolutionListenerRegistry;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.TreeNodeCompareInput;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;

public class MergeResolutionManager {
    public static final String EXTENSION_POINT = "org.eclipse.emf.compare.ide.ui.mergeResolutionListener";
    private final MergeResolutionListenerRegistry mergeResolutionListenerRegistry;

    public MergeResolutionManager(MergeResolutionListenerRegistry registry) {
        this.mergeResolutionListenerRegistry = registry;
    }

    public void handleFlush(Object input) {
        if (!(input instanceof TreeNodeCompareInput)) {
            return;
        }
        TreeNodeCompareInput treeNodeCompareInput = (TreeNodeCompareInput)((Object)input);
        EObject eobject = treeNodeCompareInput.getComparisonObject();
        Comparison comparison = ComparisonUtil.getComparison((EObject)eobject);
        if (comparison == null) {
            return;
        }
        if (comparison.getConflicts().size() == 0) {
            return;
        }
        Predicate<Conflict> unresolvedConflict = new Predicate<Conflict>(){

            public boolean apply(Conflict conflict) {
                return conflict != null && conflict.getKind() != ConflictKind.PSEUDO && Iterables.any((Iterable)conflict.getDifferences(), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}));
            }
        };
        if (!Iterables.any((Iterable)comparison.getConflicts(), (Predicate)unresolvedConflict)) {
            this.mergeResolutionListenerRegistry.mergeResolutionCompleted(comparison);
        }
    }
}

