/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import java.util.Map;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.internal.AccessBasedLRUCache;
import org.eclipse.emf.ecore.EObject;

public class CachingDistance
implements ProximityEObjectMatcher.DistanceFunction {
    private ProximityEObjectMatcher.DistanceFunction wrapped;
    private Map<Pair, Double> distanceCache;

    public CachingDistance(ProximityEObjectMatcher.DistanceFunction wrapped) {
        this.wrapped = wrapped;
        this.distanceCache = new AccessBasedLRUCache<Pair, Double>(10000, 1000, 0.75f);
    }

    @Override
    public double distance(Comparison inProgress, EObject a, EObject b) {
        Pair key = new Pair(a, b);
        Double previousResult = this.distanceCache.get(key);
        if (previousResult == null) {
            double dist = this.wrapped.distance(inProgress, a, b);
            this.distanceCache.put(key, dist);
            return dist;
        }
        return previousResult;
    }

    @Override
    public boolean areIdentic(Comparison inProgress, EObject a, EObject b) {
        return this.wrapped.areIdentic(inProgress, a, b);
    }

    class Pair {
        EObject a;
        EObject b;

        public Pair(EObject a, EObject b) {
            this.a = a;
            this.b = b;
        }

        public int hashCode() {
            int second;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            int first = this.a.hashCode();
            if (first > (second = this.b.hashCode())) {
                int tmp = first;
                first = second;
                second = tmp;
            }
            result = 31 * result + first;
            result = 31 * result + second;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return this.a == other.a && this.b == other.b || this.b == other.a && this.a == other.b;
        }

        private CachingDistance getOuterType() {
            return CachingDistance.this;
        }
    }
}

