/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.adapterfactory;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.adapterfactory.context.IContextTester;
import org.eclipse.emf.compare.internal.adapterfactory.RankedAdapterFactoryDescriptor;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.internal.EMFCompareRCPMessages;
import org.eclipse.emf.compare.rcp.internal.adapterfactory.RankedAdapterFactoryDescriptorImpl;

public class AdapterFactoryDescriptorRegistryListener
extends AbstractRegistryEventListener {
    static final String TAG_FACTORY = "factory";
    static final String ATT_CLASS = "class";
    static final String ATT_URI = "uri";
    static final String ATT_SUPPORTED_TYPES = "supportedTypes";
    static final String ATT_RANKING = "ranking";
    static final String ATT_CONTEXT = "context";
    private final Multimap<Collection<?>, RankedAdapterFactoryDescriptor> adapterFactoryRegistry;

    public AdapterFactoryDescriptorRegistryListener(String namespace, String extensionPointID, ILog log, Multimap<Collection<?>, RankedAdapterFactoryDescriptor> adapterFactoryRegistryBackingMultimap) {
        super(namespace, extensionPointID, log);
        this.adapterFactoryRegistry = adapterFactoryRegistryBackingMultimap;
    }

    @Override
    protected boolean validateExtensionElement(IConfigurationElement element) {
        boolean valid;
        if (element.getName().equals(TAG_FACTORY)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
                valid = false;
            } else if (element.getAttribute(ATT_RANKING) == null) {
                this.logMissingAttribute(element, ATT_RANKING);
                valid = false;
            } else if (element.getAttribute(ATT_RANKING) != null) {
                String ordinalStr = element.getAttribute(ATT_RANKING);
                try {
                    Integer.parseInt(ordinalStr);
                }
                catch (NumberFormatException numberFormatException) {
                    this.log(4, element, EMFCompareRCPMessages.getString("malformed.extension.attribute", ATT_RANKING));
                    return false;
                }
                valid = true;
            } else if (element.getAttribute(ATT_URI) == null) {
                this.logMissingAttribute(element, ATT_URI);
                valid = false;
            } else if (element.getAttribute(ATT_SUPPORTED_TYPES) == null) {
                this.logMissingAttribute(element, ATT_SUPPORTED_TYPES);
                valid = false;
            } else {
                valid = true;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    @Override
    protected boolean addedValid(IConfigurationElement element) {
        int ranking = Integer.parseInt(element.getAttribute(ATT_RANKING));
        IContextTester contextTester = null;
        if (element.getAttribute(ATT_CONTEXT) != null) {
            try {
                contextTester = (IContextTester)element.createExecutableExtension(ATT_CONTEXT);
            }
            catch (CoreException coreException) {
                this.log(2, element, EMFCompareRCPMessages.getString("malformed.extension.executable", ATT_CONTEXT, element.getAttribute(ATT_CONTEXT)));
            }
        }
        RankedAdapterFactoryDescriptorImpl descriptor = new RankedAdapterFactoryDescriptorImpl(element, ranking, contextTester);
        String supportedTypes = element.getAttribute(ATT_SUPPORTED_TYPES);
        StringTokenizer stringTokenizer = new StringTokenizer(supportedTypes);
        while (stringTokenizer.hasMoreTokens()) {
            String supportedType = stringTokenizer.nextToken();
            ArrayList<String> key = new ArrayList<String>();
            key.add(element.getAttribute(ATT_URI));
            key.add(supportedType);
            this.adapterFactoryRegistry.put(key, (Object)descriptor);
        }
        return true;
    }

    @Override
    protected boolean removedValid(IConfigurationElement element) {
        String supportedTypes = element.getAttribute(ATT_SUPPORTED_TYPES);
        StringTokenizer stringTokenizer = new StringTokenizer(supportedTypes);
        while (stringTokenizer.hasMoreTokens()) {
            String supportedType = stringTokenizer.nextToken();
            ArrayList<String> key = new ArrayList<String>();
            key.add(element.getAttribute(ATT_URI));
            key.add(supportedType);
            Iterator composedAdapterFactoryIterator = this.adapterFactoryRegistry.get(key).iterator();
            while (composedAdapterFactoryIterator.hasNext()) {
                RankedAdapterFactoryDescriptor next = (RankedAdapterFactoryDescriptor)composedAdapterFactoryIterator.next();
                if (next.getId() == null || !next.getId().equals(element.getAttribute(ATT_CLASS))) continue;
                composedAdapterFactoryIterator.remove();
            }
        }
        return true;
    }
}

