/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFResourceMapping;
import org.eclipse.emf.compare.ide.ui.internal.logical.IdenticalResourceMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.ComputeDiffsToMerge;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.MergeBlockedByConflictException;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.IResourceMappingMerger;
import org.eclipse.team.core.mapping.provider.MergeStatus;

public class EMFResourceMappingMerger
implements IResourceMappingMerger {
    protected static final IMerger.Registry2 MERGER_REGISTRY = (IMerger.Registry2)EMFCompareRCPPlugin.getDefault().getMergerRegistry();

    public IStatus merge(IMergeContext mergeContext, IProgressMonitor monitor) throws CoreException {
        ResourceMapping[] emfMappings = this.getEMFMappings(mergeContext);
        this.log(0, "EMFResourceMappingMerger.startingModelMerge", emfMappings);
        Object shortcutStatus = Status.OK_STATUS;
        shortcutStatus = emfMappings.length <= 0 ? new Status(4, "org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString("EMFResourceMappingMerger.mergeFailedGeneric")) : this.validateMappings(emfMappings);
        if (shortcutStatus.getSeverity() != 0) {
            return shortcutStatus;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)emfMappings.length);
        try {
            HashSet<ResourceMapping> failingMappings = new HashSet<ResourceMapping>();
            ResourceMapping[] resourceMappingArray = emfMappings;
            int n = emfMappings.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceMapping mapping = resourceMappingArray[n2];
                this.mergeMapping(mapping, mergeContext, failingMappings, (IProgressMonitor)subMonitor.newChild(1));
                ++n2;
            }
            IStatus status = Status.OK_STATUS;
            if (!failingMappings.isEmpty()) {
                ResourceMapping[] failingArray = failingMappings.toArray(new ResourceMapping[failingMappings.size()]);
                status = new MergeStatus("org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString("EMFResourceMappingMerger.mergeFailedConflicts"), failingArray);
            } else {
                this.log(0, "EMFResourceMappingMerger.successfulModelMerge", emfMappings);
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void log(int statusCode, String key, ResourceMapping[] emfMappings) {
        List<IResource> iResources = this.getInvolvedIResources(emfMappings);
        String message = EMFCompareIDEUIMessages.getString(key, String.valueOf(iResources.size()));
        this.log(statusCode, message, iResources);
    }

    private void log(int statusCode, String message, Collection<IResource> iResources) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.emf.compare.ide.ui", 0, message, null);
        for (IResource iResource : iResources) {
            Status childStatus = new Status(statusCode, "org.eclipse.emf.compare.ide.ui", iResource.getFullPath().toOSString());
            multiStatus.add((IStatus)childStatus);
        }
        this.log((IStatus)multiStatus);
    }

    private List<IResource> getInvolvedIResources(ResourceMapping[] emfMappings) {
        ArrayList<IResource> iResources = new ArrayList<IResource>();
        ResourceMapping[] resourceMappingArray = emfMappings;
        int n = emfMappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            if (mapping instanceof EMFResourceMapping) {
                SynchronizationModel syncModel = ((EMFResourceMapping)mapping).getLatestModel();
                for (IResource iResource : syncModel.getResources()) {
                    iResources.add(iResource);
                }
            }
            ++n2;
        }
        return iResources;
    }

    private void log(IStatus status) {
        EMFCompareIDEUIPlugin.getDefault().getLog().log(status);
    }

    protected void mergeMapping(ResourceMapping mapping, IMergeContext mergeContext, Set<ResourceMapping> failingMappings, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        SynchronizationModel syncModel = ((EMFResourceMapping)mapping).getLatestModel();
        this.removeNonExistingStorages(syncModel.getLeftTraversal());
        LinkedHashSet resources = Sets.newLinkedHashSet(syncModel.getResources());
        IdenticalResourceMinimizer minimizer = new IdenticalResourceMinimizer();
        minimizer.minimize(syncModel, (IProgressMonitor)subMonitor.newChild(1));
        IComparisonScope scope = ComparisonScopeBuilder.create(syncModel, (IProgressMonitor)subMonitor.newChild(3));
        EMFCompare.Builder builder = EMFCompare.builder();
        EMFCompareBuilderConfigurator.createDefault().configure(builder);
        Comparison comparison = builder.build().compare(scope, BasicMonitor.toMonitor((IProgressMonitorWithBlocking)SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (int)10)));
        if (this.hasRealConflict(comparison)) {
            Set<URI> conflictingURIs = this.performPreMerge(comparison, subMonitor.newChild(3));
            this.save(scope.getLeft(), syncModel.getLeftTraversal(), syncModel.getRightTraversal(), syncModel.getOriginTraversal());
            failingMappings.add(mapping);
            this.markResourcesAsMerged(mergeContext, resources, conflictingURIs, subMonitor.newChild(2));
        } else {
            ResourceAdditionAndDeletionTracker resourceTracker = new ResourceAdditionAndDeletionTracker();
            try {
                scope.getLeft().eAdapters().add((Object)resourceTracker);
                this.performBatchMerge(comparison, subMonitor.newChild(3));
                this.save(scope.getLeft(), syncModel.getLeftTraversal(), syncModel.getRightTraversal(), syncModel.getOriginTraversal());
                this.delegateMergeOfUnmergedResourcesAndMarkDiffsAsMerged(syncModel, mergeContext, resourceTracker, subMonitor.newChild(2));
            }
            finally {
                scope.getLeft().eAdapters().remove((Object)resourceTracker);
            }
        }
        subMonitor.setWorkRemaining(0);
    }

    protected void removeNonExistingStorages(StorageTraversal traversal) {
        for (IStorage storage : traversal.getStorages()) {
            if (!(storage instanceof IFile) || ((IFile)storage).exists()) continue;
            traversal.removeStorage(storage);
        }
    }

    private Set<URI> performPreMerge(Comparison comparison, SubMonitor subMonitor) {
        IPreferenceStore store = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
        boolean preMerge = store.getBoolean("org.eclipse.emf.compare.ide.ui.preference.preMergeOnConflict");
        return this.performPreMerge(comparison, preMerge, subMonitor);
    }

    private Set<URI> performPreMerge(Comparison comparison, boolean preMerge, SubMonitor subMonitor) {
        Monitor emfMonitor = BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor);
        LinkedHashSet<URI> conflictingURIs = new LinkedHashSet<URI>();
        for (Diff next : comparison.getDifferences()) {
            this.doMergeForDiff(preMerge, emfMonitor, conflictingURIs, next);
        }
        return conflictingURIs;
    }

    protected void doMergeForDiff(boolean preMerge, Monitor emfMonitor, Set<URI> conflictingURIs, Diff diff) {
        ComputeDiffsToMerge computer = new ComputeDiffsToMerge(true, MERGER_REGISTRY).failOnRealConflictUnless(Predicates.alwaysFalse());
        try {
            Set diffsToMerge = computer.getAllDiffsToMerge(diff);
            if (preMerge) {
                for (Diff toMerge : diffsToMerge) {
                    IMerger merger = MERGER_REGISTRY.getHighestRankingMerger(toMerge);
                    merger.copyRightToLeft(toMerge, emfMonitor);
                }
            }
        }
        catch (MergeBlockedByConflictException e) {
            conflictingURIs.addAll(this.collectConflictingResources(e.getConflictingDiffs().iterator()));
        }
    }

    protected Set<URI> collectConflictingResources(Iterator<Diff> diffIterator) {
        LinkedHashSet<URI> conflictingURIs = new LinkedHashSet<URI>();
        while (diffIterator.hasNext()) {
            Diff diff = diffIterator.next();
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (diff.getConflict() == null) continue;
            builder.addAll((Iterable)diff.getConflict().getDifferences()).add((Object)diff);
            for (Diff conflictingDiff : builder.build()) {
                Match next = conflictingDiff.getMatch();
                URI leftURI = this.resourceURIorNull(next.getLeft());
                URI rightURI = this.resourceURIorNull(next.getRight());
                URI originURI = this.resourceURIorNull(next.getOrigin());
                if (leftURI != null) {
                    conflictingURIs.add(leftURI);
                }
                if (rightURI != null) {
                    conflictingURIs.add(rightURI);
                }
                if (originURI == null) continue;
                conflictingURIs.add(originURI);
            }
        }
        return conflictingURIs;
    }

    private URI resourceURIorNull(EObject eObject) {
        Resource res;
        if (eObject != null && (res = eObject.eResource()) != null) {
            return res.getURI();
        }
        return null;
    }

    protected void markResourcesAsMerged(IMergeContext context, Set<IResource> resources, Set<URI> conflictingURIs, SubMonitor subMonitor) {
        for (IResource resource : resources) {
            IFile iFile;
            URI uri;
            if (!(resource instanceof IFile) || conflictingURIs.contains(uri = ResourceUtil.createURIFor((IFile)(iFile = (IFile)resource)))) continue;
            this.markAsMerged(context, resource, subMonitor);
        }
    }

    private void markAsMerged(IMergeContext context, IResource resource, SubMonitor subMonitor) {
        IDiff diff = context.getDiffTree().getDiff(resource);
        if (diff != null) {
            try {
                context.markAsMerged(diff, true, (IProgressMonitor)subMonitor);
            }
            catch (CoreException e) {
                EMFCompareIDEUIPlugin.getDefault().log(e);
            }
        }
    }

    private void performBatchMerge(Comparison comparison, SubMonitor subMonitor) {
        BatchMerger merger = new BatchMerger((IMerger.Registry)MERGER_REGISTRY, EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        merger.copyAllRightToLeft((Iterable)comparison.getDifferences(), BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor));
    }

    protected void delegateMergeOfUnmergedResourcesAndMarkDiffsAsMerged(SynchronizationModel syncModel, IMergeContext mergeContext, ResourceAdditionAndDeletionTracker resourceTracker, SubMonitor subMonitor) throws CoreException {
        IDiff diff;
        IPath fullPath;
        for (IFile deletedFile : resourceTracker.getDeletedIFiles()) {
            IDiff diff2 = mergeContext.getDiffTree().getDiff((IResource)deletedFile);
            this.markAsMerged(diff2, mergeContext, subMonitor);
        }
        for (IStorage storage : syncModel.getLeftTraversal().getStorages()) {
            fullPath = ResourceUtil.getFixedPath((IStorage)storage);
            if (fullPath == null) {
                EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString("EMFResourceMappingMerger.mergeIncomplete")));
                continue;
            }
            diff = mergeContext.getDiffTree().getDiff(fullPath);
            if (diff == null) continue;
            if (2 == diff.getKind() && !resourceTracker.containsRemovedResource(fullPath)) {
                this.merge(diff, mergeContext, subMonitor.newChild(1));
                continue;
            }
            this.markAsMerged(diff, mergeContext, subMonitor.newChild(1));
        }
        for (IStorage rightStorage : syncModel.getRightTraversal().getStorages()) {
            fullPath = ResourceUtil.getFixedPath((IStorage)rightStorage);
            if (fullPath == null || (diff = mergeContext.getDiffTree().getDiff(fullPath)) == null || 1 != diff.getKind()) continue;
            if (!resourceTracker.containsAddedResource(fullPath)) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(fullPath);
                IProject project = file.getProject();
                if (project.isAccessible()) {
                    this.merge(diff, mergeContext, subMonitor.newChild(1));
                    continue;
                }
                try {
                    Throwable throwable = null;
                    Object var12_14 = null;
                    try {
                        InputStream inputStream = rightStorage.getContents();
                        try {
                            try (FileOutputStream outputStream = new FileOutputStream(ResourceUtil.getAbsolutePath((IStorage)rightStorage).toFile());){
                                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                            }
                            if (inputStream == null) continue;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            throw throwable;
                        }
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    EMFCompareIDEUIPlugin.getDefault().log(e);
                }
                continue;
            }
            this.markAsMerged(diff, mergeContext, subMonitor.newChild(1));
        }
    }

    protected void merge(IDiff diff, IMergeContext mergeContext, SubMonitor subMonitor) {
        try {
            mergeContext.merge(diff, false, (IProgressMonitor)subMonitor);
        }
        catch (CoreException e) {
            EMFCompareIDEUIPlugin.getDefault().log(e);
        }
    }

    protected void markAsMerged(IDiff diff, IMergeContext mergeContext, SubMonitor subMonitor) {
        try {
            mergeContext.markAsMerged(diff, true, (IProgressMonitor)subMonitor);
        }
        catch (CoreException e) {
            EMFCompareIDEUIPlugin.getDefault().log(e);
        }
    }

    private IStatus validateMappings(ResourceMapping[] mappings) {
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            if (mapping instanceof EMFResourceMapping && mapping.getModelObject() instanceof SynchronizationModel) {
                SynchronizationModel model = (SynchronizationModel)mapping.getModelObject();
                if (model.getDiagnostic().getSeverity() >= 2) {
                    return BasicDiagnostic.toIStatus((Diagnostic)model.getDiagnostic());
                }
            } else {
                return new Status(4, "org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString("EMFResourceMappingMerger.mergeFailedInvalidMapping"));
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    protected void save(Notifier notifier, StorageTraversal leftTraversal, StorageTraversal rightTraversal, StorageTraversal originTraversal) {
        if (notifier instanceof ResourceSet) {
            ResourceUtil.saveAllResources((ResourceSet)((ResourceSet)notifier), (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"), (StorageTraversal)leftTraversal, (StorageTraversal)rightTraversal, (StorageTraversal)originTraversal);
        } else if (notifier instanceof Resource) {
            ResourceUtil.saveResource((Resource)((Resource)notifier), (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"));
        }
    }

    private boolean hasRealConflict(Comparison comparison) {
        for (Conflict conflict : comparison.getConflicts()) {
            if (conflict.getKind() != ConflictKind.REAL) continue;
            return true;
        }
        return false;
    }

    public ISchedulingRule getMergeRule(IMergeContext context) {
        ResourceMapping[] emfMappings = this.getEMFMappings(context);
        LinkedHashSet<IProject> impactedProjects = new LinkedHashSet<IProject>();
        ResourceMapping[] resourceMappingArray = emfMappings;
        int n = emfMappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            impactedProjects.addAll(Arrays.asList(mapping.getProjects()));
            ++n2;
        }
        return MultiRule.combine((ISchedulingRule[])impactedProjects.toArray(new ISchedulingRule[impactedProjects.size()]));
    }

    private ResourceMapping[] getEMFMappings(IMergeContext context) {
        return context.getScope().getMappings("org.eclipse.emf.compare.model.provider");
    }

    public IStatus validateMerge(IMergeContext mergeContext, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    protected static class ResourceAdditionAndDeletionTracker
    extends AdapterImpl {
        private final Set<String> urisOfAddedResources = new HashSet<String>();
        private final Set<String> urisOfDeletedResources = new HashSet<String>();
        private final Set<IFile> deletedIFiles = new HashSet<IFile>();

        protected ResourceAdditionAndDeletionTracker() {
        }

        public void notifyChanged(Notification msg) {
            if (!this.isAdditionOrDeletionOfResourceNotification(msg)) {
                return;
            }
            Resource newResource = (Resource)msg.getNewValue();
            URI uri = newResource.getURI();
            if (uri.isPlatformResource()) {
                String path = uri.toPlatformString(true);
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
                if (msg.getEventType() == 3) {
                    this.trackResourceAddition(file);
                } else if (msg.getEventType() == 4) {
                    this.trackResourceDeletion(file);
                }
            }
        }

        private boolean isAdditionOrDeletionOfResourceNotification(Notification msg) {
            return (msg.getEventType() == 3 || msg.getEventType() == 4) && msg.getNewValue() instanceof Resource;
        }

        private void trackResourceAddition(IFile file) {
            this.urisOfAddedResources.add(this.getStringRepresentation(file.getFullPath()));
        }

        private void trackResourceDeletion(IFile file) {
            this.deletedIFiles.add(file);
            this.urisOfDeletedResources.add(this.getStringRepresentation(file.getFullPath()));
        }

        private String getStringRepresentation(IPath path) {
            return path.toPortableString();
        }

        public boolean containsAddedResource(IPath path) {
            return this.urisOfAddedResources.contains(this.getStringRepresentation(path));
        }

        public boolean containsRemovedResource(IPath path) {
            return this.urisOfDeletedResources.contains(this.getStringRepresentation(path));
        }

        public Set<IFile> getDeletedIFiles() {
            return Collections.unmodifiableSet(this.deletedIFiles);
        }
    }
}

