/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.comparesource;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.compare.ide.ui.source.IEMFComparisonSource;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusFileEMFCompareSourceAdapter
implements IEMFComparisonSource {
    private final IPapyrusFile papyrusFile;

    public PapyrusFileEMFCompareSourceAdapter(IPapyrusFile papyrusFile) {
        Assert.isNotNull((Object)papyrusFile);
        this.papyrusFile = papyrusFile;
    }

    public String getName() {
        return this.papyrusFile.getName();
    }

    public StorageTraversal getStorageTraversal() {
        IResource[] resources = this.papyrusFile.getAssociatedResources();
        Set<IStorage> storages = this.getStorages(resources);
        return new StorageTraversal(storages);
    }

    private Set<IStorage> getStorages(IResource[] resources) {
        LinkedHashSet<IStorage> storages = new LinkedHashSet<IStorage>();
        if (resources == null) {
            return storages;
        }
        IAdapterManager adapterManager = Platform.getAdapterManager();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            IStorage storage = (IStorage)adapterManager.getAdapter((Object)resource, IStorage.class);
            if (storage != null) {
                storages.add(storage);
            }
            ++n2;
        }
        return storages;
    }
}

