/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DiagnosticSupport;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResolutionUtil;
import org.eclipse.emf.compare.ide.ui.internal.util.ThreadSafeProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MonitorCallback
implements FutureCallback<Object> {
    private final ThreadSafeProgressMonitor monitor;
    private final DiagnosticSupport diagnostic;

    MonitorCallback(DiagnosticSupport diagnostic, ThreadSafeProgressMonitor monitor) {
        this.diagnostic = (DiagnosticSupport)Preconditions.checkNotNull((Object)diagnostic);
        this.monitor = (ThreadSafeProgressMonitor)((Object)Preconditions.checkNotNull((Object)((Object)monitor)));
    }

    public void onSuccess(Object o) {
        if (!ResolutionUtil.isInterruptedOrCanceled((IProgressMonitor)this.monitor)) {
            this.monitor.worked(1);
        }
    }

    public void onFailure(Throwable t) {
        if (!ResolutionUtil.isInterruptedOrCanceled((IProgressMonitor)this.monitor)) {
            this.monitor.worked(1);
            this.diagnostic.merge(BasicDiagnostic.toDiagnostic((Throwable)t));
        }
    }
}

