/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.internal.utils.NoNotificationParserPool;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SynchronizedResourceSet
extends ResourceSetImpl {
    private final ConcurrentHashMap<URI, Resource> uriCache = new ConcurrentHashMap();

    public SynchronizedResourceSet() {
        this.resources = new SynchronizedResourcesEList();
        this.loadOptions = super.getLoadOptions();
        this.loadOptions.put("USE_PARSER_POOL", new NoNotificationParserPool());
        this.loadOptions.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
        this.loadOptions.put("DISABLE_NOTIFY", Boolean.TRUE);
        HashMap parserProperties = Maps.newHashMap();
        parserProperties.put("http://apache.org/xml/properties/input-buffer-size", 16384);
        this.loadOptions.put("PARSER_PROPERTIES", parserProperties);
        this.loadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
        this.loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
    }

    public Resource loadResource(URI uri) {
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        Resource result = null;
        result = this.uriCache.get(normalizedURI);
        if (result == null && (result = this.delegatedGetResource(uri, true)) != null) {
            result = this.uriCache.putIfAbsent(uri, result);
        }
        if (result == null) {
            result = this.demandCreateResource(uri);
            if (result == null) {
                throw new RuntimeException("Cannot create a resource for '" + uri + "'; a registered resource factory is needed");
            }
            this.demandLoadHelper(result);
        }
        return result;
    }

    protected void handleDemandLoadException(Resource resource, IOException exception) throws RuntimeException {
        try {
            super.handleDemandLoadException(resource, exception);
        }
        catch (RuntimeException runtimeException) {}
    }

    public Set<URI> discoverCrossReferences(Resource resource, IProgressMonitor monitor) {
        resource.eSetDeliver(false);
        List roots = ((InternalEList)resource.getContents()).basicList();
        Iterator resourceContent = roots.iterator();
        LinkedHashSet<URI> crossReferencedResources = new LinkedHashSet<URI>();
        block0: while (resourceContent.hasNext()) {
            if (this.isInterruptedOrCanceled(monitor)) break;
            EObject eObject = (EObject)resourceContent.next();
            crossReferencedResources.addAll(this.resolveCrossReferences(eObject));
            TreeIterator<EObject> objectChildren = this.basicEAllContents(eObject);
            while (objectChildren.hasNext()) {
                if (this.isInterruptedOrCanceled(monitor)) continue block0;
                EObject child = (EObject)objectChildren.next();
                if (child.eIsProxy()) {
                    URI proxyURI = ((InternalEObject)child).eProxyURI().trimFragment();
                    crossReferencedResources.add(proxyURI);
                    continue;
                }
                crossReferencedResources.addAll(this.resolveCrossReferences(child));
            }
        }
        if (this.isInterruptedOrCanceled(monitor)) {
            crossReferencedResources.clear();
        }
        return crossReferencedResources;
    }

    private boolean isInterruptedOrCanceled(IProgressMonitor monitor) {
        return monitor.isCanceled() || Thread.currentThread().isInterrupted();
    }

    public void unload(Resource resource, IProgressMonitor monitor) {
        URI uri = resource.getURI();
        this.uriCache.remove(uri);
        this.getResources().remove((Object)resource);
        if (resource.getClass().getSimpleName().startsWith("UMLResource")) {
            resource.unload();
        }
    }

    private TreeIterator<EObject> basicEAllContents(EObject eObject) {
        return new AbstractTreeIterator<EObject>((Object)eObject, false){
            private static final long serialVersionUID = -617740251257708686L;

            public Iterator<EObject> getChildren(Object obj) {
                return ((InternalEList)((EObject)obj).eContents()).basicIterator();
            }
        };
    }

    private Set<URI> resolveCrossReferences(EObject eObject) {
        LinkedHashSet<URI> crossReferencedResources = new LinkedHashSet<URI>();
        Iterator objectCrossRefs = ((InternalEList)eObject.eCrossReferences()).basicIterator();
        while (objectCrossRefs.hasNext()) {
            URI proxyURI;
            EObject crossRef = (EObject)objectCrossRefs.next();
            if (!crossRef.eIsProxy() || !(proxyURI = ((InternalEObject)crossRef).eProxyURI().trimFragment()).isPlatformResource()) continue;
            crossReferencedResources.add(proxyURI);
        }
        return crossReferencedResources;
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        EPackage ePackage;
        Resource demanded = this.uriCache.get(uri);
        if (demanded == null && (ePackage = this.getPackageRegistry().getEPackage(uri.toString())) != null) {
            demanded = ePackage.eResource();
            demanded = this.uriCache.putIfAbsent(uri, demanded);
        }
        return demanded;
    }

    public synchronized Resource createResource(URI uri) {
        Resource created = super.createResource(uri);
        return created;
    }

    public synchronized Resource createResource(URI uri, String contentType) {
        Resource created = super.createResource(uri, contentType);
        return created;
    }

    public EList<Resource> getResources() {
        return this.resources;
    }

    public Map<Object, Object> getLoadOptions() {
        return this.loadOptions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SynchronizedResourcesEList<E extends Resource>
    extends ResourceSetImpl.ResourcesEList<E> {
        private static final long serialVersionUID = 7371376112881960414L;
        private final Object lock;

        private SynchronizedResourcesEList() {
            super((ResourceSetImpl)SynchronizedResourceSet.this);
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection<?> c) {
            Object object = this.lock;
            synchronized (object) {
                return super.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E set(int index, E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return (E)((Resource)super.set(index, object));
            }
        }

        protected void dispatchNotification(Notification notification) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.add(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                super.add(index, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection<? extends E> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection<? extends E> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAll(index, collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection<?> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void move(int index, E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                super.move(index, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.lock;
            synchronized (object) {
                return super.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.lock;
            synchronized (object) {
                return super.toString();
            }
        }

        public Iterator<E> iterator() {
            return new SynchronizedEIterator();
        }

        public ListIterator<E> listIterator() {
            return new SynchronizedEListIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator<E> listIterator(int index) {
            Object object = this.lock;
            synchronized (object) {
                int curSize = this.size();
                if (index < 0 || index > curSize) {
                    throw new BasicEList.BasicIndexOutOfBoundsException(index, curSize);
                }
                return new SynchronizedEListIterator(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.indexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.lastIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Object object = this.lock;
            synchronized (object) {
                return super.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T[] toArray(T[] array) {
            Object object = this.lock;
            synchronized (object) {
                return super.toArray((Object[])array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setData(int size, Object[] data) {
            Object object = this.lock;
            synchronized (object) {
                super.setData(size, data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E get(int index) {
            Object object = this.lock;
            synchronized (object) {
                return (E)((Resource)super.get(index));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E basicGet(int index) {
            Object object = this.lock;
            synchronized (object) {
                return (E)((Resource)super.basicGet(index));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shrink() {
            Object object = this.lock;
            synchronized (object) {
                super.shrink();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void grow(int minimumCapacity) {
            Object object = this.lock;
            synchronized (object) {
                super.grow(minimumCapacity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object clone() {
            Object object = this.lock;
            synchronized (object) {
                return super.clone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUnique(E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                super.addUnique(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUnique(int index, E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                super.addUnique(index, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAllUnique(Collection<? extends E> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAllUnique(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAllUnique(int index, Collection<? extends E> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAllUnique(index, collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAllUnique(Object[] objects, int start, int end) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAllUnique(objects, start, end);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAllUnique(int index, Object[] objects, int start, int end) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAllUnique(index, objects, start, end);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NotificationChain basicAdd(E object, NotificationChain notifications) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicAdd(object, notifications);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E remove(int index) {
            Object object = this.lock;
            synchronized (object) {
                return (E)((Resource)super.remove(index));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection<?> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NotificationChain basicRemove(Object object, NotificationChain notifications) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicRemove(object, notifications);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                super.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E setUnique(int index, E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return (E)((Resource)super.setUnique(index, object));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NotificationChain basicSet(int index, E object, NotificationChain notifications) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicSet(index, object, notifications);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E move(int targetIndex, int sourceIndex) {
            Object object = this.lock;
            synchronized (object) {
                return (E)((Resource)super.move(targetIndex, sourceIndex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<E> basicList() {
            Object object = this.lock;
            synchronized (object) {
                return super.basicList();
            }
        }

        public Iterator<E> basicIterator() {
            return new SynchronizedNonResolvingEIterator();
        }

        public ListIterator<E> basicListIterator() {
            return new SynchronizedNonResolvingEListIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator<E> basicListIterator(int index) {
            Object object = this.lock;
            synchronized (object) {
                int curSize = this.size();
                if (index < 0 || index > curSize) {
                    throw new BasicEList.BasicIndexOutOfBoundsException(index, curSize);
                }
                return new SynchronizedNonResolvingEListIterator(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean basicContains(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicContains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean basicContainsAll(Collection<?> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.basicContainsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int basicIndexOf(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int basicLastIndexOf(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicLastIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] basicToArray() {
            Object object = this.lock;
            synchronized (object) {
                return super.basicToArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T[] basicToArray(T[] array) {
            Object object = this.lock;
            synchronized (object) {
                return super.basicToArray((Object[])array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] data() {
            Object object = this.lock;
            synchronized (object) {
                return super.data();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getFeature() {
            Object object = this.lock;
            synchronized (object) {
                return super.getFeature();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getFeatureID() {
            Object object = this.lock;
            synchronized (object) {
                return super.getFeatureID();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNotifier() {
            Object object = this.lock;
            synchronized (object) {
                return super.getNotifier();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.lock;
            synchronized (object) {
                return super.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.lock;
            synchronized (object) {
                return super.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<E> subList(int fromIndex, int toIndex) {
            Object object = this.lock;
            synchronized (object) {
                return super.subList(fromIndex, toIndex);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SynchronizedEIterator
        extends AbstractEList.EIterator<E> {
            private SynchronizedEIterator() {
                super((AbstractEList)SynchronizedResourcesEList.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E next() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return (Resource)super.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    super.remove();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean equals(Object obj) {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.equals(obj);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int hashCode() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hashCode();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String toString() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.toString();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SynchronizedEListIterator
        extends AbstractEList.EListIterator<E> {
            public SynchronizedEListIterator() {
                super((AbstractEList)SynchronizedResourcesEList.this);
            }

            public SynchronizedEListIterator(int index) {
                super((AbstractEList)SynchronizedResourcesEList.this, index);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void add(E object) {
                Object object2 = SynchronizedResourcesEList.this.lock;
                synchronized (object2) {
                    super.add(object);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasPrevious() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasPrevious();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E next() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return (Resource)super.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E previous() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return (Resource)super.previous();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int previousIndex() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.previousIndex();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    super.remove();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(E object) {
                Object object2 = SynchronizedResourcesEList.this.lock;
                synchronized (object2) {
                    super.set(object);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean equals(Object obj) {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.equals(obj);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int hashCode() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hashCode();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String toString() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.toString();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int nextIndex() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.nextIndex();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SynchronizedNonResolvingEIterator
        extends AbstractEList.NonResolvingEIterator<E> {
            private SynchronizedNonResolvingEIterator() {
                super((AbstractEList)SynchronizedResourcesEList.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E next() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return (Resource)super.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    super.remove();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean equals(Object obj) {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.equals(obj);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int hashCode() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hashCode();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String toString() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.toString();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SynchronizedNonResolvingEListIterator
        extends AbstractEList.NonResolvingEListIterator<E> {
            public SynchronizedNonResolvingEListIterator() {
                super((AbstractEList)SynchronizedResourcesEList.this);
            }

            public SynchronizedNonResolvingEListIterator(int index) {
                super((AbstractEList)SynchronizedResourcesEList.this, index);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void add(E object) {
                Object object2 = SynchronizedResourcesEList.this.lock;
                synchronized (object2) {
                    super.add(object);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasPrevious() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasPrevious();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E next() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return (Resource)super.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E previous() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return (Resource)super.previous();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int previousIndex() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.previousIndex();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    super.remove();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(E object) {
                Object object2 = SynchronizedResourcesEList.this.lock;
                synchronized (object2) {
                    super.set(object);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean equals(Object obj) {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.equals(obj);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int hashCode() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hashCode();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String toString() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.toString();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int nextIndex() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.nextIndex();
                }
            }
        }
    }
}

