/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.compare.ide.internal.utils.SyncResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.logical.RevisionedURIConverter;
import org.eclipse.emf.compare.ide.ui.logical.AbstractModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.ide.utils.StorageURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalModelResolver
extends AbstractModelResolver {
    @Override
    public SynchronizationModel resolveLocalModels(IResource left, IResource right, IResource origin, IProgressMonitor monitor) {
        StorageTraversal originTraversal;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        StorageTraversal leftTraversal = this.resolveLocalModel(left, (IProgressMonitor)subMonitor.newChild(1));
        StorageTraversal rightTraversal = this.resolveLocalModel(right, (IProgressMonitor)subMonitor.newChild(1));
        if (origin != null) {
            originTraversal = this.resolveLocalModel(origin, (IProgressMonitor)subMonitor.newChild(1));
        } else {
            subMonitor.setWorkRemaining(2);
            originTraversal = new StorageTraversal((Set)Sets.newLinkedHashSet());
        }
        return new SynchronizationModel(leftTraversal, rightTraversal, originTraversal);
    }

    @Override
    public StorageTraversal resolveLocalModel(IResource start, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!(start instanceof IFile)) {
            subMonitor.setWorkRemaining(0);
            return new StorageTraversal((Set)Sets.newLinkedHashSet());
        }
        SyncResourceSet resourceSet = new SyncResourceSet();
        StorageURIConverter converter = new StorageURIConverter(resourceSet.getURIConverter());
        resourceSet.setURIConverter((URIConverter)converter);
        if (resourceSet.resolveAll((IStorage)((IFile)start), (IProgressMonitor)subMonitor.newChild(95))) {
            LinkedHashSet storages = Sets.newLinkedHashSet((Iterable)Sets.union(Collections.singleton((IFile)start), (Set)converter.getLoadedRevisions()));
            subMonitor.worked(5);
            return new StorageTraversal((Set)storages);
        }
        subMonitor.setWorkRemaining(5);
        subMonitor.worked(5);
        return new StorageTraversal(Collections.singleton((IFile)start));
    }

    @Override
    public SynchronizationModel resolveModels(IStorageProviderAccessor storageAccessor, IStorage left, IStorage right, IStorage origin, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)EMFCompareIDEUIMessages.getString("EMFSynchronizationModel.resolving"), (int)3);
        StorageTraversal leftTraversal = this.resolveTraversal(storageAccessor, left, IStorageProviderAccessor.DiffSide.SOURCE, (IProgressMonitor)progress.newChild(1));
        StorageTraversal rightTraversal = this.resolveTraversal(storageAccessor, right, IStorageProviderAccessor.DiffSide.REMOTE, (IProgressMonitor)progress.newChild(1));
        StorageTraversal originTraversal = null;
        if (origin != null) {
            originTraversal = this.resolveTraversal(storageAccessor, origin, IStorageProviderAccessor.DiffSide.ORIGIN, (IProgressMonitor)progress.newChild(1));
        }
        progress.setWorkRemaining(0);
        SynchronizationModel syncModel = new SynchronizationModel(leftTraversal, rightTraversal, originTraversal);
        return syncModel;
    }

    @Override
    public boolean canResolve(IStorage sourceStorage) {
        return true;
    }

    protected boolean contains(Set<IStorage> storages, IStorage storage) {
        IPath candidateFullPath = storage.getFullPath();
        for (IStorage existing : storages) {
            if (!candidateFullPath.equals((Object)existing.getFullPath())) continue;
            return true;
        }
        return false;
    }

    private StorageTraversal resolveTraversal(IStorageProviderAccessor storageAccessor, IStorage start, IStorageProviderAccessor.DiffSide side, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StorageTraversal traversal = new StorageTraversal((Set)Sets.newLinkedHashSet());
        if (start == null) {
            return traversal;
        }
        SyncResourceSet resourceSet = new SyncResourceSet();
        RevisionedURIConverter converter = new RevisionedURIConverter(resourceSet.getURIConverter(), storageAccessor, side);
        resourceSet.setURIConverter((URIConverter)converter);
        if (resourceSet.resolveAll(start, (IProgressMonitor)progress.newChild(95))) {
            LinkedHashSet storages = Sets.newLinkedHashSet();
            for (IStorage loaded : converter.getLoadedRevisions()) {
                if (this.contains(storages, loaded)) continue;
                storages.add(loaded);
            }
            traversal = new StorageTraversal((Set)storages);
        } else {
            progress.setWorkRemaining(5);
        }
        progress.worked(5);
        return traversal;
    }
}

