/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.ResourceAttachmentChangeItemProvider;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;

public class ResourceAttachmentChangeItemProviderSpec
extends ResourceAttachmentChangeItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    private final OverlayImageProvider overlayProvider = new OverlayImageProvider(this.getResourceLocator());

    public ResourceAttachmentChangeItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object getImage(Object object) {
        Match match = ((ResourceAttachmentChange)object).getMatch();
        Object ret = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), match.getLeft());
        if (ret == null) {
            ret = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), match.getRight());
        }
        if (ret == null) {
            ret = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), match.getOrigin());
        }
        if (ret == null) {
            ret = super.getImage(object);
        }
        Object matchImage = this.overlayProvider.getComposedImage((Diff)((ResourceAttachmentChange)object), ret);
        ret = this.overlayImage(object, matchImage);
        return ret;
    }

    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        ResourceAttachmentChange resourceAttachmentChange = (ResourceAttachmentChange)object;
        Match match = resourceAttachmentChange.getMatch();
        String value = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getLeft());
        if (value == null) {
            value = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getRight());
        }
        if (value == null) {
            value = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getOrigin());
        }
        if (value == null) {
            value = super.getText(object);
        }
        ComposedStyledString ret = new ComposedStyledString(value);
        ret.append(" [", IStyledString.Style.DECORATIONS_STYLER);
        switch (resourceAttachmentChange.getKind()) {
            case ADD: {
                ret.append("controlled in ", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case DELETE: {
                ret.append("uncontrolled from ", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
        }
        ret.append(resourceAttachmentChange.getResourceURI(), IStyledString.Style.DECORATIONS_STYLER);
        return ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
    }

    public String getDescription(Object object) {
        ResourceAttachmentChange rac = (ResourceAttachmentChange)object;
        Match match = rac.getMatch();
        String ret = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getLeft());
        if (ret == null) {
            ret = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getRight());
        }
        if (ret == null) {
            ret = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getOrigin());
        }
        if (ret == null) {
            ret = super.getText(object);
        }
        String remotely = "";
        if (rac.getSource() == DifferenceSource.RIGHT) {
            remotely = "remotely ";
        }
        DifferenceKind labelValue = rac.getKind();
        switch (labelValue) {
            case ADD: {
                ret = String.valueOf(ret) + " has been " + remotely + "added to resource contents";
                break;
            }
            case DELETE: {
                ret = String.valueOf(ret) + " has been " + remotely + "deleted from resource contents";
                break;
            }
            case MOVE: {
                ret = String.valueOf(ret) + " has been " + remotely + "moved in resource contents";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + rac.getKind());
            }
        }
        return ret;
    }
}

