/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.cst.ClassifierDefCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.QvtElementProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.quickoutline.QvtOutlineInformationControl;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.texteditor.ITextEditor;

public class OutlineContentProvider
implements ITreeContentProvider {
    private final QvtOutlineInformationControl myQvtOutlineInformationControl;
    private boolean isShowImportedInfo;
    private QvtCompletionData myQvtCompletionData;

    public OutlineContentProvider(QvtOutlineInformationControl qvtOutlineInformationControl, boolean showInheritedMembers) {
        this.myQvtOutlineInformationControl = qvtOutlineInformationControl;
        this.isShowImportedInfo = showInheritedMembers;
    }

    public boolean isShowingImportedMembers() {
        return this.isShowImportedInfo;
    }

    public void toggleShowInheritedMembers() {
        TreeViewer treeViewer = this.myQvtOutlineInformationControl.getTreeViewer();
        Tree tree = treeViewer.getTree();
        tree.setRedraw(false);
        this.isShowImportedInfo = !this.isShowImportedInfo;
        treeViewer.refresh();
        treeViewer.expandToLevel(2);
        Object selectedElement = this.myQvtOutlineInformationControl.getSelectedElement();
        if (selectedElement != null) {
            treeViewer.reveal(selectedElement);
        }
        tree.setRedraw(true);
    }

    public Object[] getChildren(Object element) {
        MappingModuleCS mappingModuleCS;
        ArrayList<MappingModuleCS> children = new ArrayList<MappingModuleCS>();
        if (QvtElementProvider.FAKE_ROOT == element) {
            if (this.isShowImportedInfo) {
                children.addAll(Arrays.asList(this.myQvtCompletionData.getAllMappingModulesCS()));
            } else {
                MappingModuleCS currentMappingModuleCS = this.myQvtCompletionData.getCurrentMappingModuleCS();
                if (currentMappingModuleCS != null) {
                    children.add(currentMappingModuleCS);
                }
            }
        } else if (element instanceof MappingModuleCS) {
            mappingModuleCS = (MappingModuleCS)element;
            children.addAll((Collection<MappingModuleCS>)mappingModuleCS.getProperties());
            children.addAll((Collection<MappingModuleCS>)mappingModuleCS.getMethods());
            children.addAll((Collection<MappingModuleCS>)mappingModuleCS.getClassifierDefCS());
        } else if (element instanceof ClassifierDefCS) {
            mappingModuleCS = (ClassifierDefCS)element;
            children.addAll((Collection<MappingModuleCS>)mappingModuleCS.getProperties());
        }
        if (this.myQvtOutlineInformationControl.getStringMatcher() != null) {
            ArrayList filteredChildren = new ArrayList();
            for (Object e : children) {
                if (!this.myQvtOutlineInformationControl.isStringMatcherOk(e) && !this.hasChildren(e)) continue;
                filteredChildren.add(e);
            }
            children = filteredChildren;
        }
        return children.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        QvtEditor editor = this.myQvtOutlineInformationControl.getEditor();
        UnitProxy unitProxy = (UnitProxy)editor.getAdapter(UnitProxy.class);
        if (unitProxy != null) {
            this.myQvtCompletionData = new QvtCompletionData((ITextEditor)editor, (ITextViewer)this.myQvtOutlineInformationControl.getSourceViewer(), unitProxy, 0);
        }
    }

    public void dispose() {
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length != 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }
}

