/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.text;

import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.qvt.declarative.editor.ui.IPageManager;
import org.eclipse.qvt.declarative.editor.ui.common.NullProvider;
import org.eclipse.qvt.declarative.editor.ui.paged.PagedEditor;
import org.eclipse.qvt.declarative.editor.ui.text.ITextEditorWithUndoContext;
import org.eclipse.qvt.declarative.editor.ui.text.LazyFileEditorInput;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class LazyTextPageEditor
extends TextEditor
implements ITextEditorWithUndoContext {
    protected final IPageManager pageManager;
    private IDocumentProvider activeDocumentProvider;

    public LazyTextPageEditor(IPageManager pageManager, IDocumentProvider activeDocumentProvider) {
        this.pageManager = pageManager;
        this.activeDocumentProvider = activeDocumentProvider;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IDocumentUndoManager documentUndoManager;
        IDocument document = this.activeDocumentProvider.getDocument((Object)this.getEditorInput());
        if (document != null && (documentUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document)) != null) {
            documentUndoManager.commit();
        }
        super.doSave(progressMonitor);
    }

    protected void doSetInput(IEditorInput editorInput) throws CoreException {
        if (editorInput instanceof LazyFileEditorInput && !((LazyFileEditorInput)editorInput).hasContents()) {
            this.setDocumentProvider(NullProvider.INSTANCE);
        } else {
            this.setDocumentProvider(this.activeDocumentProvider);
        }
        super.doSetInput(editorInput);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        IAction undoAction = this.getAction(ITextEditorActionConstants.UNDO);
        IAction redoAction = this.getAction(ITextEditorActionConstants.REDO);
        if (undoAction != null && undoAction.getId() == null) {
            undoAction.setId(ITextEditorActionConstants.UNDO);
        }
        if (redoAction != null && redoAction.getId() == null) {
            redoAction.setId(ITextEditorActionConstants.REDO);
        }
        super.editorContextMenuAboutToShow(menu);
        if (!this.isEditable()) {
            this.addAction(menu, "group.undo", ITextEditorActionConstants.UNDO);
        }
        if (undoAction != null && redoAction != null) {
            IMenuManager subMenu = menu.findMenuUsingPath("group.undo");
            if (subMenu != null) {
                subMenu.insertAfter(ITextEditorActionConstants.UNDO, redoAction);
            } else {
                menu.insertAfter(ITextEditorActionConstants.UNDO, redoAction);
            }
        }
    }

    public IDocumentProvider getActiveDocumentProvider() {
        return this.activeDocumentProvider;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPageManager.class)) {
            return this.pageManager;
        }
        if (key.equals(IUndoContext.class)) {
            return this.getUndoContext();
        }
        return super.getAdapter(key);
    }

    public PagedEditor getPagedEditor() {
        return this.pageManager.getPagedEditor();
    }

    public IUndoContext getUndoContext() {
        IUndoManager undoManager;
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension6 && (undoManager = ((ITextViewerExtension6)sourceViewer).getUndoManager()) instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    public boolean isDirty() {
        return this.getPagedEditor().isDirtyPage();
    }

    public void setAction(String actionID, IAction action) {
        if (!actionID.equals(ITextEditorActionConstants.SAVE)) {
            super.setAction(actionID, action);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + String.valueOf(((IFileEditorInput)this.getEditorInput()).getFile());
    }
}

