/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTRelation.operations;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.TransformationOperations;
import org.eclipse.qvt.declarative.ecore.QVTRelation.Relation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationDomain;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationImplementation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.AbstractQVTRelationOperations;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.QVTRelationMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationImplementationOperations
extends AbstractQVTRelationOperations {
    public static RelationImplementationOperations INSTANCE = new RelationImplementationOperations();

    public boolean checkInDirectionOfIsDefinedByTransformation(RelationImplementation relationImplementation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Transformation transformation = relationImplementation.getRelation().getTransformation();
        TypedModel typedModel = relationImplementation.getInDirectionOf();
        if (typedModel == null) {
            return true;
        }
        if (TransformationOperations.INSTANCE.definesModel(transformation, typedModel)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)typedModel, context), this.getObjectLabel((EObject)relationImplementation, context), this.getObjectLabel((EObject)transformation, context)};
        this.appendError(diagnostics, relationImplementation, QVTRelationMessages._UI_RelationImplementation_DirectionIsNotDefinedByTransformation, messageSubstitutions);
        return false;
    }

    public boolean checkEveryParameterTypeMatchesDomainRootVariableType(RelationImplementation relationImplementation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int parameterCount;
        EOperation operation = relationImplementation.getImpl();
        if (operation == null) {
            return true;
        }
        Relation relation = relationImplementation.getRelation();
        if (relation == null) {
            return true;
        }
        EList domains = relation.getDomain();
        EList parameters = operation.getEParameters();
        int domainCount = domains.size();
        if (domainCount != (parameterCount = parameters.size())) {
            Object[] messageSubstitutions = new Object[]{parameterCount, this.getObjectLabel((EObject)operation, context), domainCount};
            this.appendError(diagnostics, relationImplementation, QVTRelationMessages._UI_RelationImplementation_ParameterNumberDoesNotMatch, messageSubstitutions);
            return false;
        }
        boolean allOk = true;
        int i = 0;
        while (i < parameterCount) {
            TypedModel typedModel;
            EClassifier domainType;
            RelationDomain domain;
            Variable rootVariable;
            EClassifier parameterType = ((EParameter)parameters.get(i)).getEType();
            if (parameterType != null && (rootVariable = (domain = (RelationDomain)domains.get(i)).getRootVariable()) != null && (domainType = rootVariable.getEType()) != null && (typedModel = domain.getTypedModel()) != null) {
                Object[] messageSubstitutions;
                if (typedModel == relationImplementation.getInDirectionOf()) {
                    if (!this.assignableFrom(domainType, parameterType)) {
                        messageSubstitutions = new Object[]{this.getObjectLabel((EObject)domainType, context), this.getObjectLabel((EObject)parameterType, context)};
                        this.appendError(diagnostics, relationImplementation, QVTRelationMessages._UI_RelationImplementation_OutputParameterTypeDoesNotMatch, messageSubstitutions);
                        allOk = false;
                    }
                } else if (!this.assignableFrom(parameterType, domainType)) {
                    messageSubstitutions = new Object[]{this.getObjectLabel((EObject)parameterType, context), this.getObjectLabel((EObject)domainType, context)};
                    this.appendError(diagnostics, relationImplementation, QVTRelationMessages._UI_RelationImplementation_InputParameterTypeDoesNotMatch, messageSubstitutions);
                    allOk = false;
                }
            }
            ++i;
        }
        return allOk;
    }
}

