/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTBase.operations;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.qvt.declarative.ecore.QVTBase.Domain;
import org.eclipse.qvt.declarative.ecore.QVTBase.Rule;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.AbstractQVTBaseOperations;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.QVTBaseMessages;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.TransformationOperations;
import org.eclipse.qvt.declarative.ecore.operations.AbstractValidatorOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleOperations
extends AbstractQVTBaseOperations {
    public static RuleOperations INSTANCE = new RuleOperations();

    public boolean checkOverridesDefinedByTransformation(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Rule overrides = rule.getOverrides();
        if (overrides == null) {
            return true;
        }
        Transformation transformation = rule.getTransformation();
        if (!TransformationOperations.INSTANCE.declaresRule(transformation, overrides)) {
            Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)rule, context), this.getObjectLabel((EObject)transformation, context)};
            this.appendError(diagnostics, rule, QVTBaseMessages._UI_Rule_OverridesIsNotDefinedByTransformation, messageSubstitutions);
            return false;
        }
        return true;
    }

    public boolean checkDomainNamesAreUnique(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.checkUniqueNames(rule, (List)rule.getDomain(), QVTBaseMessages._UI_Rule_DomainNameIsNotUnique, diagnostics, context);
    }

    public boolean checkTypedModelsAreUnique(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        AbstractValidatorOperations.UniquenessChecker<TypedModel, Domain> checker = new AbstractValidatorOperations.UniquenessChecker<TypedModel, Domain>((AbstractValidatorOperations)this){

            protected TypedModel getKey(Domain value) {
                return value.getTypedModel();
            }
        };
        return checker.check(rule.getDomain(), QVTBaseMessages._UI_Rule_DomainTypedModelIsNotUnique, (EObject)rule, diagnostics, context);
    }
}

