/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtrelation.tests;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.m2m.atl.dsls.core.EMFTCSInjector;
import org.eclipse.m2m.atl.emftvm.compiler.AtlResourceFactoryImpl;
import org.eclipse.m2m.atl.engine.parser.AtlParser;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ToStringVisitor;
import org.eclipse.ocl.xtext.base.services.BaseLinkingService;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.QVTrCompilerChain;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ConnectivityChecker;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.EarlyMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.LateConsumerMerger;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.Execution2GraphVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtschedule.impl.MicroMappingRegionImpl;
import org.eclipse.qvtd.pivot.qvtschedule.impl.RuleRegionImpl;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.eclipse.qvtd.xtext.qvtbase.tests.AbstractTestQVT;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.eclipse.qvtd.xtext.qvtrelation.tests.Families2PersonsNormalizer;
import org.eclipse.qvtd.xtext.qvtrelation.tests.FlatStateMachineNormalizer;
import org.eclipse.qvtd.xtext.qvtrelation.tests.Forward2ReverseNormalizer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class QVTrCompilerTests
extends LoadTestCase {
    protected @NonNull MyQVT createQVT(@NonNull String resultPrefix, @NonNull URI txURI) throws Exception {
        ProjectManager testProjectManager = this.getTestProjectManager();
        URI prefixURI = this.getTestURI(resultPrefix);
        URI srcFileURI = this.getTestFileURI("test-src/");
        URI binFileURI = this.getTestFileURI("test-bin/");
        return new MyQVT(testProjectManager, this.getTestProject().getName(), this.getTestBundleURI(), txURI, prefixURI, srcFileURI, binFileURI);
    }

    @Before
    public void setUp() throws Exception {
        BaseLinkingService.DEBUG_RETRY.setState(true);
        QVTm2QVTs.DEBUG_GRAPHS.setState(true);
        super.setUp();
        OCLstdlib.install();
        XtextCompilerUtil.doQVTrelationSetup();
        XtextCompilerUtil.doQVTcoreSetup();
        XtextCompilerUtil.doQVTimperativeSetup();
        ConnectivityChecker.CONNECTIVITY.setState(true);
    }

    @After
    public void tearDown() throws Exception {
        ConnectivityChecker.CONNECTIVITY.setState(false);
        super.tearDown();
    }

    @Test
    public void testQVTrCompiler_ATL2QVTr_CG() throws Exception {
        Class txClass3;
        ConnectivityChecker.CONNECTIVITY_CLASSDATUMS.setState(true);
        ConnectivityChecker.CONNECTIVITY_CONNECTIONS.setState(true);
        ConnectivityChecker.CONNECTIVITY_EDGES.setState(true);
        ConnectivityChecker.CONNECTIVITY_NODES.setState(true);
        Class txClass1 = null;
        URI txURI1 = URI.createPlatformResourceURI((String)"/org.eclipse.qvtd.atl/model/ATL2QVTr.qvtr", (boolean)true);
        MyQVT myQVT1 = this.createQVT("ATL2QVTr", txURI1);
        myQVT1.addUsedGenPackage("org.eclipse.m2m.atl.common/model/ATL.genmodel", "//ATL");
        myQVT1.addUsedGenPackage("org.eclipse.m2m.atl.common/model/ATL.genmodel", "//OCL");
        myQVT1.addUsedGenPackage("org.eclipse.m2m.atl.common/model/ATL.genmodel", "//PrimitiveTypes");
        myQVT1.addUsedGenPackage("org.eclipse.ocl.pivot/model/Pivot.genmodel", "//pivot");
        myQVT1.addUsedGenPackage("org.eclipse.qvtd.pivot.qvtbase/model/QVTbase.genmodel", "//qvtbase");
        myQVT1.addUsedGenPackage("org.eclipse.qvtd.pivot.qvtrelation/model/QVTrelation.genmodel", "//qvtrelation");
        myQVT1.addUsedGenPackage("org.eclipse.qvtd.pivot.qvttemplate/model/QVTtemplate.genmodel", "//qvttemplate");
        myQVT1.addClasspathProjectName("org.eclipse.m2m.atl.common");
        myQVT1.addClasspathProjectName("org.eclipse.qvtd.pivot.qvtbase");
        myQVT1.addClasspathProjectName("org.eclipse.qvtd.pivot.qvtrelation");
        myQVT1.addClasspathProjectName("org.eclipse.qvtd.pivot.qvttemplate");
        myQVT1.addClasspathProjectName("org.eclipse.qvtd.atl");
        try {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            assert (classLoader != null);
            ((PivotMetamodelManager)myQVT1.getMetamodelManager()).getImplementationManager().getClassLoaders().add(classLoader);
            txClass1 = myQVT1.buildTransformation("qvtr", false, new String[0]);
        }
        finally {
            myQVT1.dispose();
        }
        URI txURI2 = this.getTestURI("Families2Persons_CG.qvtras");
        MyQVT myQVT2 = this.createQVT("ATL2QVTr", txURI1);
        try {
            myQVT2.createGeneratedExecutor(txClass1);
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                EMFTCSInjector.class.getName();
                AtlParser.class.getName();
                myQVT2.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("atl", new AtlResourceFactoryImpl());
                myQVT2.loadInput("atl", this.getModelsURI("families2persons/Families2Persons.atl"));
            } else {
                myQVT2.loadInput("atl", this.getModelsURI("families2persons/Families2Persons.atl.xmi"));
            }
            myQVT2.executeTransformation();
            myQVT2.saveOutput("qvtr", txURI2, this.getModelsURI("families2persons/Families2Persons_expected.qvtras"), null);
        }
        finally {
            myQVT2.dispose();
        }
        MyQVT myQVT3 = this.createQVT("Families2Persons", txURI2);
        try {
            txClass3 = myQVT3.buildTransformation("Persons", false, new String[0]);
            myQVT3.assertRegionCount(RuleRegionImpl.class, 2);
            myQVT3.assertRegionCount(EarlyMerger.EarlyMergedMappingRegion.class, 0);
            myQVT3.assertRegionCount(LateConsumerMerger.LateMergedMappingRegion.class, 0);
            myQVT3.assertRegionCount(MicroMappingRegionImpl.class, 0);
        }
        finally {
            myQVT3.dispose();
        }
        MyQVT myQVT4 = this.createQVT("Families2Persons", txURI2);
        try {
            myQVT4.loadEPackage(txClass3, "Families.FamiliesPackage");
            myQVT4.loadEPackage(txClass3, "Persons.PersonsPackage");
            myQVT4.loadEPackage(txClass3, "trace_Families2Persons.trace_Families2PersonsPackage");
            myQVT4.createGeneratedExecutor(txClass3);
            myQVT4.loadInput("Families", this.getModelsURI("families2persons/samples/Families.xmi"));
            myQVT4.executeTransformation();
            myQVT4.saveOutput("Persons", this.getTestURI("Persons_CG.xmi"), this.getModelsURI("families2persons/samples/Persons_expected.xmi"), Families2PersonsNormalizer.INSTANCE);
        }
        finally {
            myQVT4.dispose();
        }
    }

    @Test
    public void testQVTrCompiler_Ecore2Pivot_CG() throws Exception {
        ConnectivityChecker.CONNECTIVITY_CLASSDATUMS.setState(true);
        ConnectivityChecker.CONNECTIVITY_CONNECTIONS.setState(true);
        ConnectivityChecker.CONNECTIVITY_EDGES.setState(true);
        ConnectivityChecker.CONNECTIVITY_NODES.setState(true);
        Class txClass1 = null;
        URI txURI1 = this.getModelsURI("ecore2pivot/Ecore2Pivot.qvtr");
        MyQVT myQVT1 = this.createQVT("Ecore2Pivot", txURI1);
        myQVT1.addUsedGenPackage("org.eclipse.emf.ecore/model/Ecore.genmodel", "//ecore");
        myQVT1.addUsedGenPackage("org.eclipse.ocl.pivot/model/Pivot.genmodel", "//pivot");
        try {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            assert (classLoader != null);
            ((PivotMetamodelManager)myQVT1.getMetamodelManager()).getImplementationManager().getClassLoaders().add(classLoader);
            txClass1 = myQVT1.buildTransformation("as", false, new String[0]);
        }
        finally {
            myQVT1.dispose();
        }
        URI asURI2 = this.getTestURI("Families.ecore.oclas");
        MyQVT myQVT2 = this.createQVT("Ecore2Pivot", txURI1);
        try {
            myQVT2.createGeneratedExecutor(txClass1);
            myQVT2.loadInput("ecore", this.getModelsURI("families2persons/Families.ecore"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("as", asURI2, this.getModelsURI("ecore2pivot/Families_expected.ecore.oclas"), null);
        }
        finally {
            myQVT2.dispose();
        }
    }

    @Test
    public void testQVTrCompiler_Families2Persons_CG() throws Exception {
        Class txClass;
        ConnectivityChecker.CONNECTIVITY_CLASSDATUMS.setState(true);
        ConnectivityChecker.CONNECTIVITY_CONNECTIONS.setState(true);
        ConnectivityChecker.CONNECTIVITY_EDGES.setState(true);
        ConnectivityChecker.CONNECTIVITY_NODES.setState(true);
        MyQVT myQVT1 = this.createQVT("Families2Persons", this.getModelsURI("families2persons/Families2Persons_expected.qvtras"));
        try {
            txClass = myQVT1.buildTransformation("Persons", false, new String[0]);
            myQVT1.assertRegionCount(RuleRegionImpl.class, 2);
            myQVT1.assertRegionCount(EarlyMerger.EarlyMergedMappingRegion.class, 0);
            myQVT1.assertRegionCount(LateConsumerMerger.LateMergedMappingRegion.class, 0);
            myQVT1.assertRegionCount(MicroMappingRegionImpl.class, 0);
        }
        finally {
            myQVT1.dispose();
        }
        MyQVT myQVT2 = this.createQVT("Forward2Reverse", this.getModelsURI("forward2reverse/Forward2Reverse.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "Families.FamiliesPackage");
            myQVT2.loadEPackage(txClass, "Persons.PersonsPackage");
            myQVT2.loadEPackage(txClass, "trace_Families2Persons.trace_Families2PersonsPackage");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("Families", this.getModelsURI("families2persons/samples/Families.xmi"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("Persons", this.getTestURI("Persons_CG.xmi"), this.getModelsURI("families2persons/samples/Persons_expected.xmi"), Families2PersonsNormalizer.INSTANCE);
        }
        finally {
            myQVT2.dispose();
        }
    }

    @Test
    public void testQVTrCompiler_Forward2Reverse() throws Exception {
        MyQVT myQVT = this.createQVT("Forward2Reverse", this.getModelsURI("forward2reverse/Forward2Reverse.qvtr"));
        try {
            ImperativeTransformation asTransformation = myQVT.compileTransformation("reverse");
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("forward", this.getModelsURI("forward2reverse/samples/EmptyList.xmi"));
            myQVT.createModel("reverse", this.getTestURI("EmptyList_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("reverse", this.getTestURI("EmptyList_Interpreted.xmi"), this.getModelsURI("forward2reverse/samples/EmptyList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("forward", this.getModelsURI("forward2reverse/samples/OneElementList.xmi"));
            myQVT.createModel("reverse", this.getTestURI("OneElementList_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("reverse", this.getTestURI("OneElementList_Interpreted.xmi"), this.getModelsURI("forward2reverse/samples/OneElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("forward", this.getModelsURI("forward2reverse/samples/TwoElementList.xmi"));
            myQVT.createModel("reverse", this.getTestURI("TwoElementList_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("reverse", this.getTestURI("TwoElementList_Interpreted.xmi"), this.getModelsURI("forward2reverse/samples/TwoElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("forward", this.getModelsURI("forward2reverse/samples/ThreeElementList.xmi"));
            myQVT.createModel("reverse", this.getTestURI("ThreeElementList_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("reverse", this.getTestURI("ThreeElementList_Interpreted.xmi"), this.getModelsURI("forward2reverse/samples/ThreeElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTrCompiler_Forward2Reverse_CG() throws Exception {
        Class txClass;
        MyQVT myQVT1 = this.createQVT("Forward2Reverse", this.getModelsURI("forward2reverse/Forward2Reverse.qvtr"));
        try {
            txClass = myQVT1.buildTransformation("reverse", false, new String[0]);
            myQVT1.assertRegionCount(RuleRegionImpl.class, 2);
            myQVT1.assertRegionCount(EarlyMerger.EarlyMergedMappingRegion.class, 0);
            myQVT1.assertRegionCount(LateConsumerMerger.LateMergedMappingRegion.class, 0);
            myQVT1.assertRegionCount(MicroMappingRegionImpl.class, 4);
        }
        finally {
            myQVT1.dispose();
        }
        MyQVT myQVT2 = this.createQVT("Forward2Reverse", this.getModelsURI("forward2reverse/Forward2Reverse.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "doublylinkedlist.doublylinkedlistPackage");
            myQVT2.loadEPackage(txClass, "trace_Forward2Reverse.trace_Forward2ReversePackage");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("forward", this.getModelsURI("forward2reverse/samples/EmptyList.xmi"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("reverse", this.getTestURI("EmptyList_CG.xmi"), this.getModelsURI("forward2reverse/samples/EmptyList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("forward", this.getModelsURI("forward2reverse/samples/OneElementList.xmi"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("reverse", this.getTestURI("OneElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/OneElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("forward", this.getModelsURI("forward2reverse/samples/TwoElementList.xmi"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("reverse", this.getTestURI("TwoElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/TwoElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("forward", this.getModelsURI("forward2reverse/samples/ThreeElementList.xmi"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("reverse", this.getTestURI("ThreeElementList_CG.xmi"), this.getModelsURI("forward2reverse/samples/ThreeElementList_expected.xmi"), Forward2ReverseNormalizer.INSTANCE);
        }
        finally {
            myQVT2.dispose();
        }
    }

    @Test
    public void testQVTrCompiler_HierarchicalStateMachine2FlatStateMachine() throws Exception {
        MyQVT myQVT = this.createQVT("HierarchicalStateMachine2FlatStateMachine", this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr"));
        try {
            ImperativeTransformation asTransformation = myQVT.compileTransformation("flat");
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("hier", this.getModelsURI("hstm2fstm/samples/MiniModel.xmi"));
            myQVT.createModel("flat", this.getTestURI("MiniModel_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("flat", this.getTestURI("MiniModel_Interpreted.xmi"), this.getModelsURI("hstm2fstm/samples/MiniModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("hier", this.getModelsURI("hstm2fstm/samples/SimpleModel.xmi"));
            myQVT.createModel("flat", this.getTestURI("SimpleModel_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("flat", this.getTestURI("SimpleModel_Interpreted.xmi"), this.getModelsURI("hstm2fstm/samples/SimpleModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("hier", this.getModelsURI("hstm2fstm/samples/LargerModel.xmi"));
            myQVT.createModel("flat", this.getTestURI("LargerModel_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("flat", this.getTestURI("LargerModel_Interpreted.xmi"), this.getModelsURI("hstm2fstm/samples/LargerModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTrCompiler_HierarchicalStateMachine2FlatStateMachine_CG() throws Exception {
        Class txClass;
        MyQVT myQVT1 = this.createQVT("HierarchicalStateMachine2FlatStateMachine", this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr"));
        try {
            txClass = myQVT1.buildTransformation("flat", false, new String[0]);
            myQVT1.assertRegionCount(RuleRegionImpl.class, 3);
            myQVT1.assertRegionCount(EarlyMerger.EarlyMergedMappingRegion.class, 0);
            myQVT1.assertRegionCount(LateConsumerMerger.LateMergedMappingRegion.class, 0);
            myQVT1.assertRegionCount(MicroMappingRegionImpl.class, 0);
        }
        finally {
            myQVT1.dispose();
        }
        MyQVT myQVT2 = this.createQVT("HierarchicalStateMachine2FlatStateMachine", this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "FlatStateMachine.FlatStateMachinePackage");
            myQVT2.loadEPackage(txClass, "HierarchicalStateMachine.HierarchicalStateMachinePackage");
            myQVT2.loadEPackage(txClass, "trace_HierarchicalStateMachine2FlatStateMachine.trace_HierarchicalStateMachine2FlatStateMachinePackage");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("hier", this.getModelsURI("hstm2fstm/samples/MiniModel.xmi"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("flat", this.getTestURI("MiniModel_CG.xmi"), this.getModelsURI("hstm2fstm/samples/MiniModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("hier", this.getModelsURI("hstm2fstm/samples/SimpleModel.xmi"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("flat", this.getTestURI("SimpleModel_CG.xmi"), this.getModelsURI("hstm2fstm/samples/SimpleModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("hier", this.getModelsURI("hstm2fstm/samples/LargerModel.xmi"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("flat", this.getTestURI("LargerModel_CG.xmi"), this.getModelsURI("hstm2fstm/samples/LargerModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
        }
        finally {
            myQVT2.dispose();
        }
    }

    @Test
    public void testQVTrCompiler_HierarchicalStateMachine2FlatStateMachine_example_CG() throws Exception {
        Class txClass;
        URI txURI = URI.createPlatformResourceURI((String)"/org.eclipse.qvtd.examples.qvtrelation.hstm2fstm/model/HierarchicalStateMachine2FlatStateMachine.qvtr", (boolean)true);
        MyQVT myQVT1 = this.createQVT("hstm2fstm", txURI);
        try {
            txClass = myQVT1.buildTransformation("flat", false, new String[0]);
            myQVT1.assertRegionCount(RuleRegionImpl.class, 3);
            myQVT1.assertRegionCount(EarlyMerger.EarlyMergedMappingRegion.class, 0);
            myQVT1.assertRegionCount(LateConsumerMerger.LateMergedMappingRegion.class, 0);
            myQVT1.assertRegionCount(MicroMappingRegionImpl.class, 0);
        }
        finally {
            myQVT1.dispose();
        }
        MyQVT myQVT2 = this.createQVT("HierarchicalStateMachine2FlatStateMachine", this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "FlatStateMachine.FlatStateMachinePackage");
            myQVT2.loadEPackage(txClass, "HierarchicalStateMachine.HierarchicalStateMachinePackage");
            myQVT2.loadEPackage(txClass, "trace_HierarchicalStateMachine2FlatStateMachine.trace_HierarchicalStateMachine2FlatStateMachinePackage");
            URI inURI = URI.createPlatformResourceURI((String)"/org.eclipse.qvtd.examples.qvtrelation.hstm2fstm/model/in/hier.xmi", (boolean)true);
            URI outURI = this.getTestURI("generated_CG.xmi");
            URI expectedURI = URI.createPlatformResourceURI((String)"/org.eclipse.qvtd.examples.qvtrelation.hstm2fstm/model/out/expected.xmi", (boolean)true);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("hier", inURI);
            myQVT2.executeTransformation();
            myQVT2.saveOutput("flat", outURI, expectedURI, FlatStateMachineNormalizer.INSTANCE);
        }
        finally {
            myQVT2.dispose();
        }
    }

    @Test
    public void testQVTrCompiler_HierarchicalStateMachine2FlatStateMachine_iCG() throws Exception {
        Class txClass;
        MyQVT myQVT1 = this.createQVT("HierarchicalStateMachine2FlatStateMachine", this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr"));
        try {
            txClass = myQVT1.buildTransformation("flat", true, new String[0]);
        }
        finally {
            myQVT1.dispose();
        }
        MyQVT myQVT2 = this.createQVT("HierarchicalStateMachine2FlatStateMachine", this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "FlatStateMachine.FlatStateMachinePackage");
            myQVT2.loadEPackage(txClass, "HierarchicalStateMachine.HierarchicalStateMachinePackage");
            myQVT2.loadEPackage(txClass, "trace_HierarchicalStateMachine2FlatStateMachine.trace_HierarchicalStateMachine2FlatStateMachinePackage");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("hier", this.getModelsURI("hstm2fstm/samples/MiniModel.xmi"));
            Transformer tx = myQVT2.executeTransformation();
            Execution2GraphVisitor.writeGraphMLfile((Transformer)tx, (URI)this.getTestURI("MiniModel-incremental.graphml"));
            myQVT2.saveOutput("flat", this.getTestURI("MiniModel_CG.xmi"), this.getModelsURI("hstm2fstm/samples/MiniModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("hier", this.getModelsURI("hstm2fstm/samples/SimpleModel.xmi"));
            tx = myQVT2.executeTransformation();
            Execution2GraphVisitor.writeGraphMLfile((Transformer)tx, (URI)this.getTestURI("SimpleModel-incremental.graphml"));
            myQVT2.saveOutput("flat", this.getTestURI("SimpleModel_CG.xmi"), this.getModelsURI("hstm2fstm/samples/SimpleModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("hier", this.getModelsURI("hstm2fstm/samples/LargerModel.xmi"));
            tx = myQVT2.executeTransformation();
            Execution2GraphVisitor.writeGraphMLfile((Transformer)tx, (URI)this.getTestURI("LargerModel-incremental.graphml"));
            myQVT2.saveOutput("flat", this.getTestURI("LargerModel_CG.xmi"), this.getModelsURI("hstm2fstm/samples/LargerModel_expected.xmi"), FlatStateMachineNormalizer.INSTANCE);
        }
        finally {
            myQVT2.dispose();
        }
    }

    @Test
    public void testQVTrCompiler_Iterated2Iterated_CG() throws Exception {
        Class txClass;
        MyQVT myQVT1 = this.createQVT("Iterated2Iterated", this.getModelsURI("iterated2iterated/Iterated2Iterated.qvtr"));
        myQVT1.addUsedGenPackage("org.eclipse.emf.ecore/model/Ecore.genmodel", "//ecore");
        try {
            txClass = myQVT1.buildTransformation("to", false, new String[0]);
        }
        finally {
            myQVT1.dispose();
        }
        MyQVT myQVT2 = this.createQVT("Iterated2Iterated", this.getModelsURI("Iterated2Iterated/Iterated2Iterated.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "iterated.iteratedPackage");
            myQVT2.loadEPackage(txClass, "trace_Iterated2Iterated.trace_Iterated2IteratedPackage");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("from", this.getModelsURI("iterated2iterated/samples/testcase1-in.xmi"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("to", this.getTestURI("testcase1-out_CG.iterated"), this.getModelsURI("iterated2iterated/samples/testcase1-out.xmi"), null);
        }
        finally {
            myQVT2.dispose();
        }
    }

    @Test
    public void testQVTrCompiler_MiToSiSimple_CG() throws Exception {
        Class txClass;
        ToStringVisitor.SHOW_ALL_MULTIPLICITIES = true;
        MyQVT myQVT1 = this.createQVT("MiToSiSimple", this.getModelsURI("mitosi/MiToSiSimple.qvtr"));
        try {
            txClass = myQVT1.buildTransformation("java", false, new String[0]);
        }
        finally {
            myQVT1.dispose();
        }
        MyQVT myQVT2 = this.createQVT("MiToSiSimple", this.getModelsURI("mitosi/MiToSiSimple.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "javammsi.javammsiPackage");
            myQVT2.loadEPackage(txClass, "umlmmmi.umlmmmiPackage");
            myQVT2.loadEPackage(txClass, "trace_MiToSiSimple.trace_MiToSiSimplePackage");
            Map extensionToFactoryMap = myQVT2.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap();
            extensionToFactoryMap.put("xml", new XMIResourceFactoryImpl());
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("uml", this.getModelsURI("mitosi/samples/transportuml.xml"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("java", this.getTestURI("transportjava_CG.xml"), this.getModelsURI("mitosi/samples/transportjava.xml"), null);
        }
        finally {
            myQVT2.dispose();
        }
    }

    @Test
    public void testQVTrCompiler_MiToSiSimpleWithKeys_CG() throws Exception {
        Class txClass;
        ToStringVisitor.SHOW_ALL_MULTIPLICITIES = true;
        MyQVT myQVT1 = this.createQVT("MiToSiSimpleWithKeys", this.getModelsURI("mitosi/MiToSiSimpleWithKeys.qvtr"));
        try {
            txClass = myQVT1.buildTransformation("java", false, new String[0]);
        }
        finally {
            myQVT1.dispose();
        }
        MyQVT myQVT2 = this.createQVT("MiToSiSimple", this.getModelsURI("mitosi/MiToSiSimple.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "javammsi.javammsiPackage");
            myQVT2.loadEPackage(txClass, "umlmmmi.umlmmmiPackage");
            myQVT2.loadEPackage(txClass, "trace_MiToSiSimpleWithKeys.trace_MiToSiSimpleWithKeysPackage");
            Map extensionToFactoryMap = myQVT2.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap();
            extensionToFactoryMap.put("xml", new XMIResourceFactoryImpl());
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("uml", this.getModelsURI("mitosi/samples/transportuml.xml"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("java", this.getTestURI("transportjava_CG.xml"), this.getModelsURI("mitosi/samples/transportjava.xml"), null);
        }
        finally {
            myQVT2.dispose();
        }
    }

    @Test
    public void testQVTrCompiler_SeqToStm() throws Exception {
        MyQVT myQVT = this.createQVT("SeqToStm", this.getModelsURI("seq2stm/SeqToStm.qvtr"));
        try {
            ImperativeTransformation asTransformation = myQVT.compileTransformation("stm");
            myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("seqDgm", this.getModelsURI("seq2stm/samples/Seq.xmi"));
            myQVT.createModel("middle", this.getTestURI("Seq2Stmc_trace.xmi"));
            myQVT.createModel("stm", this.getTestURI("Stmc_Interpreted.xmi"));
            myQVT.executeTransformation();
            myQVT.saveOutput("stm", this.getTestURI("Stmc_Interpreted.xmi"), this.getModelsURI("seq2stm/samples/Stmc_expected.xmi"), null);
        }
        finally {
            myQVT.dispose();
        }
    }

    @Test
    public void testQVTrCompiler_SeqToStm_CG() throws Exception {
        Class txClass;
        MyQVT myQVT1 = this.createQVT("SeqToStm", this.getModelsURI("seq2stm/SeqToStm.qvtr"));
        try {
            txClass = myQVT1.buildTransformation("stm", false, new String[0]);
            myQVT1.assertRegionCount(RuleRegionImpl.class, 4);
            myQVT1.assertRegionCount(EarlyMerger.EarlyMergedMappingRegion.class, 0);
            myQVT1.assertRegionCount(LateConsumerMerger.LateMergedMappingRegion.class, 0);
            myQVT1.assertRegionCount(MicroMappingRegionImpl.class, 0);
        }
        finally {
            myQVT1.dispose();
        }
        MyQVT myQVT2 = this.createQVT("SeqToStm", this.getModelsURI("seq2stm/SeqToStm.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "SeqMM.SeqMMPackage");
            myQVT2.loadEPackage(txClass, "StmcMM.StmcMMPackage");
            myQVT2.loadEPackage(txClass, "trace_SeqToStm.trace_SeqToStmPackage");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("seqDgm", this.getModelsURI("seq2stm/samples/Seq.xmi"));
            myQVT2.executeTransformation();
            myQVT2.saveOutput("stm", this.getTestURI("Stmc_CG.xmi"), this.getModelsURI("seq2stm/samples/Stmc_expected.xmi"), null);
        }
        finally {
            myQVT2.dispose();
        }
    }

    @Test
    public void testQVTrCompiler_SeqToStm_iCG() throws Exception {
        Class txClass;
        MyQVT myQVT1 = this.createQVT("SeqToStm", this.getModelsURI("seq2stm/SeqToStm.qvtr"));
        try {
            txClass = myQVT1.buildTransformation("stm", true, new String[0]);
        }
        finally {
            myQVT1.dispose();
        }
        MyQVT myQVT2 = this.createQVT("SeqToStm", this.getModelsURI("seq2stm/SeqToStm.qvtr"));
        try {
            myQVT2.loadEPackage(txClass, "SeqMM.SeqMMPackage");
            myQVT2.loadEPackage(txClass, "StmcMM.StmcMMPackage");
            myQVT2.loadEPackage(txClass, "trace_SeqToStm.trace_SeqToStmPackage");
            myQVT2.createGeneratedExecutor(txClass);
            myQVT2.loadInput("seqDgm", this.getModelsURI("seq2stm/samples/Seq.xmi"));
            Transformer tx = myQVT2.executeTransformation();
            Execution2GraphVisitor.writeGraphMLfile((Transformer)tx, (URI)this.getTestURI("SeqToStm-incremental.graphml"));
            myQVT2.saveOutput("stm", this.getTestURI("Stmc_CG.xmi"), this.getModelsURI("seq2stm/samples/Stmc_expected.xmi"), null);
        }
        finally {
            myQVT2.dispose();
        }
    }

    protected class MyQVT
    extends AbstractTestQVT {
        public MyQVT(@NonNull ProjectManager projectManager, @NonNull String testProjectName, @NonNull URI testBundleURI, @NonNull URI txURI, @NonNull URI prefixURI, @NonNull URI srcFileURI, URI binFileURI) {
            super(projectManager, testProjectName, testBundleURI, txURI, prefixURI, srcFileURI, binFileURI);
        }

        protected @NonNull QVTrCompilerChain createCompilerChain(@NonNull URI txURI, @NonNull URI prefixURI, @NonNull CompilerOptions options) {
            return new InstrumentedCompilerChain(this.getEnvironmentFactory(), txURI, prefixURI, options);
        }

        protected boolean generateGenModel() {
            return true;
        }

        protected @NonNull String getBasePrefix() {
            return "org.eclipse.qvtd.xtext.qvtrelation.tests";
        }

        protected @NonNull ProjectManager getTestProjectManager() throws Exception {
            return EMFPlugin.IS_ECLIPSE_RUNNING ? new ProjectMap(true) : QVTrCompilerTests.this.getTestProjectManager();
        }

        protected class InstrumentedCompilerChain
        extends QVTrCompilerChain {
            protected InstrumentedCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @NonNull URI prefixURI, CompilerOptions options) {
                super(environmentFactory, txURI, prefixURI, options);
            }

            public @NonNull ImperativeTransformation compile(@NonNull String enforcedOutputName) throws IOException {
                ImperativeTransformation asTransformation = super.compile(enforcedOutputName);
                return asTransformation;
            }

            protected // Could not load outer class - annotation placement on inner may be incorrect
             @NonNull AbstractCompilerChain.QVTm2QVTsCompilerStep createQVTm2QVTsCompilerStep() {
                return new AbstractCompilerChain.QVTm2QVTsCompilerStep((CompilerChain)this){

                    public @NonNull ScheduleManager execute(@NonNull Resource pResource) throws IOException {
                        ScheduleManager scheduleManager = super.execute(pResource);
                        MyQVT.this.instrumentRegion(scheduleManager);
                        return scheduleManager;
                    }
                };
            }

            protected // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull QVTrCompilerChain.QVTr2QVTcCompilerStep createQVTr2QVTcCompilerStep() {
                return new QVTrCompilerChain.QVTr2QVTcCompilerStep((CompilerChain)this){

                    protected void doQVTcSerializeAndLoad(@NonNull URI asURI, @NonNull URI csURI) throws IOException {
                        XtextCompilerUtil.doQVTcSerializeAndLoad((ProjectManager)this.environmentFactory.getProjectManager(), (URI)asURI, (URI)csURI);
                    }
                };
            }
        }
    }
}

