/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class ContentsAnalysis {
    protected final @NonNull ScheduleManager scheduleManager;
    private final @NonNull Map<@NonNull ClassDatum, @NonNull List<@NonNull Node>> classDatum2newNodes = new HashMap<ClassDatum, List<Node>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull List<@NonNull Node>> classDatum2oldNodes = new HashMap<ClassDatum, List<Node>>();
    private final @NonNull Map<@NonNull PropertyDatum, @NonNull List<@NonNull NavigableEdge>> propertyDatum2newEdges = new HashMap<PropertyDatum, List<NavigableEdge>>();

    public ContentsAnalysis(@NonNull ScheduleManager scheduleManager) {
        this.scheduleManager = scheduleManager;
    }

    private void addNewEdge(@NonNull NavigableEdge newEdge) {
        PropertyDatum propertyDatum = this.basicGetPropertyDatum(newEdge);
        if (propertyDatum == null) {
            propertyDatum = this.basicGetPropertyDatum(newEdge);
        }
        assert (propertyDatum != null);
        this.addNewEdge(newEdge, propertyDatum);
    }

    private void addNewEdge(@NonNull NavigableEdge newEdge, @NonNull PropertyDatum propertyDatum) {
        List<@NonNull NavigableEdge> edges = this.propertyDatum2newEdges.get(propertyDatum);
        if (edges == null) {
            edges = new ArrayList<NavigableEdge>();
            this.propertyDatum2newEdges.put(propertyDatum, edges);
        }
        if (!edges.contains(newEdge)) {
            edges.add(newEdge);
            for (PropertyDatum superAbstractDatum : ClassUtil.nullFree((EList)propertyDatum.getSuperPropertyDatums())) {
                this.addNewEdge(newEdge, superAbstractDatum);
            }
        }
    }

    private void addNewNode(@NonNull Node newNode) {
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)newNode);
        ClassDatum elementalClassDatum = this.scheduleManager.getElementalClassDatum(classDatum);
        for (ClassDatum superClassDatum : this.scheduleManager.getSuperClassDatums(elementalClassDatum)) {
            List<@NonNull Node> nodes = this.classDatum2newNodes.get(superClassDatum);
            if (nodes == null) {
                nodes = new ArrayList<Node>();
                this.classDatum2newNodes.put(superClassDatum, nodes);
            }
            nodes.add(newNode);
        }
    }

    private void addOldNode(@NonNull Node oldNode) {
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)oldNode);
        List<@NonNull Node> nodes = this.classDatum2oldNodes.get(classDatum);
        if (nodes == null) {
            nodes = new ArrayList<Node>();
            this.classDatum2oldNodes.put(classDatum, nodes);
        }
        if (!nodes.contains(oldNode)) {
            nodes.add(oldNode);
        }
    }

    public void addRegion(@NonNull Region region) {
        for (Node oldNode : region.getOldNodes()) {
            if (oldNode.isDependency() || oldNode.isConstant()) continue;
            if (oldNode.isHead()) {
                this.addOldNode(oldNode);
                continue;
            }
            if (this.isOnlyCastOrRecursed(oldNode)) continue;
            this.addOldNode(oldNode);
        }
        for (Node newNode : region.getNewNodes()) {
            if (!newNode.isClass()) continue;
            this.addNewNode(newNode);
        }
        for (NavigableEdge newEdge : region.getRealizedNavigationEdges()) {
            this.addNewEdge(newEdge);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable PropertyDatum basicGetPropertyDatum(@NonNull NavigableEdge producedEdge) {
        assert (!producedEdge.isCast());
        Property forwardProperty = producedEdge.getProperty();
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)producedEdge.getEdgeSource());
        ClassDatum forwardClassDatum = this.scheduleManager.getElementalClassDatum(classDatum);
        Iterable<@NonNull PropertyDatum> forwardPropertyDatums = this.scheduleManager.getAllPropertyDatums(forwardClassDatum);
        for (PropertyDatum propertyDatum : forwardPropertyDatums) {
            if (propertyDatum.getReferredProperty() != forwardProperty || propertyDatum.getOwningClassDatum() != forwardClassDatum) continue;
            return propertyDatum;
        }
        PropertyDatum bestPropertyDatum = null;
        for (PropertyDatum propertyDatum : forwardPropertyDatums) {
            if (propertyDatum.getReferredProperty() != forwardProperty) continue;
            if (bestPropertyDatum == null) {
                bestPropertyDatum = propertyDatum;
                continue;
            }
            CompleteClass completeClass = propertyDatum.getOwningClassDatum().getCompleteClass();
            assert (completeClass != null);
            @NonNull HashSet allSuperCompleteClasses = Sets.newHashSet((Iterable)completeClass.getProperSuperCompleteClasses());
            if (!allSuperCompleteClasses.contains(bestPropertyDatum.getOwningClassDatum().getCompleteClass())) continue;
            bestPropertyDatum = propertyDatum;
        }
        if (bestPropertyDatum != null) {
            return bestPropertyDatum;
        }
        Property reverseProperty = forwardProperty.getOpposite();
        classDatum = QVTscheduleUtil.getClassDatum((Node)producedEdge.getEdgeTarget());
        ClassDatum reverseClassDatum = this.scheduleManager.getElementalClassDatum(classDatum);
        Iterable<@NonNull PropertyDatum> reversePropertyDatums = this.scheduleManager.getAllPropertyDatums(reverseClassDatum);
        for (PropertyDatum propertyDatum : reversePropertyDatums) {
            if (propertyDatum.getReferredProperty() != reverseProperty || propertyDatum.getOwningClassDatum() != reverseClassDatum) continue;
            return propertyDatum;
        }
        for (PropertyDatum propertyDatum : reversePropertyDatums) {
            if (propertyDatum.getReferredProperty() != reverseProperty) continue;
            if (bestPropertyDatum == null) {
                bestPropertyDatum = propertyDatum;
                continue;
            }
            CompleteClass completeClass = propertyDatum.getOwningClassDatum().getCompleteClass();
            assert (completeClass != null);
            @NonNull HashSet allSuperCompleteClasses = Sets.newHashSet((Iterable)completeClass.getProperSuperCompleteClasses());
            if (!allSuperCompleteClasses.contains(bestPropertyDatum.getOwningClassDatum().getCompleteClass())) continue;
            bestPropertyDatum = propertyDatum;
        }
        if (bestPropertyDatum != null) {
            return bestPropertyDatum;
        }
        return null;
    }

    public Stream<String> dumpClass2oldNode() {
        Stream<String> entries = this.classDatum2oldNodes.keySet().stream().map(k -> {
            List<Node> list = this.classDatum2oldNodes.get(k);
            assert (list != null);
            return String.valueOf(String.valueOf(k)) + " : " + list.stream().map(p -> p.getDisplayName()).sorted().reduce("", QVTscheduleUtil.stringJoin((String)"\n\t\t"));
        });
        return entries.sorted();
    }

    public Stream<String> dumpClass2newNode() {
        Stream<String> entries = this.classDatum2newNodes.keySet().stream().map(k -> {
            List<Node> list = this.classDatum2newNodes.get(k);
            assert (list != null);
            return this.scheduleManager.getDomainUsage((Element)k) + " " + String.valueOf(k) + " : " + list.stream().map(p -> p.getDisplayName()).sorted().reduce("", QVTscheduleUtil.stringJoin((String)"\n\t\t"));
        });
        return entries.sorted();
    }

    private @Nullable Iterable<@NonNull NavigableEdge> getCompositeNewEdges(@NonNull NavigableEdge predicatedEdge) {
        HashSet<@NonNull E> realizedEdges = null;
        for (Map.Entry<PropertyDatum, List<NavigableEdge>> entry : this.propertyDatum2newEdges.entrySet()) {
            Property property = entry.getKey().getReferredProperty();
            if (property == null) continue;
            Property compositeProperty = null;
            if (property.isIsComposite()) {
                compositeProperty = property;
            } else {
                Property oppositeProperty = property.getOpposite();
                if (oppositeProperty != null && oppositeProperty.isIsComposite()) {
                    compositeProperty = oppositeProperty;
                }
            }
            if (compositeProperty == null) continue;
            if (realizedEdges == null) {
                realizedEdges = new HashSet();
            }
            realizedEdges.addAll(entry.getValue());
        }
        return realizedEdges;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable Iterable<@NonNull NavigableEdge> getNewEdges(@NonNull NavigableEdge edge, @NonNull ClassDatum requiredClassDatum) {
        Property property = edge.getProperty();
        if (property.eContainer() == null) {
            return null;
        }
        PropertyDatum propertyDatum = this.basicGetPropertyDatum(edge);
        if (propertyDatum == null) {
            if (property == this.scheduleManager.getStandardLibraryHelper().getOclContainerProperty()) {
                return this.getCompositeNewEdges(edge);
            }
            propertyDatum = this.basicGetPropertyDatum(edge);
        }
        if (propertyDatum == null) {
            return null;
        }
        @NonNull Iterable realizedEdges = this.propertyDatum2newEdges.get(propertyDatum);
        if (realizedEdges == null) {
            return null;
        }
        CompleteClass requiredClass = QVTscheduleUtil.getCompleteClass((ClassDatum)requiredClassDatum);
        ArrayList<NavigableEdge> conformantRealizedEdges = null;
        for (NavigableEdge realizedEdge : realizedEdges) {
            Node targetNode = realizedEdge.getEdgeTarget();
            CompleteClass realizedClass = targetNode.getCompleteClass();
            if (!QVTscheduleUtil.conformsToClassOrBehavioralClass((CompleteClass)realizedClass, (CompleteClass)requiredClass)) continue;
            if (conformantRealizedEdges == null) {
                conformantRealizedEdges = new ArrayList<NavigableEdge>();
            }
            conformantRealizedEdges.add(realizedEdge);
        }
        return conformantRealizedEdges;
    }

    public @Nullable Iterable<@NonNull Node> getNewNodes(@NonNull ClassDatum classDatum) {
        return this.classDatum2newNodes.get(classDatum);
    }

    public @Nullable Iterable<@NonNull Node> getOldNodes(@NonNull ClassDatum classDatum) {
        return this.classDatum2oldNodes.get(classDatum);
    }

    private boolean isOnlyCastOrRecursed(@NonNull Node predicatedNode) {
        boolean isCast = false;
        for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)predicatedNode)) {
            if (!outgoingEdge.isCast() && !outgoingEdge.isRecursion()) {
                return false;
            }
            isCast = true;
        }
        return isCast;
    }

    private void removeNewEdge(@NonNull NavigableEdge newEdge) {
        PropertyDatum propertyDatum = this.basicGetPropertyDatum(newEdge);
        if (propertyDatum == null) {
            propertyDatum = this.basicGetPropertyDatum(newEdge);
        }
        assert (propertyDatum != null);
        this.removeNewEdge(newEdge, propertyDatum);
    }

    private void removeNewEdge(@NonNull NavigableEdge newEdge, @NonNull PropertyDatum propertyDatum) {
        List<@NonNull NavigableEdge> edges = this.propertyDatum2newEdges.get(propertyDatum);
        if (edges != null && edges.remove(newEdge)) {
            for (PropertyDatum superAbstractDatum : ClassUtil.nullFree((EList)propertyDatum.getSuperPropertyDatums())) {
                this.removeNewEdge(newEdge, superAbstractDatum);
            }
        }
    }

    private void removeNewNode(@NonNull Node newNode) {
        List<@NonNull Node> nodes = this.classDatum2newNodes.get(newNode.getClassDatum());
        if (nodes != null) {
            nodes.remove(newNode);
        }
    }

    private void removeOldNode(@NonNull Node oldNode) {
        List<@NonNull Node> nodes = this.classDatum2oldNodes.get(oldNode.getClassDatum());
        if (nodes != null) {
            nodes.remove(oldNode);
        }
    }

    public void removeRegion(@NonNull Region region) {
        for (Node oldNode : region.getOldNodes()) {
            this.removeOldNode(oldNode);
        }
        for (Node newNode : region.getNewNodes()) {
            this.removeNewNode(newNode);
        }
        for (NavigableEdge newEdge : region.getRealizedNavigationEdges()) {
            this.removeNewEdge(newEdge);
        }
    }
}

