/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.m2m.atl.adt.ui.preferences.ProfileManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameProfileDialog
extends StatusDialog {
    private Text fNameText;
    private static final StatusInfo fOk = new StatusInfo();
    private static final StatusInfo fEmpty = new StatusInfo(4, "The profile name is empty");
    private static final StatusInfo fDuplicate = new StatusInfo(4, "A profile with this name already exists");
    private final ProfileManager fProfileManager;
    private ProfileManager.Profile fProfile;

    public RenameProfileDialog(Shell parentShell, ProfileManager.Profile profile, ProfileManager profileManager) {
        super(parentShell);
        this.fProfileManager = profileManager;
        this.fProfile = profile;
    }

    public void create() {
        super.create();
        this.setTitle("Rename a profile");
    }

    public Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        Label nameLabel = new Label(composite, 64);
        nameLabel.setText("New name for the profile \"" + this.fProfile.getName() + "\":");
        nameLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fNameText = new Text(composite, 2052);
        this.fNameText.setText(this.fProfile.getName());
        this.fNameText.setLayoutData((Object)gd);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameProfileDialog.this.doValidation();
            }
        });
        this.updateStatus((IStatus)fDuplicate);
        RenameProfileDialog.applyDialogFont((Control)composite);
        this.fNameText.setFocus();
        return composite;
    }

    protected void doValidation() {
        String name = this.fNameText.getText().trim();
        if (this.fProfileManager.containsName(name)) {
            this.updateStatus((IStatus)fDuplicate);
            return;
        }
        if (name.length() == 0) {
            this.updateStatus((IStatus)fEmpty);
            return;
        }
        this.updateStatus((IStatus)fOk);
    }

    protected void okPressed() {
        if (!this.getStatus().isOK()) {
            return;
        }
        String profileNewName = this.fNameText.getText();
        this.fProfile.rename(profileNewName, this.fProfileManager);
        super.okPressed();
    }
}

