/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.parser;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.emf.EMFInjector;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.emf.EMFModelFactory;
import org.eclipse.m2m.atl.dsls.core.EMFTCSExtractor;
import org.eclipse.m2m.atl.dsls.core.EMFTCSInjector;

public final class AtlParser
implements IInjector,
IExtractor {
    private static ModelFactory modelFactory = new EMFModelFactory();
    private static IInjector injector;
    private static IModel atlTcsModel;
    private static IReferenceModel problemMetamodel;
    private static IReferenceModel atlMetamodel;
    private static AtlParser defaultInstance;
    static /* synthetic */ Class class$0;

    static {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.m2m.atl.engine.parser.AtlParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            URL tcsMetamodelURL = clazz.getResource("resources/TCS.ecore");
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.m2m.atl.engine.parser.AtlParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            URL atlTcsModelURL = clazz2.getResource("resources/ATL-TCS.xmi");
            injector = new EMFInjector();
            atlMetamodel = modelFactory.getBuiltInResource("ATL.ecore");
            problemMetamodel = modelFactory.getBuiltInResource("Problem.ecore");
            IReferenceModel tcsMetamodel = modelFactory.newReferenceModel();
            injector.inject((IModel)tcsMetamodel, tcsMetamodelURL.openStream(), null);
            atlTcsModel = modelFactory.newModel(tcsMetamodel);
            injector.inject(atlTcsModel, atlTcsModelURL.openStream(), null);
        }
        catch (ATLCoreException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static AtlParser getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new AtlParser();
        }
        return defaultInstance;
    }

    public ModelFactory getModelFactory() {
        return modelFactory;
    }

    public IModel getAtlTcsModel() {
        return atlTcsModel;
    }

    public IReferenceModel getProblemMetamodel() {
        return problemMetamodel;
    }

    public IReferenceModel getAtlMetamodel() {
        return atlMetamodel;
    }

    public IModel[] inject(InputStream source, Map options) throws ATLCoreException {
        IModel targetModel = modelFactory.newModel(atlMetamodel);
        targetModel.setIsTarget(true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "ATL");
        params.put("problems", (String)modelFactory.newModel(problemMetamodel));
        if (options != null) {
            params.putAll(options);
        }
        this.inject(targetModel, source, params);
        targetModel.setIsTarget(false);
        return new IModel[]{targetModel, (IModel)params.get("problems")};
    }

    public IModel[] inject(Reader source, Map options) throws ATLCoreException {
        IModel targetModel = modelFactory.newModel(atlMetamodel);
        targetModel.setIsTarget(true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "ATL");
        params.put("problems", (String)modelFactory.newModel(problemMetamodel));
        if (options != null) {
            params.putAll(options);
        }
        this.inject(targetModel, source, params);
        targetModel.setIsTarget(false);
        return new IModel[]{targetModel, (IModel)params.get("problems")};
    }

    public void inject(IModel targetModel, InputStream source, Map options) throws ATLCoreException {
        EMFTCSInjector ebnfi = new EMFTCSInjector();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "ATL");
        params.put("problems", (String)modelFactory.newModel(problemMetamodel));
        if (options != null) {
            params.putAll(options);
        }
        try {
            ebnfi.inject((EMFModel)targetModel, source, params);
        }
        catch (IOException iOException) {}
    }

    public void inject(IModel targetModel, Reader source, Map options) throws ATLCoreException {
        EMFTCSInjector ebnfi = new EMFTCSInjector();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "ATL");
        params.put("problems", (String)modelFactory.newModel(problemMetamodel));
        if (options != null) {
            params.putAll(options);
        }
        try {
            ebnfi.inject((EMFModel)targetModel, source, params);
        }
        catch (IOException iOException) {}
    }

    public void inject(IModel targetModel, String source, Map options) throws ATLCoreException {
        try {
            FileInputStream fis = new FileInputStream(AtlParser.formatFileName(source));
            this.inject(targetModel, fis, options);
            fis.close();
        }
        catch (IOException e) {
            throw new ATLCoreException(e.getMessage(), (Throwable)e);
        }
    }

    public void inject(IModel targetModel, String source) throws ATLCoreException {
        this.inject(targetModel, source, null);
    }

    public void extract(IModel sourceModel, OutputStream target, Map options) throws ATLCoreException {
        EMFTCSExtractor ebnfe = new EMFTCSExtractor();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("format", atlTcsModel);
        params.put("indentString", " ");
        params.put("identEsc", "\"");
        params.put("stringDelim", "'");
        params.put("serializeComments", "true");
        if (options != null) {
            params.putAll(options);
        }
        ebnfe.extract((EMFModel)sourceModel, target, params);
    }

    public void extract(IModel sourceModel, String target, Map options) throws ATLCoreException {
        try {
            FileOutputStream fos = new FileOutputStream(AtlParser.formatFileName(target));
            this.extract(sourceModel, fos, options);
            fos.close();
        }
        catch (IOException e) {
            throw new ATLCoreException(e.getMessage(), (Throwable)e);
        }
    }

    public void extract(IModel sourceModel, String target) throws ATLCoreException {
        this.extract(sourceModel, target, null);
    }

    private static String formatFileName(String fileName) {
        if (fileName.startsWith("file:")) {
            return fileName.substring(5);
        }
        return fileName;
    }

    public EObject parse(InputStream in) throws ATLCoreException {
        return this.parseWithProblems(in)[0];
    }

    public EObject[] parseWithProblems(InputStream in) throws ATLCoreException {
        return AtlParser.convertToEmf(this.parseToModelWithProblems(in, true), "Unit");
    }

    public IModel parseToModel(InputStream in) throws ATLCoreException {
        return this.parseToModelWithProblems(in, true)[0];
    }

    public IModel[] parseToModelWithProblems(InputStream in, boolean hideErrors) throws ATLCoreException {
        return this.inject(in, null);
    }

    public EObject[] parseExpression(String expression, String expressionType) {
        if (expressionType == null) {
            return null;
        }
        IModel[] ret = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "ATL-" + expressionType);
        try {
            ret = this.inject(new ByteArrayInputStream(expression.getBytes()), params);
        }
        catch (ATLCoreException aTLCoreException) {}
        String rootTypeName = String.valueOf(Character.toUpperCase(expressionType.charAt(0))) + expressionType.substring(1);
        return AtlParser.convertToEmf(ret, rootTypeName);
    }

    private static EObject[] convertToEmf(IModel[] parsed, String rootTypeName) {
        EObject[] ret = null;
        EObject retUnit = null;
        Collection pbs = null;
        IModel atlmodel = parsed[0];
        IModel problems = parsed[1];
        if (atlmodel instanceof EMFModel) {
            Collection roots = AtlParser.getElementsByType(atlmodel, rootTypeName);
            if (roots.size() > 0) {
                retUnit = (EObject)roots.iterator().next();
            }
            pbs = AtlParser.getElementsByType(problems, "Problem");
        }
        if (pbs != null) {
            ret = new EObject[1 + pbs.size()];
            int k = 1;
            Iterator i = pbs.iterator();
            while (i.hasNext()) {
                ret[k++] = (EObject)i.next();
            }
        } else {
            ret = new EObject[]{retUnit};
        }
        return ret;
    }

    private static Collection getElementsByType(IModel model, String typeName) {
        return model.getElementsByType(model.getReferenceModel().getMetaElementByName(typeName));
    }
}

