/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.outline;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;
import org.eclipse.m2m.atl.adt.ui.outline.AlphabeticalSorter;
import org.eclipse.m2m.atl.adt.ui.outline.AtlContentProvider;
import org.eclipse.m2m.atl.adt.ui.outline.AtlEMFConstants;
import org.eclipse.m2m.atl.adt.ui.outline.AtlLabelProvider;
import org.eclipse.m2m.atl.adt.ui.outline.AtlOutlinePage;
import org.eclipse.m2m.atl.adt.ui.outline.DefaultFilter;
import org.eclipse.m2m.atl.adt.ui.outline.DefaultSorter;
import org.eclipse.m2m.atl.adt.ui.outline.HideHelperFilter;
import org.eclipse.m2m.atl.adt.ui.outline.HideRuleFilter;
import org.eclipse.m2m.atl.adt.ui.outline.Root;
import org.eclipse.m2m.atl.common.AtlNbCharFile;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AtlContentOutlinePage
extends AtlOutlinePage {
    public static final String ATL_OUTLINE_VIEW_CONTEXT_MENU_ID = "org.eclipse.m2m.atl.adt.outline.contextMenu";
    private ViewerComparator alphabeticalSorter;
    private ViewerComparator defaultSorter;
    private String cursorPosition;
    private int depth = 1;
    private static AtlNbCharFile help;
    private ViewerFilter helperFilter;
    private ViewerFilter ruleFilter;
    private ViewerFilter defaultFilter;
    private boolean inputSet;
    private PerspectiveListener perspectiveListener;
    private Action filterHelperAction;
    private Action filterRuleAction;
    private Action sorterAction;
    private Action addBreakPointAction;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Root root;
    private EObject selectedEo;
    private final AtlEditor textEditor;

    public AtlContentOutlinePage(ITextEditor textEditor, IEditorInput editorInput, IDocumentProvider documentProvider) {
        this.textEditor = (AtlEditor)textEditor;
    }

    private void addPerspectiveListener(IPerspectiveListener l) {
        this.getSite().getPage().getWorkbenchWindow().addPerspectiveListener(l);
    }

    private int computeDepth(IPerspectiveDescriptor ipd) {
        if ("org.eclipse.debug.ui.DebugPerspective".equals(ipd.getId())) {
            return -1;
        }
        return 1;
    }

    private void createActions() {
        this.cutAction = new Action("Cut"){

            public void run() {
            }
        };
        this.cutAction.setImageDescriptor(AtlUIPlugin.getImageDescriptor("cut.gif"));
        this.copyAction = new Action("Copy"){

            public void run() {
            }
        };
        this.copyAction.setImageDescriptor(AtlUIPlugin.getImageDescriptor("copy.gif"));
        this.pasteAction = new Action("Paste"){

            public void run() {
            }
        };
        this.pasteAction.setImageDescriptor(AtlUIPlugin.getImageDescriptor("paste.gif"));
        this.addBreakPointAction = new Action("Toggle breakpoint"){

            public void run() {
                IStructuredSelection is = (IStructuredSelection)AtlContentOutlinePage.this.treeViewer.getSelection();
                EObject element = (EObject)is.getFirstElement();
                try {
                    AtlContentOutlinePage.this.textEditor.toggleLineBreakpoints(element);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        };
        this.addBreakPointAction.setImageDescriptor(AtlUIPlugin.getImageDescriptor("brkp_obj.gif"));
        this.filterHelperAction = new Action("Hide Helpers", 2){

            public void run() {
                AtlContentOutlinePage.this.updateFilters(AtlContentOutlinePage.this.filterHelperAction);
            }
        };
        this.filterHelperAction.setImageDescriptor(AtlUIPlugin.getImageDescriptor("hideHelper.gif"));
        this.filterHelperAction.setToolTipText("Hide helpers");
        this.filterRuleAction = new Action("Hide rules", 2){

            public void run() {
                AtlContentOutlinePage.this.updateFilters(AtlContentOutlinePage.this.filterRuleAction);
            }
        };
        this.filterRuleAction.setToolTipText("Hide the rules");
        this.filterRuleAction.setImageDescriptor(AtlUIPlugin.getImageDescriptor("hideMatchedRule.gif"));
        this.sorterAction = new Action("Alphabetical sort", 2){

            public void run() {
                AtlContentOutlinePage.this.updateSorter(AtlContentOutlinePage.this.sorterAction);
            }
        };
        this.sorterAction.setImageDescriptor(AtlUIPlugin.getImageDescriptor("alphab_sort.gif"));
        this.sorterAction.setToolTipText("sort alphabetically");
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AtlContentOutlinePage.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(ATL_OUTLINE_VIEW_CONTEXT_MENU_ID, menuMgr, (ISelectionProvider)this);
    }

    public void createControl(Composite arg0) {
        super.createControl(arg0);
        this.root = new Root();
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            this.selectionChangedListeners.remove(listeners[i]);
            this.treeViewer.addPostSelectionChangedListener((ISelectionChangedListener)listeners[i]);
            ++i;
        }
        this.treeViewer.setContentProvider((IContentProvider)new AtlContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AtlLabelProvider());
        this.createActions();
        this.createContextMenu();
        this.createToolbar();
        this.createMenu();
        this.createFiltersAndSorters();
        this.setUnit();
        this.treeViewer.addFilter(this.defaultFilter);
        this.treeViewer.setComparator(this.defaultSorter);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.perspectiveListener = new PerspectiveListener();
        this.addPerspectiveListener(this.perspectiveListener);
        this.depth = this.computeDepth(this.getCurrentPerspective());
    }

    public void createFiltersAndSorters() {
        this.helperFilter = new HideHelperFilter();
        this.ruleFilter = new HideRuleFilter();
        this.defaultFilter = new DefaultFilter();
        this.alphabeticalSorter = new AlphabeticalSorter();
        this.defaultSorter = new DefaultSorter();
    }

    private void createMenu() {
        IMenuManager mgr = this.getSite().getActionBars().getMenuManager();
        mgr.add((IAction)this.filterHelperAction);
        mgr.add((IAction)this.filterRuleAction);
        mgr.add((IAction)this.sorterAction);
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.filterHelperAction);
        mgr.add((IAction)this.filterRuleAction);
        mgr.add((IAction)this.sorterAction);
    }

    private void doSetSelection(String currentCursorPosition) {
        if (currentCursorPosition != null && !this.treeViewer.getTree().isDisposed()) {
            this.cursorPosition = currentCursorPosition;
            Root input = (Root)this.treeViewer.getInput();
            if (input != null) {
                EObject unit = input.getUnit();
                try {
                    int cursorIndexChar = help.getIndex(currentCursorPosition);
                    if (cursorIndexChar == -1) {
                        return;
                    }
                    this.selectedEo = unit;
                    this.setSelection(unit, cursorIndexChar, 0);
                    this.treeViewer.collapseAll();
                    this.treeViewer.expandToLevel(2);
                    this.showItem(this.selectedEo);
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    private void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IAction)this.cutAction);
        mgr.add((IAction)this.copyAction);
        mgr.add((IAction)this.pasteAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.addBreakPointAction);
        mgr.add((IContributionItem)new Separator());
    }

    private IPerspectiveDescriptor getCurrentPerspective() {
        return this.getSite().getPage().getPerspective();
    }

    private static int[] getPos(EObject eo) {
        String location = (String)eo.eGet(AtlEMFConstants.sfLocation);
        if (location == null) {
            return null;
        }
        int[] pos = help.getIndexChar(location);
        return pos;
    }

    private void initAtlNbCharFile(String content) {
        help = new AtlNbCharFile(this.toInputStream(content));
        ((DefaultSorter)this.defaultSorter).setHelp(help);
        this.textEditor.setHelp(help);
    }

    public void setUnit() {
        EObject eo = this.textEditor.getSourceManager().getModel();
        String newContent = this.textEditor.getDocumentProviderContent();
        if (eo != null) {
            this.root.setUnit(eo);
            if (!this.inputSet) {
                this.treeViewer.setInput((Object)this.root);
                this.inputSet = true;
            }
            this.initAtlNbCharFile(newContent);
            this.treeViewer.refresh((Object)this.root);
            this.treeViewer.expandToLevel(2);
        }
    }

    private void setSelection(EObject input, int cursorIndexChar, int currentLevel) {
        if (input == null || input.eContents() == null || input.eContents().isEmpty()) {
            return;
        }
        Object[] contents = input.eContents().toArray();
        int i = 0;
        while (i < contents.length) {
            EObject eo = (EObject)contents[i];
            int[] pos = AtlContentOutlinePage.getPos(eo);
            if (pos != null) {
                int eoStartChar = pos[0];
                int eoEndChar = pos[1];
                if (eoStartChar <= cursorIndexChar && eoEndChar >= cursorIndexChar) {
                    this.selectedEo = eo;
                    if (currentLevel + 1 >= this.depth && this.depth != -1) break;
                    this.setSelection(eo, cursorIndexChar, currentLevel + 1);
                    break;
                }
            }
            ++i;
        }
    }

    public void setSelection(String currentCursorPosition) {
        this.doSetSelection(currentCursorPosition);
    }

    private void showItem(EObject element) {
        int[] pos = AtlContentOutlinePage.getPos(element);
        if (pos != null && pos[1] - pos[0] > 0) {
            this.textEditor.setHighlightRange(pos[0], pos[1] - pos[0], false);
        }
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
    }

    private InputStream toInputStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes());
    }

    protected void updateFilters(Action actionParam) {
        if (actionParam == this.filterHelperAction) {
            if (actionParam.isChecked()) {
                this.treeViewer.addFilter(this.helperFilter);
            } else {
                this.treeViewer.removeFilter(this.helperFilter);
            }
        } else if (actionParam == this.filterRuleAction) {
            if (actionParam.isChecked()) {
                this.treeViewer.addFilter(this.ruleFilter);
            } else {
                this.treeViewer.removeFilter(this.ruleFilter);
            }
        }
    }

    protected void updateSorter(Action actionParam) {
        if (actionParam == this.sorterAction) {
            if (actionParam.isChecked()) {
                this.treeViewer.setComparator(this.alphabeticalSorter);
            } else {
                this.treeViewer.setComparator(this.defaultSorter);
            }
        }
    }

    private class PerspectiveListener
    implements IPerspectiveListener {
        private PerspectiveListener() {
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            IPageSite site = AtlContentOutlinePage.this.getSite();
            if (site != null && page == site.getPage()) {
                int newDepth = AtlContentOutlinePage.this.computeDepth(perspective);
                if (AtlContentOutlinePage.this.depth != newDepth) {
                    AtlContentOutlinePage.this.depth = newDepth;
                    AtlContentOutlinePage.this.doSetSelection(AtlContentOutlinePage.this.cursorPosition);
                }
            }
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        }
    }
}

