/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.types.StructureType;
import org.eclipse.mita.base.types.SumAlternative;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypesPackage;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.base.types.validation.IValidationIssueAcceptor;
import org.eclipse.mita.base.types.validation.TypeValidator;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.ConfigurationItem;
import org.eclipse.mita.platform.Instantiability;
import org.eclipse.mita.program.ConfigurationItemValue;
import org.eclipse.mita.program.ProgramPackage;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.inferrer.ProgramDslTypeInferrer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ProgramSetupValidator
extends AbstractDeclarativeValidator {
    @Inject
    private ProgramDslTypeInferrer inferrer;
    @Inject
    private TypeValidator typeValidator;
    public static final String INCOMPATIBLE_VALUE_TYPE_MSG = "The type '%s' is not compatible with the configuration item's type '%s'";
    public static final String INCOMPATIBLE_VALUE_TYPE_CODE = "incompatible_value_type";
    public static final String CONFIG_ITEM_VALUE_NOT_UNIQUE_MSG = "Cannot redeclare configuration item value '%s'";
    public static final String CONFIG_ITEM_VALUE_NOT_UNIQUE_CODE = "config_item_value_not_unique";
    public static final String SETUP_MUST_HAVE_NAME_MSG = "Connectivity setup blocks have to be named, e.g. '%s'";
    public static final String SETUP_MUST_HAVE_NAME_CODE = "setup_must_have_name";
    public static final String SETUP_MUST_NOT_HAVE_NAME_MSG = "Cannot assign a to this system resource.";
    public static final String SETUP_MUST_NOT_HAVE_NAME_CODE = "setup_most_not_have_name";
    public static final String MISSING_CONIGURATION_ITEM_CODE = "missing_config_item";

    @Check(value=CheckType.FAST)
    public void checkConfigurationItemValues(final SystemResourceSetup setup) {
        Iterable missingConfigItems;
        boolean _isEmpty;
        boolean _not;
        EList<ConfigurationItemValue> _configurationItemValues = setup.getConfigurationItemValues();
        for (final ConfigurationItemValue value : _configurationItemValues) {
            EObject ref;
            Expression itemValue = value.getValue();
            if (itemValue == null) {
                return;
            }
            ITypeSystemInferrer.InferenceResult configItemType = this.inferrer.infer((EObject)value.getItem());
            ITypeSystemInferrer.InferenceResult valueType = this.inferrer.infer((EObject)itemValue);
            IValidationIssueAcceptor _function = new IValidationIssueAcceptor(){

                public void accept(IValidationIssueAcceptor.ValidationIssue it) {
                    ProgramSetupValidator.this.error(it.getMessage(), value, (EStructuralFeature)ProgramPackage.Literals.CONFIGURATION_ITEM_VALUE__VALUE);
                }
            };
            this.typeValidator.assertAssignable(configItemType, valueType, String.format(INCOMPATIBLE_VALUE_TYPE_MSG, valueType, configItemType), _function);
            if (!(itemValue instanceof ElementReferenceExpression) || (ref = ((ElementReferenceExpression)itemValue).getReference()) instanceof SumAlternative || ref instanceof StructureType || !(ref instanceof Type)) continue;
            this.error(String.format("Value has to be an instance of '%s'", configItemType), value, (EStructuralFeature)ProgramPackage.eINSTANCE.getConfigurationItemValue_Value(), INCOMPATIBLE_VALUE_TYPE_CODE, new String[0]);
        }
        Functions.Function1<ConfigurationItemValue, String> _function = new Functions.Function1<ConfigurationItemValue, String>(){

            public String apply(ConfigurationItemValue x) {
                return x.getItem().getName();
            }
        };
        Functions.Function1<Map.Entry<String, List<ConfigurationItemValue>>, Boolean> _function_1 = new Functions.Function1<Map.Entry<String, List<ConfigurationItemValue>>, Boolean>(){

            public Boolean apply(Map.Entry<String, List<ConfigurationItemValue>> x) {
                int _length = ((Object[])Conversions.unwrapArray(x.getValue(), Object.class)).length;
                return _length > 1;
            }
        };
        Consumer<Map.Entry<String, List<ConfigurationItemValue>>> _function_2 = new Consumer<Map.Entry<String, List<ConfigurationItemValue>>>(){

            @Override
            public void accept(Map.Entry<String, List<ConfigurationItemValue>> x) {
                ProgramSetupValidator.this.error(String.format(ProgramSetupValidator.CONFIG_ITEM_VALUE_NOT_UNIQUE_MSG, x.getKey()), (EObject)IterableExtensions.last((Iterable)x.getValue()), (EStructuralFeature)ProgramPackage.eINSTANCE.getConfigurationItemValue_Item(), ProgramSetupValidator.CONFIG_ITEM_VALUE_NOT_UNIQUE_MSG, new String[0]);
            }
        };
        IterableExtensions.filter(IterableExtensions.groupBy(setup.getConfigurationItemValues(), (Functions.Function1)_function).entrySet(), (Functions.Function1)_function_1).forEach(_function_2);
        EList _configurationItems = setup.getType().getConfigurationItems();
        Iterable _filter = null;
        if (_configurationItems != null) {
            Functions.Function1<ConfigurationItem, Boolean> _function_3 = new Functions.Function1<ConfigurationItem, Boolean>(){

                public Boolean apply(ConfigurationItem it) {
                    return it.getRequired();
                }
            };
            _filter = IterableExtensions.filter((Iterable)_configurationItems, (Functions.Function1)_function_3);
        }
        Iterable _filter_1 = null;
        if (_filter != null) {
            Functions.Function1<ConfigurationItem, Boolean> _function_4 = new Functions.Function1<ConfigurationItem, Boolean>(){

                public Boolean apply(ConfigurationItem it) {
                    Functions.Function1<ConfigurationItemValue, ConfigurationItem> _function = new Functions.Function1<ConfigurationItemValue, ConfigurationItem>(){

                        public ConfigurationItem apply(ConfigurationItemValue c) {
                            return c.getItem();
                        }
                    };
                    boolean _contains = ListExtensions.map(setup.getConfigurationItemValues(), (Functions.Function1)_function).contains(it);
                    return !_contains;
                }
            };
            _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_4);
        }
        boolean bl = _not = !(_isEmpty = IterableExtensions.isEmpty(missingConfigItems = _filter_1));
        if (_not) {
            Functions.Function1<ConfigurationItem, String> _function_5 = new Functions.Function1<ConfigurationItem, String>(){

                public String apply(ConfigurationItem c) {
                    return c.getName();
                }
            };
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)missingConfigItems, (Functions.Function1)_function_5), (CharSequence)", ");
            String _plus = "Missing configuration items: " + _join;
            this.error(_plus, null, MISSING_CONIGURATION_ITEM_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkSystemResourceSetup_uniqueSignalInstances(SystemResourceSetup setup) {
        Functions.Function1<SignalInstance, String> _function = new Functions.Function1<SignalInstance, String>(){

            public String apply(SignalInstance x) {
                return x.getName();
            }
        };
        Map vcivGroups = IterableExtensions.groupBy(setup.getSignalInstances(), (Functions.Function1)_function);
        Set _entrySet = vcivGroups.entrySet();
        for (Map.Entry group : _entrySet) {
            boolean _greaterThan;
            int _length = ((Object[])Conversions.unwrapArray(group.getValue(), Object.class)).length;
            boolean bl = _greaterThan = _length > 1;
            if (!_greaterThan) continue;
            this.error(String.format("Cannot redeclare variable '%s'.", group.getKey()), (EObject)IterableExtensions.last((Iterable)((Iterable)group.getValue())), (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME, "variable_not_unique", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkSetupNaming(SystemResourceSetup setup) {
        AbstractSystemResource setupType = setup.getType();
        if (Objects.equal((Object)setupType.getInstantiable(), (Object)Instantiability.MANY) || Objects.equal((Object)setupType.getInstantiable(), (Object)Instantiability.NAMED_SINGLETON)) {
            if (setup.getName() == null || setup.getName().trim().isEmpty()) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("setup ");
                String _firstLower = StringExtensions.toFirstLower((String)setupType.getName());
                _builder.append(_firstLower);
                _builder.append(" : ");
                String _name = setupType.getName();
                _builder.append(_name);
                _builder.append(" { }");
                String proposal = _builder.toString();
                this.error(String.format(SETUP_MUST_HAVE_NAME_MSG, proposal), setup, (EStructuralFeature)ProgramPackage.Literals.SYSTEM_RESOURCE_SETUP__TYPE, SETUP_MUST_HAVE_NAME_CODE, new String[0]);
            }
        } else {
            Instantiability _instantiable = setupType.getInstantiable();
            boolean _equals = Objects.equal((Object)_instantiable, (Object)Instantiability.NONE);
            if (_equals && setup.getName() != null && !setup.getName().trim().isEmpty()) {
                this.error(SETUP_MUST_NOT_HAVE_NAME_MSG, setup, (EStructuralFeature)ProgramPackage.Literals.SYSTEM_RESOURCE_SETUP__NAME, SETUP_MUST_NOT_HAVE_NAME_CODE, new String[0]);
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkSetupIsSingleton(final SystemResourceSetup setup) {
        if (Objects.equal((Object)setup.getType().getInstantiable(), (Object)Instantiability.NONE) || Objects.equal((Object)setup.getType().getInstantiable(), (Object)Instantiability.NAMED_SINGLETON)) {
            boolean _not;
            Functions.Function1<SystemResourceSetup, Boolean> _function = new Functions.Function1<SystemResourceSetup, Boolean>(){

                public Boolean apply(SystemResourceSetup it) {
                    String _name = it.getType().getName();
                    String _name_1 = setup.getType().getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                }
            };
            Iterator allSetupsForThisType = IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)setup.eResource().getResourceSet().getAllContents(), SystemResourceSetup.class), (Functions.Function1)_function);
            boolean _isEmpty = IteratorExtensions.isEmpty((Iterator)IteratorExtensions.tail((Iterator)allSetupsForThisType));
            boolean bl = _not = !_isEmpty;
            if (_not) {
                this.error("This system resource must only be setup once", setup, (EStructuralFeature)ProgramPackage.Literals.SYSTEM_RESOURCE_SETUP__TYPE);
            }
        }
    }

    @Inject
    public void register(EValidatorRegistrar registrar) {
    }
}

