/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.generator;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.types.Parameter;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.ConfigurationItem;
import org.eclipse.mita.platform.Modality;
import org.eclipse.mita.platform.Platform;
import org.eclipse.mita.platform.Signal;
import org.eclipse.mita.platform.SystemResourceAlias;
import org.eclipse.mita.platform.SystemResourceEvent;
import org.eclipse.mita.platform.SystemSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class PlatformDSLGenerator
extends AbstractGenerator {
    @Inject
    @Extension
    private IEObjectDocumentationProvider documentationProvider;

    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        Functions.Function1<SystemSpecification, EList<AbstractSystemResource>> _function = new Functions.Function1<SystemSpecification, EList<AbstractSystemResource>>(){

            public EList<AbstractSystemResource> apply(SystemSpecification x) {
                return x.getResources();
            }
        };
        Platform platform = (Platform)IterableExtensions.head((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)resource.getContents(), SystemSpecification.class), (Functions.Function1)_function), Platform.class));
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateSystemResourecDocumentation = this.generateSystemResourecDocumentation(platform);
        _builder.append((Object)_generateSystemResourecDocumentation);
        _builder.newLineIfNotEmpty();
        fsa.generateFile("reference.md", (CharSequence)_builder);
    }

    private String getParameterDocumentation(Signal item, Parameter parameter) {
        String doc = this.documentationProvider.getDocumentation((EObject)item);
        if (doc == null) {
            return null;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@param ");
        String _name = parameter.getName();
        _builder.append(_name);
        String paramStart = _builder.toString();
        int start = doc.indexOf(paramStart);
        if (start < 0) {
            return null;
        }
        int _start = start;
        int _length = paramStart.length();
        start = _start + _length;
        int end = doc.indexOf("@param", start);
        int _xifexpression = 0;
        _xifexpression = end < 0 ? doc.length() : end;
        end = _xifexpression;
        return doc.substring(start, end).trim();
    }

    private String getWithoutParameterDocumentation(String doc) {
        if (doc == null) {
            return null;
        }
        int end = doc.indexOf("@param");
        String _xifexpression = null;
        _xifexpression = end < 0 ? doc : doc.substring(0, end).trim();
        return _xifexpression;
    }

    public CharSequence generateSystemResourecDocumentation(Platform platform) {
        StringConcatenation _builder = new StringConcatenation();
        EList<AbstractSystemResource> _resources = platform.getResources();
        for (AbstractSystemResource resource : _resources) {
            boolean _not_4;
            boolean _not_3;
            boolean _not_2;
            boolean _not;
            _builder.append("## ");
            String _typeName = this.getTypeName(resource);
            _builder.append(_typeName);
            _builder.append(": ");
            String _name = resource.getName();
            _builder.append(_name);
            if (resource instanceof SystemResourceAlias) {
                _builder.append(" (");
                String _name_1 = ((SystemResourceAlias)resource).getDelegate().getName();
                _builder.append(_name_1);
                _builder.append(")");
            }
            _builder.newLineIfNotEmpty();
            String _documentation = this.documentationProvider.getDocumentation((EObject)resource);
            _builder.append(_documentation);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            boolean _isEmpty = resource.getConfigurationItems().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append("### Configuration Items");
                _builder.newLine();
                _builder.append("<table>");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("<thead>");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("<tr>");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("<td>Name</td>");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("<td>Description</td>");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("</tr>");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("</thead>");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("<tbody>");
                _builder.newLine();
                EList<ConfigurationItem> _configurationItems = resource.getConfigurationItems();
                for (ConfigurationItem ci : _configurationItems) {
                    boolean _tripleNotEquals;
                    boolean _not_1;
                    _builder.append("\t\t");
                    _builder.append("<tr>");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("<td><div class=\"highlight\"><pre>");
                    Boolean _required = ci.getRequired();
                    boolean bl2 = _not_1 = _required == false;
                    if (_not_1) {
                        _builder.append("<small>optional</small> ");
                    }
                    _builder.append("<b>");
                    String _name_2 = ci.getName();
                    _builder.append(_name_2, "\t\t\t");
                    _builder.append("</b> : <span class=\"kt\">");
                    Type _type = ci.getType();
                    _builder.append((Object)_type, "\t\t\t");
                    _builder.append("</span></pre></div></td>");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("<td>");
                    Expression _defaultValue = ci.getDefaultValue();
                    boolean bl3 = _tripleNotEquals = _defaultValue != null;
                    if (_tripleNotEquals) {
                        _builder.append("Defaults to <i>");
                        String _originalSpec = this.getOriginalSpec((EObject)ci.getDefaultValue());
                        _builder.append(_originalSpec, "\t\t\t");
                        _builder.append("</i>. ");
                    }
                    String _documentation_1 = this.documentationProvider.getDocumentation((EObject)ci);
                    _builder.append(_documentation_1, "\t\t\t");
                    _builder.append("</td>");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("</tr>");
                    _builder.newLine();
                }
                _builder.append("    ");
                _builder.append("</tbody>");
                _builder.newLine();
                _builder.append("</table>");
                _builder.newLine();
            }
            _builder.newLine();
            boolean _isEmpty_1 = resource.getModalities().isEmpty();
            boolean bl4 = _not_2 = !_isEmpty_1;
            if (_not_2) {
                _builder.append("#### Modalities");
                _builder.newLine();
                _builder.append("<table>");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("<thead>");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("<tr>");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("<td>Name</td>");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("<td>Description</td>");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("</tr>");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("</thead>");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("<tbody>");
                _builder.newLine();
                EList<Modality> _modalities = resource.getModalities();
                for (Modality mod : _modalities) {
                    _builder.append("\t\t");
                    _builder.append("<tr>");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("<td><div class=\"highlight\"><pre><b>");
                    String _name_3 = mod.getName();
                    _builder.append(_name_3, "\t\t\t");
                    _builder.append("</b> : <span class=\"kt\">");
                    Type _type_1 = mod.getType();
                    _builder.append((Object)_type_1, "\t\t\t");
                    _builder.append("</span></pre></div></td>");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("<td>");
                    String _documentation_2 = this.documentationProvider.getDocumentation((EObject)mod);
                    _builder.append(_documentation_2, "\t\t\t");
                    _builder.append("</td>");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("</tr>");
                    _builder.newLine();
                }
                _builder.append("    ");
                _builder.append("</tbody>");
                _builder.newLine();
                _builder.append("</table>");
                _builder.newLine();
            }
            _builder.newLine();
            boolean _isEmpty_2 = resource.getSignals().isEmpty();
            boolean bl5 = _not_3 = !_isEmpty_2;
            if (_not_3) {
                _builder.append("### Variable Configuration Items");
                _builder.newLine();
                _builder.append("<table>");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("<thead>");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("<tr>");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("<td>Name</td>");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("<td>Description</td>");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("<td>Parameters</td>");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("</tr>");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("</thead>");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("<tbody>");
                _builder.newLine();
                EList<Signal> _signals = resource.getSignals();
                for (Signal mod_1 : _signals) {
                    _builder.append("\t\t");
                    _builder.append("<tr>");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("<td><div class=\"highlight\"><pre><b>");
                    String _name_4 = mod_1.getName();
                    _builder.append(_name_4, "\t\t\t");
                    _builder.append("</b> : <span class=\"kt\">");
                    Type _type_2 = mod_1.getType();
                    _builder.append((Object)_type_2, "\t\t\t");
                    _builder.append("</span></pre></div></td>");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("<td>");
                    String _withoutParameterDocumentation = this.getWithoutParameterDocumentation(this.documentationProvider.getDocumentation((EObject)mod_1));
                    _builder.append(_withoutParameterDocumentation, "\t\t\t");
                    _builder.append("</td>");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("<td>");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t\t");
                    _builder.append("<ul>");
                    _builder.newLine();
                    EList _parameters = mod_1.getParameters();
                    for (Parameter param : _parameters) {
                        _builder.append("\t\t");
                        _builder.append("\t\t");
                        _builder.append("<li>");
                        _builder.newLine();
                        _builder.append("\t\t");
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("<div class=\"highlight\"><pre>");
                        boolean _isOptional = param.isOptional();
                        if (_isOptional) {
                            _builder.append("<small>optional</small> ");
                        }
                        _builder.append(" <b>");
                        String _name_5 = param.getName();
                        _builder.append(_name_5, "\t\t\t\t\t");
                        _builder.append("</b> : <span class=\"kt\">");
                        String _originalSpec_1 = this.getOriginalSpec((EObject)param.getTypeSpecifier());
                        _builder.append(_originalSpec_1, "\t\t\t\t\t");
                        _builder.append("</span></pre></div>");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("\t\t");
                        _builder.append("\t");
                        String _parameterDocumentation = this.getParameterDocumentation(mod_1, param);
                        _builder.append(_parameterDocumentation, "\t\t\t\t\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("\t\t");
                        _builder.append("</li>");
                        _builder.newLine();
                    }
                    _builder.append("\t\t");
                    _builder.append("\t\t");
                    _builder.append("</ul>");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("</td>");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("</tr>");
                    _builder.newLine();
                }
                _builder.append("    ");
                _builder.append("</tbody>");
                _builder.newLine();
                _builder.append("</table>");
                _builder.newLine();
            }
            _builder.newLine();
            boolean _isEmpty_3 = resource.getEvents().isEmpty();
            boolean bl6 = _not_4 = !_isEmpty_3;
            if (_not_4) {
                _builder.append("#### Events");
                _builder.newLine();
                _builder.append("<table>");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("<thead>");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("<tr>");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("<td>Name</td>");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("<td>Description</td>");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("</tr>");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("</thead>");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("<tbody>");
                _builder.newLine();
                EList<SystemResourceEvent> _events = resource.getEvents();
                for (SystemResourceEvent mod_2 : _events) {
                    _builder.append("\t\t");
                    _builder.append("<tr>");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("<td><div class=\"highlight\"><pre><b>");
                    String _name_6 = mod_2.getName();
                    _builder.append(_name_6, "\t\t\t");
                    _builder.append("</b></pre></div></td>");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("<td>");
                    String _documentation_3 = this.documentationProvider.getDocumentation((EObject)mod_2);
                    _builder.append(_documentation_3, "\t\t\t");
                    _builder.append("</td>");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("</tr>");
                    _builder.newLine();
                }
                _builder.append("    ");
                _builder.append("</tbody>");
                _builder.newLine();
                _builder.append("</table>");
                _builder.newLine();
            }
            _builder.newLine();
        }
        return _builder;
    }

    public String getTypeName(AbstractSystemResource resource) {
        String _xifexpression = null;
        if (resource instanceof SystemResourceAlias) {
            return this.getTypeName(((SystemResourceAlias)resource).getDelegate());
        }
        _xifexpression = resource.eClass().getName();
        return _xifexpression;
    }

    public String getOriginalSpec(EObject obj) {
        ICompositeNode _findActualNodeFor = NodeModelUtils.findActualNodeFor((EObject)obj);
        String _text = null;
        if (_findActualNodeFor != null) {
            _text = _findActualNodeFor.getText();
        }
        String _trim = null;
        if (_text != null) {
            _trim = _text.trim();
        }
        return _trim;
    }
}

