/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.types.typesystem;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.mita.base.types.ComplexType;
import org.eclipse.mita.base.types.EnumerationType;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.typesystem.ITypeSystem;
import org.eclipse.mita.base.types.typesystem.ITypeValueProvider;

public class GenericTypeValueProvider
implements ITypeValueProvider {
    @Inject
    private ITypeSystem typeSystem;

    @Override
    public Object defaultValue(Type type) {
        if (this.is(type = type.getOriginType(), "void")) {
            return null;
        }
        if (this.is(type, "integer")) {
            return new Long(0L);
        }
        if (this.is(type, "real")) {
            return new Double(0.0);
        }
        if (this.is(type, "boolean")) {
            return Boolean.FALSE;
        }
        if (this.is(type, "string")) {
            return new String("");
        }
        if (type instanceof EnumerationType) {
            return null;
        }
        if (type instanceof ComplexType) {
            return null;
        }
        List<Type> superTypes = this.typeSystem.getSuperTypes(type);
        if (!superTypes.isEmpty()) {
            return this.defaultValue(superTypes.get(0));
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    protected boolean is(Type type, String typeName) {
        return this.typeSystem.isSame(type, this.typeSystem.getType(typeName));
    }
}

