/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.logs.tck.application;

import io.opentelemetry.api.OpenTelemetry;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JulTest
extends Arquillian {
    @Inject
    private OpenTelemetry openTelemetry;
    private static final Logger julLogger = Logger.getLogger("jul-logger");
    private static final String logFilePath = System.getProperty("log.file.path");
    private static final String JUL_INFO_MESSAGE = "a very distinguishable info message";
    private static final String JUL_WARN_MESSAGE = "a very distinguishable warning message";

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.metrics.exporter=none\notel.traces.exporter=none\notel.logs.exporter=logging\notel.service.name=openliberty"), "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    void julInfoTest() throws IOException {
        julLogger.log(Level.INFO, JUL_INFO_MESSAGE);
        try {
            Assert.assertTrue((boolean)this.checkMessage(".*INFO.*a very distinguishable info message.*scopeInfo:.*"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    void julWarnTest() throws IOException {
        julLogger.log(Level.WARNING, JUL_WARN_MESSAGE);
        try {
            Assert.assertTrue((boolean)this.checkMessage(".*WARN.*a very distinguishable warning message.*scopeInfo:.*"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean checkMessage(String logMessage) throws IOException {
        try {
            try {
                String line;
                Thread.sleep(5000L);
                BufferedReader reader = new BufferedReader(new FileReader(logFilePath));
                while ((line = reader.readLine()) != null) {
                    if (!line.matches(logMessage)) continue;
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

