/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.properties;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.core.util.CDATemplateComputeBuilder;
import org.eclipse.mdht.uml.cda.ui.properties.ValidationSection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class TemplateSection
extends ValidationSection {
    private Text templateIdText;
    private boolean templateIdModified = false;
    private Text templateVersionText;
    private boolean templateVersionModified = false;
    private Text assigningAuthorityText;
    private boolean assigningAuthorityModified = false;
    private CCombo multiplicityCombo;
    private boolean templateMultiplicityModified = false;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (TemplateSection.this.templateIdText == event.getSource()) {
                TemplateSection.this.templateIdModified = true;
            }
            if (TemplateSection.this.assigningAuthorityText == event.getSource()) {
                TemplateSection.this.assigningAuthorityModified = true;
            }
            if (TemplateSection.this.templateVersionText == event.getSource()) {
                TemplateSection.this.templateVersionModified = true;
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if ('\r' == e.character || '\u1000050' == e.character) {
                TemplateSection.this.modifyFields();
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            TemplateSection.this.modifyFields();
        }
    };

    @Override
    protected Stereotype getValidationStereotype() {
        String qname = "CDA::CDATemplate";
        Stereotype stereotype = this.modelElement.getApplicableStereotype(qname);
        return stereotype;
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        Assert.isTrue((boolean)(element instanceof Class));
        this.modelElement = (Class)element;
    }

    @Override
    protected void modifyFields() {
        super.modifyFields();
        if (!(this.templateIdModified || this.templateVersionModified || this.assigningAuthorityModified || this.templateMultiplicityModified)) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.modelElement);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)TemplateSection.this.modelElement, (String)"CDATemplate");
                    if (stereotype == null) {
                        stereotype = CDAProfileUtil.applyCDAStereotype((Element)TemplateSection.this.modelElement, (String)"CDATemplate");
                    }
                    if (TemplateSection.this.templateIdModified) {
                        TemplateSection.this.templateIdModified = false;
                        this.setLabel("Set CDA Template ID");
                        if (stereotype != null) {
                            String value = TemplateSection.this.templateIdText.getText().trim();
                            TemplateSection.this.modelElement.setValue(stereotype, "templateId", (Object)(value.length() > 0 ? value : null));
                        }
                    } else if (TemplateSection.this.templateVersionModified) {
                        TemplateSection.this.templateVersionModified = false;
                        this.setLabel("Set CDA Template Version");
                        if (stereotype != null) {
                            String value = TemplateSection.this.templateVersionText.getText().trim();
                            TemplateSection.this.modelElement.setValue(stereotype, "templateVersion", (Object)(value.length() > 0 ? value : null));
                        }
                    } else if (TemplateSection.this.assigningAuthorityModified) {
                        TemplateSection.this.assigningAuthorityModified = false;
                        this.setLabel("Set CDA Template Authority");
                        if (stereotype != null) {
                            String value = TemplateSection.this.assigningAuthorityText.getText().trim();
                            TemplateSection.this.modelElement.setValue(stereotype, "assigningAuthorityName", (Object)(value.length() > 0 ? value : null));
                        }
                    } else if (TemplateSection.this.templateMultiplicityModified) {
                        TemplateSection.this.templateMultiplicityModified = false;
                        this.setLabel("Set CDA Template Multiplicity");
                        if (stereotype != null) {
                            String value = TemplateSection.this.multiplicityCombo.getText().trim();
                            TemplateSection.this.modelElement.setValue(stereotype, "templateMultiplicity", (Object)(value.length() > 0 ? value : null));
                        }
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Group composite = this.getWidgetFactory().createGroup(parent, "CDA Template");
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 4;
        layout.spacing = 7;
        composite.setLayout((Layout)layout);
        FormData data = null;
        this.templateIdText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel templateIdLabel = this.getWidgetFactory().createCLabel((Composite)composite, "ID:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.templateIdText, 0, 0x1000000);
        templateIdLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)templateIdLabel, 0);
        data.width = 200;
        data.top = new FormAttachment(0, 2, 4);
        this.templateIdText.setLayoutData((Object)data);
        this.templateVersionText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel templateVersionLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Template Version:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.templateIdText, 5);
        data.top = new FormAttachment((Control)this.templateVersionText, 0, 0x1000000);
        templateVersionLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)templateVersionLabel, 0);
        data.width = 100;
        data.top = new FormAttachment(0, 2, 4);
        this.templateVersionText.setLayoutData((Object)data);
        this.assigningAuthorityText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel assigningAuthorityLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Assigning Authority:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.templateVersionText, 5);
        data.top = new FormAttachment((Control)this.assigningAuthorityText, 0, 0x1000000);
        assigningAuthorityLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)assigningAuthorityLabel, 0);
        data.width = 200;
        data.top = new FormAttachment(0, 2, 4);
        this.assigningAuthorityText.setLayoutData((Object)data);
        this.createRestoreDefaultsButton((Composite)composite);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.assigningAuthorityText, 0, 0x1000000);
        this.restoreDefaultsButton.setLayoutData((Object)data);
        CLabel multiplicityLabel = this.getWidgetFactory().createCLabel((Composite)composite, "templateId Multiplicity:");
        this.multiplicityCombo = this.getWidgetFactory().createCCombo((Composite)composite, 0x800000);
        this.multiplicityCombo.setItems(new String[]{"1", "1..*"});
        this.multiplicityCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TemplateSection.this.multiplicitySet();
            }

            public void widgetSelected(SelectionEvent e) {
                TemplateSection.this.multiplicitySet();
            }
        });
        data = new FormData();
        data.left = new FormAttachment((Control)this.assigningAuthorityText, 0, 0x1000000);
        data.top = new FormAttachment((Control)this.assigningAuthorityText, 4);
        multiplicityLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)multiplicityLabel, 5);
        data.top = new FormAttachment((Control)multiplicityLabel, 0, 0x1000000);
        this.multiplicityCombo.setLayoutData((Object)data);
        this.addValidationControls((Composite)composite, 1, 2);
    }

    @Override
    public void refresh() {
        String id;
        super.refresh();
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)this.modelElement, (String)"CDATemplate");
        this.templateIdText.removeModifyListener(this.modifyListener);
        this.templateIdText.removeKeyListener(this.keyListener);
        this.templateIdText.removeFocusListener(this.focusListener);
        if (stereotype != null) {
            id = (String)this.modelElement.getValue(stereotype, "templateId");
            this.templateIdText.setText(id != null ? id : "");
        } else {
            this.templateIdText.setText("");
        }
        this.templateIdText.addModifyListener(this.modifyListener);
        this.templateIdText.addKeyListener(this.keyListener);
        this.templateIdText.addFocusListener(this.focusListener);
        this.templateVersionText.removeModifyListener(this.modifyListener);
        this.templateVersionText.removeKeyListener(this.keyListener);
        this.templateVersionText.removeFocusListener(this.focusListener);
        if (stereotype != null) {
            String version = (String)this.modelElement.getValue(stereotype, "templateVersion");
            this.templateVersionText.setText(version != null ? version : "");
        } else {
            this.templateVersionText.setText("");
        }
        this.templateVersionText.addModifyListener(this.modifyListener);
        this.templateVersionText.addKeyListener(this.keyListener);
        this.templateVersionText.addFocusListener(this.focusListener);
        this.assigningAuthorityText.removeModifyListener(this.modifyListener);
        this.assigningAuthorityText.removeKeyListener(this.keyListener);
        this.assigningAuthorityText.removeFocusListener(this.focusListener);
        if (stereotype != null) {
            id = (String)this.modelElement.getValue(stereotype, "assigningAuthorityName");
            this.assigningAuthorityText.setText(id != null ? id : "");
        } else {
            this.assigningAuthorityText.setText("");
        }
        this.assigningAuthorityText.addModifyListener(this.modifyListener);
        this.assigningAuthorityText.addKeyListener(this.keyListener);
        this.assigningAuthorityText.addFocusListener(this.focusListener);
        if (this.isReadOnly()) {
            this.templateIdText.setEnabled(false);
            this.templateVersionText.setEnabled(false);
            this.assigningAuthorityText.setEnabled(false);
            this.restoreDefaultsButton.setEnabled(false);
        } else {
            this.templateIdText.setEnabled(true);
            this.templateVersionText.setEnabled(true);
            this.assigningAuthorityText.setEnabled(true);
            this.restoreDefaultsButton.setEnabled(stereotype != null);
        }
        String multiplicityVal = null;
        if (stereotype != null) {
            multiplicityVal = (String)this.modelElement.getValue(stereotype, "templateMultiplicity");
        }
        this.multiplicityCombo.setText(CDATemplateComputeBuilder.getMultiplicityRange(multiplicityVal));
    }

    private void multiplicitySet() {
        String selectedTxt = this.multiplicityCombo.getText();
        if ("1".equals(selectedTxt)) {
            this.multiplicityCombo.setText("1..1");
        }
        this.templateMultiplicityModified = true;
        this.modifyFields();
    }
}

