/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.properties;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MemoDialog
extends Dialog {
    private String title;
    private String value = "";
    private Text text;
    private boolean editable;

    public MemoDialog(Shell parentShell, String dialogTitle, String initialValue) {
        super(parentShell);
        this.title = dialogTitle;
        this.value = initialValue == null ? "" : initialValue;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        if (this.editable) {
            this.createButton(parent, 1, "Cancel", false);
        }
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.text = new Text(composite, this.getInputTextStyle());
        this.text.setText(this.value);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        Font font = new Font((Device)this.text.getDisplay(), "Courier New", 13, 0);
        this.text.setFont(font);
        MemoDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected int getInputTextStyle() {
        if (this.editable) {
            return 2818;
        }
        return 2826;
    }

    public static boolean openInformation(Shell parent, String title, String message) {
        MemoDialog dialog = new MemoDialog(parent, title, message);
        return dialog.open() == 0;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.text.getText() : null;
        super.buttonPressed(buttonId);
    }

    public String getValue() {
        return this.value;
    }
}

